/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.communication;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jamocha.application.gui.JamochaGui;
import org.jamocha.communication.events.MessageEvent;
import org.jamocha.communication.messagerouter.StringChannel;
import org.jamocha.engine.Engine;
import org.jamocha.parser.JamochaValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchThread
extends Thread {
    private final Engine engine;
    private JamochaGui gui = null;
    private boolean running = true;
    private final StringChannel batchChannel;
    Queue<String> batchFiles = new ConcurrentLinkedQueue<String>();
    private final Map<String, String> batchResults = new HashMap<String, String>();

    public BatchThread(Engine engine) {
        this.engine = engine;
        this.batchChannel = engine.getMessageRouter().openChannel("batch_channel");
    }

    @Override
    public void run() {
        StringBuilder buffer = new StringBuilder();
        while (this.running) {
            ArrayList<MessageEvent> messages = new ArrayList<MessageEvent>();
            this.getBatchChannel().fillEventList(messages);
            if (!messages.isEmpty()) {
                for (MessageEvent event : messages) {
                    if (event.getType() == MessageEvent.MessageEventType.ERROR) {
                        buffer.append(JamochaGui.exceptionToString((Exception)event.getMessage()).trim() + System.getProperty("line.separator"));
                    }
                    if (event.getType() != MessageEvent.MessageEventType.COMMAND && event.getMessage() != null && !event.getMessage().toString().equals("") && !event.getMessage().equals(JamochaValue.NIL)) {
                        buffer.append(event.getMessage().toString().trim() + System.getProperty("line.separator"));
                    }
                    if (event.getType() != MessageEvent.MessageEventType.PARSE_ERROR && event.getType() != MessageEvent.MessageEventType.ERROR && event.getType() != MessageEvent.MessageEventType.RESULT) continue;
                    this.batchResults.put(this.batchFiles.poll(), buffer.toString());
                    buffer = new StringBuilder();
                    if (this.gui == null) continue;
                    this.gui.informOfNewBatchResults();
                }
                continue;
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
        this.engine.getMessageRouter().closeChannel(this.batchChannel);
    }

    public void setGui(JamochaGui gui) {
        this.gui = gui;
    }

    public void stopThread() {
        this.running = false;
    }

    public Map<String, String> getBatchResults() {
        return this.batchResults;
    }

    public StringChannel getBatchChannel() {
        return this.batchChannel;
    }

    public void processBatchFiles(List<String> files) {
        if (files != null && !files.isEmpty()) {
            for (String file : files) {
                this.getBatchChannel().executeCommand("(batch " + file + ")");
                this.batchFiles.offer(file + " (" + this.getDatetimeFormatted() + ")");
            }
        }
    }

    public String getDatetimeFormatted() {
        StringBuilder res = new StringBuilder();
        Calendar datetime = Calendar.getInstance();
        res.append(datetime.get(1) + "/");
        res.append((datetime.get(2) + 1 > 9 ? "" : "0") + (datetime.get(2) + 1) + "/");
        res.append((datetime.get(5) > 9 ? "" : "0") + datetime.get(5) + " - ");
        res.append((datetime.get(11) > 9 ? "" : "0") + datetime.get(11) + ":");
        res.append((datetime.get(12) > 9 ? "" : "0") + datetime.get(12) + ":");
        res.append((datetime.get(13) > 9 ? "" : "0") + datetime.get(13));
        return res.toString();
    }
}

