/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.application.gui.tab;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import org.jamocha.application.gui.JamochaGui;
import org.jamocha.application.gui.TableModelQuickSort;
import org.jamocha.application.gui.TableRowModel;
import org.jamocha.application.gui.editor.TemplateEditor;
import org.jamocha.application.gui.icons.IconLoader;
import org.jamocha.application.gui.tab.AbstractJamochaPanel;
import org.jamocha.engine.modules.Module;
import org.jamocha.engine.workingmemory.elements.Deftemplate;
import org.jamocha.engine.workingmemory.elements.Template;
import org.jamocha.engine.workingmemory.elements.TemplateSlot;
import org.jamocha.parser.ParserFactory;

public class TemplatesPanel
extends AbstractJamochaPanel
implements ListSelectionListener,
ActionListener {
    private static final String GUI_TEMPLATES_DIVIDERLOCATION = "gui.templates.dividerlocation";
    private static final long serialVersionUID = -5732131176258158968L;
    private final JSplitPane pane;
    private final JTable templatesTable;
    private final TemplatesTableModel dataModel;
    private final JButton reloadButton;
    private final JButton createNewButton;
    private final JTextArea dumpArea;

    public TemplatesPanel(JamochaGui gui) {
        super(gui);
        this.setLayout(new BorderLayout());
        this.dataModel = new TemplatesTableModel();
        this.templatesTable = new JTable(this.dataModel);
        this.templatesTable.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = TemplatesPanel.this.templatesTable.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                int column = TemplatesPanel.this.templatesTable.convertColumnIndexToModel(viewColumn);
                if (e.getClickCount() == 1 && column != -1) {
                    int shiftPressed = e.getModifiers() & 1;
                    boolean ascending = shiftPressed == 0;
                    TableModelQuickSort.sort(TemplatesPanel.this.dataModel, ascending, column);
                }
            }
        });
        this.templatesTable.setShowHorizontalLines(true);
        this.templatesTable.setRowSelectionAllowed(true);
        this.templatesTable.getTableHeader().setReorderingAllowed(false);
        this.templatesTable.getTableHeader().setToolTipText("Click to sort ascending. Click while pressing the shift-key down to sort descending");
        this.templatesTable.getSelectionModel().addListSelectionListener(this);
        this.dumpArea = new JTextArea();
        this.dumpArea.setLineWrap(true);
        this.dumpArea.setWrapStyleWord(true);
        this.dumpArea.setEditable(false);
        this.dumpArea.setFont(new Font("Courier", 0, 12));
        this.pane = new JSplitPane(0, new JScrollPane(this.templatesTable), new JScrollPane(this.dumpArea));
        this.add((Component)this.pane, "Center");
        this.pane.setDividerLocation(this.settings.getInt(GUI_TEMPLATES_DIVIDERLOCATION));
        this.reloadButton = new JButton("Reload Templates", IconLoader.getImageIcon("arrow_refresh"));
        this.reloadButton.addActionListener(this);
        this.createNewButton = new JButton("Create new Template", IconLoader.getImageIcon("brick_add"));
        this.createNewButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2, 5, 1));
        buttonPanel.add(this.reloadButton);
        buttonPanel.add(this.createNewButton);
        this.add((Component)buttonPanel, "Last");
        this.initPopupMenu();
    }

    private void initTemplatesList() {
        this.dataModel.clear();
        Collection<Module> modules = this.gui.getEngine().getModules().getModuleList();
        for (Module module : modules) {
            List<Template> templates = module.getTemplates();
            this.dataModel.addTemplates(templates, module);
        }
        this.templatesTable.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.templatesTable.getColumnModel().getColumn(1).setPreferredWidth(this.templatesTable.getWidth() - 100);
    }

    private void initPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem removeItem = new JMenuItem("Remove selected Template(s)", IconLoader.getImageIcon("brick_delete"));
        removeItem.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent event) {
                int[] selCols = TemplatesPanel.this.templatesTable.getSelectedRows();
                for (int i = 0; i < selCols.length; ++i) {
                    String modName = (String)TemplatesPanel.this.dataModel.getValueAt(selCols[i], 0);
                    TemplatesPanel.this.gui.getEngine().findModule(modName).removeTemplate(((ExtTemplate)TemplatesPanel.this.dataModel.getRowAt(selCols[i])).getTemplate());
                }
                TemplatesPanel.this.initTemplatesList();
            }
        });
        menu.add(removeItem);
        this.templatesTable.setComponentPopupMenu(menu);
    }

    public void setFocus() {
        super.setFocus();
        this.initTemplatesList();
    }

    public void close() {
        this.settings.set(GUI_TEMPLATES_DIVIDERLOCATION, this.pane.getDividerLocation());
    }

    public void settingsChanged() {
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.reloadButton)) {
            this.initTemplatesList();
        } else if (event.getSource().equals(this.createNewButton)) {
            TemplateEditor editor = new TemplateEditor(this.gui.getEngine());
            editor.setStringChannel(this.gui.getStringChannel());
            editor.init();
        }
    }

    public void valueChanged(ListSelectionEvent arg0) {
        if (arg0.getSource() == this.templatesTable.getSelectionModel()) {
            ExtTemplate template;
            StringBuilder buffer = new StringBuilder();
            if (this.templatesTable.getSelectedColumnCount() == 1 && this.templatesTable.getSelectedRow() > -1 && (template = (ExtTemplate)this.dataModel.getRowAt(this.templatesTable.getSelectedRow())) != null) {
                TemplateSlot[] slots;
                buffer.append("(").append(template.getModule().getName()).append("::").append(template.getTemplate().getName());
                String description = null;
                if (template.getTemplate() instanceof Deftemplate) {
                    description = ((Deftemplate)template.getTemplate()).getDescription();
                }
                if (description != null && description.length() > 0) {
                    buffer.append("\n   Description: ").append(description).append("\n");
                }
                for (TemplateSlot slot : slots = template.getTemplate().getAllSlots()) {
                    buffer.append("\n    (");
                    if (slot.isSilent()) {
                        buffer.append("silent ");
                    }
                    if (slot.isMultiSlot()) {
                        buffer.append("multislot ").append(slot.getName());
                    } else {
                        buffer.append("slot ").append(slot.getName());
                    }
                    buffer.append("\n        (type ").append(slot.getValueType().toString()).append(")");
                    if (slot.getDefaultExpression() != null) {
                        buffer.append("\n        (default ");
                        buffer.append(slot.getDefaultExpression().format(ParserFactory.getFormatter()));
                        buffer.append(")");
                    }
                    buffer.append("\n    )");
                }
                buffer.append("\n)");
            }
            this.dumpArea.setText(buffer.toString());
        }
    }

    private class ExtTemplate {
        private final Template template;
        private final Module module;

        private ExtTemplate(Template template, Module module) {
            this.template = template;
            this.module = module;
        }

        private Template getTemplate() {
            return this.template;
        }

        private Module getModule() {
            return this.module;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class TemplatesTableModel
    extends AbstractTableModel
    implements TableRowModel {
        private static final long serialVersionUID = 1L;
        private List<ExtTemplate> templates = new LinkedList<ExtTemplate>();

        private TemplatesTableModel() {
        }

        private void clear() {
            this.templates = new LinkedList<ExtTemplate>();
            this.fireTableDataChanged();
        }

        private void addTemplates(Collection<Template> templates, Module module) {
            for (Template template : templates) {
                ExtTemplate exttemp = new ExtTemplate(template, module);
                this.templates.add(exttemp);
            }
            this.fireTableDataChanged();
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Module";
                }
                case 1: {
                    return "Template";
                }
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public Class getColumnClass(int aColumn) {
            if (aColumn == 0) {
                return String.class;
            }
            if (aColumn == 1) {
                return String.class;
            }
            return Class.class;
        }

        @Override
        public int getRowCount() {
            return this.templates.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            ExtTemplate template = (ExtTemplate)this.getRowAt(row);
            switch (column) {
                case 0: {
                    return template.getModule().getName();
                }
                case 1: {
                    return template.getTemplate().getName();
                }
            }
            return null;
        }

        @Override
        public Object getRowAt(int row) {
            return this.templates.get(row);
        }

        @Override
        public void setRowAt(Object value, int row) {
            this.templates.set(row, (ExtTemplate)value);
        }
    }
}

