/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.application.gui.tab;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.jamocha.application.gui.JamochaGui;
import org.jamocha.application.gui.icons.IconLoader;
import org.jamocha.application.gui.tab.AbstractJamochaPanel;
import org.jamocha.application.gui.tab.settings.AbstractSettingsPanel;
import org.jamocha.application.gui.tab.settings.EngineSettingsPanel;
import org.jamocha.application.gui.tab.settings.GUISettingsPanel;

public class SettingsPanel
extends AbstractJamochaPanel
implements ActionListener {
    private static final long serialVersionUID = 1934727733895902279L;
    private final JTabbedPane tabbedPane;
    private final JButton allDefaultButton;
    private final List<AbstractSettingsPanel> panels = new LinkedList<AbstractSettingsPanel>();

    public SettingsPanel(JamochaGui gui) {
        super(gui);
        this.setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane();
        EngineSettingsPanel engineSettingsPanel = new EngineSettingsPanel(gui);
        this.tabbedPane.addTab("Engine", null, engineSettingsPanel, "Engine Settings");
        this.panels.add(engineSettingsPanel);
        GUISettingsPanel guiSettingsPanel = new GUISettingsPanel(gui);
        this.tabbedPane.addTab("GUI", null, guiSettingsPanel, "GUI Settings");
        this.panels.add(guiSettingsPanel);
        for (AbstractSettingsPanel panel : this.panels) {
            panel.refresh();
        }
        this.add((Component)this.tabbedPane, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(2, 5, 1));
        this.allDefaultButton = new JButton("All back to default", IconLoader.getImageIcon("cog_go"));
        this.allDefaultButton.addActionListener(this);
        buttonPanel.add(this.allDefaultButton);
        this.add((Component)buttonPanel, "South");
    }

    public void close() {
    }

    public void settingsChanged() {
    }

    public void setFocus() {
        super.setFocus();
        for (AbstractSettingsPanel panel : this.panels) {
            panel.refresh();
        }
    }

    public void actionPerformed(ActionEvent event) {
        int sel;
        if (event.getSource() == this.allDefaultButton && (sel = JOptionPane.showConfirmDialog(this, "Do you really want to set everything to default?", "Attention", 0)) == 0) {
            for (AbstractSettingsPanel panel : this.panels) {
                panel.setDefaults();
            }
        }
    }
}

