/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.application.gui.tab;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import org.jamocha.application.gui.JamochaGui;
import org.jamocha.application.gui.TableModelQuickSort;
import org.jamocha.application.gui.TableRowModel;
import org.jamocha.application.gui.icons.IconLoader;
import org.jamocha.application.gui.tab.AbstractJamochaPanel;
import org.jamocha.communication.messagerouter.StringChannel;
import org.jamocha.engine.functions.Function;
import org.jamocha.engine.functions.FunctionGroup;
import org.jamocha.engine.functions.FunctionMemory;
import org.jamocha.engine.functions.FunctionNotFoundException;
import org.jamocha.formatter.HelpFormatter;

public class FunctionsPanel
extends AbstractJamochaPanel
implements ActionListener,
ListSelectionListener {
    private static final String GUI_FUNCTIONS_DIVIDERLOCATION = "gui.functions.dividerlocation";
    private static final String GUI_FUNCTIONS_FUNCTIONGROUPS_DIVIDERLOCATION = "gui.functions.functiongroups_dividerlocation";
    private static final long serialVersionUID = 23L;
    private final String SHOW_ALL = "all Functions";
    private final JTextArea dumpAreaFunction;
    private final JSplitPane pane;
    private final JSplitPane listPane;
    private final JList functionGroupList;
    private final JTable functionsTable;
    private final FunctionGroupDataModel funcGroupsDataModel;
    private final FunctionsTableModel funcsDataModel;
    private StringChannel editorChannel;
    private final JButton reloadButton;

    public FunctionsPanel(JamochaGui gui) {
        super(gui);
        this.setLayout(new BorderLayout());
        this.funcGroupsDataModel = new FunctionGroupDataModel();
        this.functionGroupList = new JList(this.funcGroupsDataModel){
            private static final long serialVersionUID = 1L;

            public String getToolTipText(MouseEvent event) {
                Point point = event.getPoint();
                int index = this.locationToIndex(point);
                return FunctionsPanel.this.funcGroupsDataModel.getFunctionDescriptionAt(index);
            }
        };
        this.functionGroupList.setSelectionMode(0);
        this.functionGroupList.addListSelectionListener(this);
        this.funcsDataModel = new FunctionsTableModel();
        this.functionsTable = new JTable(this.funcsDataModel);
        this.functionsTable.setSelectionMode(0);
        this.functionsTable.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = FunctionsPanel.this.functionsTable.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                int column = FunctionsPanel.this.functionsTable.convertColumnIndexToModel(viewColumn);
                if (e.getClickCount() == 1 && column != -1) {
                    int shiftPressed = e.getModifiers() & 1;
                    boolean ascending = shiftPressed == 0;
                    TableModelQuickSort.sort(FunctionsPanel.this.funcsDataModel, ascending, column);
                }
            }
        });
        this.functionsTable.setShowHorizontalLines(false);
        this.functionsTable.setRowSelectionAllowed(true);
        this.functionsTable.getTableHeader().setReorderingAllowed(false);
        this.functionsTable.getTableHeader().setToolTipText("Click to sort ascending. Click while pressing the shift-key down to sort descending");
        this.functionsTable.getSelectionModel().addListSelectionListener(this);
        this.listPane = new JSplitPane(1, new JScrollPane(this.functionGroupList), new JScrollPane(this.functionsTable));
        this.listPane.setDividerLocation(this.settings.getInt(GUI_FUNCTIONS_FUNCTIONGROUPS_DIVIDERLOCATION));
        this.dumpAreaFunction = new JTextArea();
        this.dumpAreaFunction.setLineWrap(true);
        this.dumpAreaFunction.setWrapStyleWord(true);
        this.dumpAreaFunction.setEditable(false);
        this.dumpAreaFunction.setFont(new Font("Courier", 0, 12));
        this.pane = new JSplitPane(0, this.listPane, new JScrollPane(this.dumpAreaFunction));
        this.add((Component)this.pane, "Center");
        this.pane.setDividerLocation(this.settings.getInt(GUI_FUNCTIONS_DIVIDERLOCATION));
        this.reloadButton = new JButton("Reload Functions", IconLoader.getImageIcon("arrow_refresh"));
        this.reloadButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2, 5, 1));
        buttonPanel.add(this.reloadButton);
        this.add((Component)buttonPanel, "Last");
        this.initFunctionGroupsList();
        this.initFunctionsList(null);
    }

    private void initFunctionGroupsList() {
        boolean swap;
        this.functionGroupList.setSelectedIndex(0);
        LinkedList<FunctionGroup> funcGroups = new LinkedList<FunctionGroup>(this.gui.getEngine().getFunctionMemory().getFunctionGroups().values());
        int n = funcGroups.size() - 1;
        do {
            swap = false;
            for (int i = 0; i < n; ++i) {
                if (((FunctionGroup)funcGroups.get(i)).getName().compareToIgnoreCase(((FunctionGroup)funcGroups.get(i + 1)).getName()) <= 0) continue;
                FunctionGroup temp = (FunctionGroup)funcGroups.get(i);
                funcGroups.set(i, (FunctionGroup)funcGroups.get(i + 1));
                funcGroups.set(i + 1, temp);
                swap = true;
            }
            --n;
        } while (swap);
        funcGroups.add(0, new FunctionGroup(){
            private static final long serialVersionUID = 1L;

            public String getName() {
                return "all Functions";
            }

            public String getDescription() {
                return "View the Functions of all Groups";
            }

            public void loadFunctions(FunctionMemory functionMem) {
            }
        });
        this.funcGroupsDataModel.setFunctionGroups(funcGroups);
    }

    private void initFunctionsList(String funcGroupName) {
        Collection<Function> c = funcGroupName == null || funcGroupName.equals("all Functions") ? this.gui.getEngine().getFunctionMemory().getAllFunctions() : this.gui.getEngine().getFunctionMemory().getFunctionsOfGroup(funcGroupName);
        this.funcsDataModel.setFunctions(new ArrayList<Function>(c));
        TableModelQuickSort.sort(this.funcsDataModel, true, 0);
        this.functionsTable.getColumnModel().getColumn(0).setPreferredWidth(50);
    }

    public void setFocus() {
        super.setFocus();
    }

    public void close() {
        if (this.editorChannel != null) {
            this.gui.getEngine().getMessageRouter().closeChannel(this.editorChannel);
        }
        this.settings.set(GUI_FUNCTIONS_DIVIDERLOCATION, this.pane.getDividerLocation());
        this.settings.set(GUI_FUNCTIONS_FUNCTIONGROUPS_DIVIDERLOCATION, this.listPane.getDividerLocation());
    }

    public void settingsChanged() {
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.reloadButton)) {
            this.initFunctionGroupsList();
            this.initFunctionsList(null);
        }
    }

    public void valueChanged(ListSelectionEvent arg0) {
        if (arg0.getSource() == this.functionsTable.getSelectionModel()) {
            StringBuilder buffer = new StringBuilder();
            if (this.functionsTable.getSelectedColumnCount() == 1 && this.functionsTable.getSelectedRow() > -1) {
                String functionName = this.funcsDataModel.getRowAt(this.functionsTable.getSelectedRow()).toString();
                try {
                    Function function = this.gui.getEngine().getFunctionMemory().findFunction(functionName);
                    buffer.append(function.format(new HelpFormatter()));
                }
                catch (FunctionNotFoundException e) {
                    buffer.append("there are problems while looking up the function " + functionName);
                }
            }
            this.dumpAreaFunction.setText(buffer.toString());
            this.dumpAreaFunction.setCaretPosition(0);
        } else if (arg0.getSource() == this.functionGroupList) {
            this.initFunctionsList((String)this.functionGroupList.getSelectedValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class FunctionsTableModel
    extends AbstractTableModel
    implements TableRowModel {
        private static final long serialVersionUID = 1L;
        private List<String> funcnameList = Collections.emptyList();

        private FunctionsTableModel() {
        }

        private void setFunctions(List<Function> funcList) {
            this.funcnameList = new LinkedList<String>();
            for (Function func : funcList) {
                if (this.funcnameList.contains(func.getName())) continue;
                this.funcnameList.add(func.getName());
                List<String> aliases = func.getAliases();
                for (String alias : aliases) {
                    this.funcnameList.add(alias);
                }
            }
            this.fireTableDataChanged();
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Functions";
                }
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public Class getColumnClass(int aColumn) {
            if (aColumn == 0) {
                return String.class;
            }
            return Class.class;
        }

        @Override
        public int getRowCount() {
            return this.funcnameList.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            return this.getRowAt(row).toString();
        }

        @Override
        public Object getRowAt(int row) {
            return this.funcnameList.get(row);
        }

        @Override
        public void setRowAt(Object value, int row) {
            this.funcnameList.set(row, value.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class FunctionGroupDataModel
    extends AbstractListModel {
        private static final long serialVersionUID = 1L;
        List<FunctionGroup> funcGroups;

        private FunctionGroupDataModel() {
        }

        public void setFunctionGroups(List<FunctionGroup> funcGroups) {
            this.funcGroups = funcGroups;
            this.fireContentsChanged(this, 0, funcGroups.size());
        }

        @Override
        public Object getElementAt(int index) {
            return this.funcGroups.get(index).getName();
        }

        public String getFunctionDescriptionAt(int index) {
            if (index < this.funcGroups.size() && index >= 0) {
                return this.funcGroups.get(index).getDescription();
            }
            return "";
        }

        @Override
        public int getSize() {
            if (this.funcGroups == null) {
                return 0;
            }
            return this.funcGroups.size();
        }
    }
}

