/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.application.gui.tab;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import org.jamocha.application.gui.JamochaGui;
import org.jamocha.application.gui.TableModelQuickSort;
import org.jamocha.application.gui.TableRowModel;
import org.jamocha.application.gui.editor.FactEditor;
import org.jamocha.application.gui.icons.IconLoader;
import org.jamocha.application.gui.tab.AbstractJamochaPanel;
import org.jamocha.engine.RetractException;
import org.jamocha.engine.workingmemory.elements.Fact;
import org.jamocha.formatter.HelpFormatter;

public class FactsPanel
extends AbstractJamochaPanel
implements ActionListener,
ListSelectionListener {
    private static final String GUI_FACTS_AUTOSORT_DIR = "gui.facts.autosort_dir";
    private static final String GUI_FACTS_AUTOSORT_BY = "gui.facts.autosort_by";
    private static final String GUI_FACTS_DIVIDERLOCATION = "gui.facts.dividerlocation";
    private static final long serialVersionUID = -5732131176258158968L;
    private final JSplitPane pane;
    private final JTable factsTable;
    private final FactsTableModel dataModel;
    private final JButton reloadButton;
    private final JButton assertButton;
    private final JTextArea dumpArea;

    public FactsPanel(JamochaGui gui) {
        super(gui);
        this.setLayout(new BorderLayout());
        this.dataModel = new FactsTableModel();
        this.factsTable = new JTable(this.dataModel);
        this.factsTable.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = FactsPanel.this.factsTable.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                int column = FactsPanel.this.factsTable.convertColumnIndexToModel(viewColumn);
                if (e.getClickCount() == 1 && column != -1) {
                    int shiftPressed = e.getModifiers() & 1;
                    boolean ascending = shiftPressed == 0;
                    TableModelQuickSort.sort(FactsPanel.this.dataModel, ascending, column);
                }
            }
        });
        this.factsTable.setShowHorizontalLines(true);
        this.factsTable.setRowSelectionAllowed(true);
        this.factsTable.getTableHeader().setReorderingAllowed(false);
        this.factsTable.getTableHeader().setToolTipText("Click to sort ascending. Click while pressing the shift-key down to sort descending");
        this.factsTable.getSelectionModel().addListSelectionListener(this);
        this.dumpArea = new JTextArea();
        this.dumpArea.setLineWrap(true);
        this.dumpArea.setWrapStyleWord(true);
        this.dumpArea.setEditable(false);
        this.dumpArea.setFont(new Font("Courier", 0, 12));
        this.pane = new JSplitPane(0, new JScrollPane(this.factsTable), new JScrollPane(this.dumpArea));
        this.add((Component)this.pane, "Center");
        this.pane.setDividerLocation(this.settings.getInt(GUI_FACTS_DIVIDERLOCATION));
        this.reloadButton = new JButton("Reload Facts", IconLoader.getImageIcon("database_refresh"));
        this.reloadButton.addActionListener(this);
        this.assertButton = new JButton("Assert Fact", IconLoader.getImageIcon("database_add"));
        this.assertButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2, 5, 1));
        buttonPanel.add(this.reloadButton);
        buttonPanel.add(this.assertButton);
        this.add((Component)buttonPanel, "Last");
        this.initPopupMenu();
    }

    private void initFactsList() {
        List<Fact> facts = this.gui.getEngine().getModules().getAllFacts();
        this.dataModel.setFacts(facts);
        this.factsTable.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.factsTable.getColumnModel().getColumn(1).setPreferredWidth(150);
        this.factsTable.getColumnModel().getColumn(2).setPreferredWidth(this.factsTable.getWidth() - 200);
        String autoSortBy = this.settings.getString(GUI_FACTS_AUTOSORT_BY);
        String autoSortDir = this.settings.getString(GUI_FACTS_AUTOSORT_DIR);
        int col = -1;
        if (autoSortBy.equalsIgnoreCase("id")) {
            col = 0;
        } else if (autoSortBy.equalsIgnoreCase("template")) {
            col = 1;
        } else if (autoSortBy.equalsIgnoreCase("fact")) {
            col = 2;
        }
        if (col >= 0) {
            if (autoSortDir.contains("descending")) {
                TableModelQuickSort.sort(this.dataModel, false, col);
            } else {
                TableModelQuickSort.sort(this.dataModel, true, col);
            }
        }
    }

    private void initPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem retractItem = new JMenuItem("Retract selected Fact(s)", IconLoader.getImageIcon("database_delete"));
        retractItem.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent event) {
                int[] selCols = FactsPanel.this.factsTable.getSelectedRows();
                for (int i = 0; i < selCols.length; ++i) {
                    Long value = (Long)FactsPanel.this.dataModel.getValueAt(selCols[i], 0);
                    try {
                        FactsPanel.this.gui.getEngine().retractById(value);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        continue;
                    }
                    catch (RetractException e) {
                        e.printStackTrace();
                    }
                }
                FactsPanel.this.initFactsList();
            }
        });
        menu.add(retractItem);
        this.factsTable.setComponentPopupMenu(menu);
    }

    public void setFocus() {
        super.setFocus();
        this.initFactsList();
    }

    public void close() {
        this.settings.set(GUI_FACTS_DIVIDERLOCATION, this.pane.getDividerLocation());
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.reloadButton)) {
            this.initFactsList();
        } else if (event.getSource().equals(this.assertButton)) {
            FactEditor editor = new FactEditor(this.gui.getEngine());
            editor.setStringChannel(this.gui.getStringChannel());
            editor.init();
        }
    }

    public void valueChanged(ListSelectionEvent arg0) {
        if (arg0.getSource() == this.factsTable.getSelectionModel()) {
            Fact fact;
            StringBuilder buffer = new StringBuilder();
            if (this.factsTable.getSelectedColumnCount() == 1 && this.factsTable.getSelectedRow() > -1 && (fact = (Fact)this.dataModel.getRowAt(this.factsTable.getSelectedRow())) != null) {
                buffer.append(fact.format(new HelpFormatter()));
            }
            this.dumpArea.setText(buffer.toString());
            this.dumpArea.setCaretPosition(0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class FactsTableModel
    extends AbstractTableModel
    implements TableRowModel {
        private static final long serialVersionUID = 1L;
        private List<Fact> facts = Collections.emptyList();

        private FactsTableModel() {
        }

        private void setFacts(List<Fact> facts) {
            this.facts = facts;
            this.fireTableDataChanged();
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "ID";
                }
                case 1: {
                    return "Template";
                }
                case 2: {
                    return "Fact";
                }
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public Class getColumnClass(int aColumn) {
            if (aColumn == 0) {
                return Long.class;
            }
            if (aColumn == 1) {
                return String.class;
            }
            if (aColumn == 2) {
                return String.class;
            }
            return Class.class;
        }

        @Override
        public int getRowCount() {
            return this.facts.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            Fact fact = (Fact)this.getRowAt(row);
            switch (column) {
                case 0: {
                    return fact.getFactId();
                }
                case 1: {
                    return fact.getTemplate().getName();
                }
                case 2: {
                    return fact.toString();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
        }

        @Override
        public Object getRowAt(int row) {
            return this.facts.get(row);
        }

        @Override
        public void setRowAt(Object value, int row) {
            this.facts.set(row, (Fact)value);
        }
    }
}

