/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.application.gui.tab;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.jamocha.application.gui.JamochaGui;
import org.jamocha.application.gui.TableRowModel;
import org.jamocha.application.gui.icons.IconLoader;
import org.jamocha.application.gui.tab.AbstractJamochaPanel;
import org.jamocha.engine.agenda.Activation;
import org.jamocha.engine.workingmemory.elements.Fact;
import org.jamocha.formatter.HelpFormatter;
import org.jamocha.rules.Rule;

public class AgendaPanel
extends AbstractJamochaPanel
implements ListSelectionListener,
ActionListener {
    private static final String GUI_AGENDA_DIVIDERLOCATION = "gui.agenda.dividerlocation";
    private static final long serialVersionUID = 1L;
    private final JSplitPane pane;
    private final JButton reloadButton;
    private final AgendaTableModel dataModel;
    private final JTable agendaTable;
    private final JTextArea dumpArea;

    public AgendaPanel(JamochaGui gui) {
        super(gui);
        this.setLayout(new BorderLayout());
        this.dataModel = new AgendaTableModel();
        this.agendaTable = new JTable(this.dataModel);
        this.agendaTable.getSelectionModel().addListSelectionListener(this);
        this.agendaTable.setSelectionMode(0);
        this.agendaTable.setShowHorizontalLines(true);
        this.agendaTable.setRowSelectionAllowed(true);
        this.agendaTable.getTableHeader().setReorderingAllowed(false);
        this.agendaTable.getTableHeader().setToolTipText("No manual sorting available since sorting is done according to the used strategy.");
        this.agendaTable.getSelectionModel().addListSelectionListener(this);
        this.dumpArea = new JTextArea();
        this.dumpArea.setLineWrap(true);
        this.dumpArea.setWrapStyleWord(true);
        this.dumpArea.setEditable(false);
        this.dumpArea.setFont(new Font("Courier", 0, 12));
        this.pane = new JSplitPane(0, new JScrollPane(this.agendaTable), new JScrollPane(this.dumpArea));
        this.add((Component)this.pane, "Center");
        this.pane.setDividerLocation(this.settings.getInt(GUI_AGENDA_DIVIDERLOCATION));
        this.reloadButton = new JButton("Reload Activationlist", IconLoader.getImageIcon("arrow_refresh"));
        this.reloadButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2, 5, 1));
        buttonPanel.add(this.reloadButton);
        this.add((Component)buttonPanel, "Last");
        this.initPopupMenu();
    }

    private void initPopupMenu() {
    }

    public void close() {
        this.settings.set(GUI_AGENDA_DIVIDERLOCATION, this.pane.getDividerLocation());
    }

    public void setFocus() {
        super.setFocus();
        this.initActivationsList();
    }

    private void initActivationsList() {
        Collection<Activation> activations = this.gui.getEngine().getAgendas().getAgenda(this.gui.getEngine().findModule("MAIN")).getActivations();
        this.dataModel.setActivations(activations);
        this.agendaTable.getColumnModel().getColumn(0).setPreferredWidth(150);
        this.agendaTable.getColumnModel().getColumn(1).setPreferredWidth(this.agendaTable.getWidth() - 150);
    }

    public void valueChanged(ListSelectionEvent event) {
        if (event.getSource().equals(this.agendaTable.getSelectionModel())) {
            Activation act;
            StringBuilder buffer = new StringBuilder();
            if (this.agendaTable.getSelectedRow() >= 0 && (act = (Activation)this.dataModel.getRowAt(this.agendaTable.getSelectedRow())) != null) {
                Rule rule = act.getRule();
                HelpFormatter formatter = new HelpFormatter();
                buffer.append(rule.format(formatter));
                buffer.append("\n\n");
                buffer.append("Aggregated Time: ").append(act.getTuple().getAggregateCreationTimestamp());
                buffer.append("\n");
                buffer.append("Fact-Tuple:\n");
                for (Fact fact : act.getTuple()) {
                    buffer.append("\n--------------------------\n");
                    buffer.append(fact.format(formatter));
                }
            }
            this.dumpArea.setText(buffer.toString());
            this.dumpArea.setCaretPosition(0);
        }
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.reloadButton)) {
            this.initActivationsList();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class AgendaTableModel
    extends AbstractTableModel
    implements TableRowModel {
        private static final long serialVersionUID = 1L;
        private List<Activation> activations;

        private AgendaTableModel() {
        }

        private void setActivations(Collection<Activation> activations) {
            this.activations = new ArrayList<Activation>(activations.size());
            for (Activation activation : activations) {
                this.activations.add(activation);
            }
            this.fireTableDataChanged();
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Rule";
                }
                case 1: {
                    return "Tuple";
                }
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public Class getColumnClass(int aColumn) {
            if (aColumn == 0) {
                return String.class;
            }
            if (aColumn == 1) {
                return String.class;
            }
            return Class.class;
        }

        @Override
        public int getRowCount() {
            if (this.activations == null) {
                return 0;
            }
            return this.activations.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            switch (column) {
                case 0: {
                    return this.activations.get(row).getRule().getName();
                }
                case 1: {
                    return this.activations.get(row).getTuple().toString();
                }
            }
            return null;
        }

        @Override
        public Object getRowAt(int row) {
            return this.activations.get(row);
        }

        @Override
        public void setRowAt(Object value, int row) {
            this.activations.set(row, (Activation)value);
        }
    }
}

