/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.application.gui.retevisualisation;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.jamocha.application.gui.retevisualisation.ClickListener;
import org.jamocha.application.gui.retevisualisation.UnknownConnectorTypeException;
import org.jamocha.application.gui.retevisualisation.Visualizer;
import org.jamocha.communication.events.ModuleChangedEvent;
import org.jamocha.communication.events.ModuleChangedListener;
import org.jamocha.communication.events.ModulesChangedEvent;
import org.jamocha.communication.events.ModulesChangedEventListener;
import org.jamocha.engine.Engine;
import org.jamocha.engine.modules.Module;
import org.jamocha.rules.Defrule;
import org.jamocha.rules.Rule;

public class VisualizerPanel
extends JPanel
implements ClickListener,
ListSelectionListener,
MouseListener,
ModuleChangedListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    protected Visualizer miniMap;
    protected Visualizer mainVis;
    protected JTextPane dump;
    protected JPanel optionsPanel;
    protected RuleSelectorPanel rulePanel;
    protected Engine engine;
    protected JToggleButton lineBtn;
    protected JToggleButton lineQuarterEllipse;
    protected Module module;
    protected SimpleAttributeSet actAttributes;
    protected SimpleAttributeSet even;
    protected SimpleAttributeSet odd;
    protected JComboBox moduleChooser;
    protected JPanel moduleChooserPanel;

    protected void registerAsModulesListener() {
        for (Module m : this.engine.getModules().getModuleList()) {
            m.addModuleChangedEventListener(this);
        }
    }

    protected void setModule(Module module) {
        this.module = module;
    }

    public VisualizerPanel(Engine e) {
        this.engine = e;
        this.setModule(e.findModule("MAIN"));
        this.miniMap = new Visualizer(e);
        this.miniMap.enableToolTips(false);
        this.miniMap.enableAutoScale(true);
        this.miniMap.enableShowSelection(true);
        this.miniMap.setPreferredSize(new Dimension(240, 160));
        this.mainVis = new Visualizer(e);
        this.mainVis.enableToolTips(true);
        this.mainVis.enableAutoScale(false);
        this.mainVis.addViewportChangedListener(this.miniMap);
        this.miniMap.addViewportChangedListener(this.mainVis);
        this.miniMap.enableViewportByClick(true, this.mainVis);
        this.dump = new JTextPane();
        JScrollPane scrollDump = new JScrollPane(this.dump);
        this.even = new SimpleAttributeSet();
        this.odd = new SimpleAttributeSet();
        StyleConstants.setForeground(this.even, Color.blue);
        StyleConstants.setForeground(this.odd, Color.green.darker());
        this.actAttributes = this.even;
        this.mainVis.setClickListener(this);
        this.optionsPanel = new JPanel();
        this.optionsPanel.setPreferredSize(new Dimension(150, 120));
        this.optionsPanel.setLayout(new BoxLayout(this.optionsPanel, 1));
        this.rulePanel = new RuleSelectorPanel(null);
        this.rulePanel.addListSelectionListener(this);
        this.moduleChooserPanel = new JPanel();
        this.loadModuleList();
        this.engine.getModules().addModulesChangeListener(new VisualizerModulesChangeListener());
        this.registerAsModulesListener();
        this.generateRulesList();
        this.optionsPanel.add(this.rulePanel);
        this.optionsPanel.add(new JLabel("Module:"));
        this.optionsPanel.add(this.moduleChooser);
        this.mainVis.setSelectedRules(this.rulePanel.getSelectedRules());
        this.miniMap.setSelectedRules(this.rulePanel.getSelectedRules());
        this.miniMap.repaint();
        JSplitPane splitMainAndOptionsToUpper = new JSplitPane(1, this.mainVis, this.optionsPanel);
        JSplitPane splitMiniAndDumpToBottom = new JSplitPane(1, this.miniMap, scrollDump);
        splitMainAndOptionsToUpper.setResizeWeight(1.0);
        JSplitPane splitUpperAndLower = new JSplitPane(0, splitMainAndOptionsToUpper, splitMiniAndDumpToBottom);
        splitUpperAndLower.setResizeWeight(1.0);
        this.setLayout(new BorderLayout());
        this.add((Component)splitUpperAndLower, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2, 5, 1));
        ButtonGroup lineChooser = new ButtonGroup();
        this.lineBtn = new JToggleButton("Lines");
        this.lineQuarterEllipse = new JToggleButton("Quarter Ellipses");
        lineChooser.add(this.lineBtn);
        lineChooser.add(this.lineQuarterEllipse);
        this.lineBtn.addMouseListener(this);
        this.lineQuarterEllipse.addMouseListener(this);
        this.lineQuarterEllipse.setSelected(true);
        buttonPanel.add(this.lineBtn);
        buttonPanel.add(this.lineQuarterEllipse);
        this.add((Component)buttonPanel, "Last");
    }

    public void loadModuleList() {
        Vector<String> modules = new Vector<String>();
        for (Module module : this.engine.getModules().getModuleList()) {
            modules.add(module.getName());
        }
        JComboBox oldChooser = this.moduleChooser;
        String toSelect = null;
        if (oldChooser != null) {
            toSelect = (String)oldChooser.getSelectedItem();
            this.moduleChooserPanel.remove(oldChooser);
        }
        this.moduleChooser = new JComboBox(modules);
        boolean selectedGoodModule = false;
        if (toSelect != null) {
            for (String mod : modules) {
                if (!mod.equals(toSelect)) continue;
                selectedGoodModule = true;
                this.moduleChooser.setSelectedItem(mod);
            }
        }
        if (!selectedGoodModule) {
            for (String mod : modules) {
                if (!mod.equals("MAIN")) continue;
                selectedGoodModule = true;
                this.moduleChooser.setSelectedItem(mod);
            }
        }
        this.moduleChooser.setMaximumSize(new Dimension(4000, 40));
        this.moduleChooser.addActionListener(this);
        this.moduleChooserPanel.add(this.moduleChooser);
        this.moduleSelected((String)this.moduleChooser.getSelectedItem());
    }

    protected void moduleSelected(String mod) {
        this.setModule(this.engine.getModule(mod));
        this.reload();
    }

    public void reload() {
        this.generateRulesList();
        this.mainVis.reload();
        this.miniMap.reload();
    }

    public void nodeClicked(String description) {
        try {
            this.dump.getDocument().insertString(this.dump.getDocument().getLength(), description, this.actAttributes);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        this.actAttributes = this.actAttributes == this.even ? this.odd : this.even;
    }

    protected void generateRulesList() {
        Vector<String> rules = new Vector<String>();
        for (Rule ruleObj : this.module.getAllRules()) {
            String r = ((Defrule)ruleObj).getName();
            rules.add(r);
        }
        this.rulePanel.setRules(rules);
    }

    public void valueChanged(ListSelectionEvent e) {
        this.mainVis.setSelectedRules(this.rulePanel.getSelectedRules());
        this.miniMap.setSelectedRules(this.rulePanel.getSelectedRules());
    }

    public void mouseClicked(MouseEvent arg0) {
        Component c = arg0.getComponent();
        if (c == this.lineBtn) {
            try {
                this.setConnectorType("lines");
            }
            catch (UnknownConnectorTypeException e) {
                this.engine.writeMessage(e.toString());
            }
        } else if (c == this.lineQuarterEllipse) {
            try {
                this.setConnectorType("quarterellipse");
            }
            catch (UnknownConnectorTypeException e) {
                this.engine.writeMessage(e.toString());
            }
        }
    }

    public void mouseEntered(MouseEvent arg0) {
    }

    public void mouseExited(MouseEvent arg0) {
    }

    public void mousePressed(MouseEvent arg0) {
    }

    public void mouseReleased(MouseEvent arg0) {
    }

    public void factAdded(ModuleChangedEvent ev) {
    }

    public void factRemoved(ModuleChangedEvent ev) {
    }

    public void ruleAdded(ModuleChangedEvent ev) {
        this.reload();
    }

    public void ruleRemoved(ModuleChangedEvent ev) {
        this.reload();
    }

    public void templateAdded(ModuleChangedEvent ev) {
        this.reload();
    }

    public void templateRemoved(ModuleChangedEvent ev) {
        this.reload();
    }

    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getSource() == this.moduleChooser) {
            this.moduleSelected((String)this.moduleChooser.getSelectedItem());
        }
    }

    public void setConnectorType(String connType) throws UnknownConnectorTypeException {
        if (connType.equalsIgnoreCase("lines")) {
            this.miniMap.setLineStyle(1);
            this.mainVis.setLineStyle(1);
            this.lineBtn.setSelected(true);
            this.lineQuarterEllipse.setSelected(false);
        } else if (connType.equalsIgnoreCase("quarterellipse")) {
            this.miniMap.setLineStyle(2);
            this.mainVis.setLineStyle(2);
            this.lineBtn.setSelected(false);
            this.lineQuarterEllipse.setSelected(true);
        } else {
            throw new UnknownConnectorTypeException(connType);
        }
    }

    public String getConnectorType() {
        if (this.mainVis.getLineStyle() == 1) {
            return "lines";
        }
        if (this.mainVis.getLineStyle() == 2) {
            return "quarterellipse";
        }
        return "unknown";
    }

    class VisualizerModulesChangeListener
    implements ModulesChangedEventListener {
        VisualizerModulesChangeListener() {
        }

        public void modulesChanged(ModulesChangedEvent event) {
            VisualizerPanel.this.registerAsModulesListener();
            VisualizerPanel.this.reload();
            if (event.getType() == ModulesChangedEvent.ModulesChangedEventType.MODULE_ADDED) {
                VisualizerPanel.this.moduleChooser.addItem(event.getModule().getName());
            } else if (event.getType() == ModulesChangedEvent.ModulesChangedEventType.MODULE_REMOVED) {
                VisualizerPanel.this.moduleChooser.removeItem(event.getModule().getName());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RuleSelectorPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        JScrollPane scrollPane;
        JCheckBoxList list;
        int numRules;
        List<ListSelectionListener> listeners = new ArrayList<ListSelectionListener>();

        public RuleSelectorPanel(Vector<String> rules) {
            this.setLayout(new GridLayout(1, 1));
            this.list = new JCheckBoxList(rules);
            this.show();
        }

        public void addListSelectionListener(ListSelectionListener listener) {
            this.list.addListSelectionListener(listener);
        }

        public void setRules(Vector<String> rules) {
            this.list.setList(rules);
        }

        @Override
        public void show() {
            if (this.scrollPane != null) {
                this.remove(this.scrollPane);
            }
            this.scrollPane = new JScrollPane(this.list);
            this.add(this.scrollPane);
            this.validate();
            this.list.selectAll();
        }

        public boolean isSelected(Rule r) {
            String s = r.getName();
            for (String o : this.list.getSelectedValues()) {
                String ssel = o;
                if (!ssel.equals(s)) continue;
                return true;
            }
            return false;
        }

        public List<String> getSelectedRules() {
            return this.list.getSelectedValues();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class JCheckBoxList
    extends JPanel
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        Vector<JCheckBox> boxes;
        List<ListSelectionListener> listeners = new ArrayList<ListSelectionListener>();
        List<String> selected = new ArrayList<String>();
        JPanel panel;

        JCheckBoxList(Vector<String> items) {
            this.setList(items);
        }

        public void setList(Vector<String> items) {
            if (items == null) {
                items = new Vector();
            }
            if (this.panel != null) {
                this.remove(this.panel);
            }
            this.panel = new JPanel();
            this.boxes = new Vector();
            this.loadItemsList(items);
            this.panel.setLayout(new BoxLayout(this.panel, 1));
            this.selectAll();
            this.add(this.panel);
            this.validate();
        }

        void loadItemsList(Vector<String> items) {
            for (JCheckBox box : this.boxes) {
                this.panel.remove(box);
            }
            this.boxes.clear();
            for (String s : items) {
                JCheckBox newBox = new JCheckBox(s);
                newBox.addActionListener(this);
                this.boxes.add(newBox);
                this.panel.add(newBox);
            }
        }

        public void addListSelectionListener(ListSelectionListener l) {
            this.listeners.add(l);
        }

        protected void callListeners() {
            for (ListSelectionListener l : this.listeners) {
                l.valueChanged(new ListSelectionEvent(this, -1, -1, false));
            }
        }

        public void selectAll() {
            this.selected.clear();
            for (JCheckBox box : this.boxes) {
                box.setSelected(true);
                this.selected.add(box.getText());
            }
            this.callListeners();
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            JCheckBox box = (JCheckBox)arg0.getSource();
            String fooboo = box.getText();
            boolean inserted = box.isSelected();
            if (inserted) {
                this.selected.add(fooboo);
            } else {
                this.selected.remove(fooboo);
            }
            this.callListeners();
        }

        public List<String> getSelectedValues() {
            return this.selected;
        }
    }
}

