/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.application.gui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.jamocha.application.gui.editor.AbstractJamochaEditor;
import org.jamocha.application.gui.icons.IconLoader;
import org.jamocha.communication.messagerouter.StringChannel;
import org.jamocha.engine.Engine;
import org.jamocha.engine.modules.Module;

public class RuleEditor
extends AbstractJamochaEditor
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private final JButton cancelButton;
    private final JButton addButton;
    private final JTextField nameField;
    private final JTextField commentField;
    private final JTextArea ruleLhsArea;
    private final JTextArea ruleRhsArea;
    private final JComboBox moduleBox;
    private StringChannel channel;

    public RuleEditor(Engine engine) {
        super(engine);
        this.setSize(600, 500);
        this.setLayout(new BorderLayout());
        this.setTitle("Add new Rule");
        this.cancelButton = new JButton("Cancel", IconLoader.getImageIcon("cancel"));
        this.cancelButton.addActionListener(this);
        this.addButton = new JButton("Add Rule", IconLoader.getImageIcon("car_add"));
        this.addButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(1, 5, 1));
        buttonPanel.add(this.cancelButton);
        buttonPanel.add(this.addButton);
        this.add((Component)buttonPanel, "South");
        this.nameField = new JTextField(15);
        this.commentField = new JTextField(15);
        Collection<Module> modules = engine.getModules().getModuleList();
        String[] moduleNames = new String[modules.size()];
        int i = 0;
        for (Module mod : modules) {
            moduleNames[i++] = mod.getName();
        }
        this.moduleBox = new JComboBox<String>(moduleNames);
        JPanel topPanel = new JPanel();
        topPanel.setBorder(BorderFactory.createTitledBorder("General Rule Settings"));
        topPanel.setLayout(new FlowLayout(0, 20, 1));
        JPanel innerTopPanel = new JPanel(new GridLayout(3, 2));
        innerTopPanel.add(new JLabel("Name:"));
        innerTopPanel.add(this.nameField);
        innerTopPanel.add(new JLabel("Comment:"));
        innerTopPanel.add(this.commentField);
        innerTopPanel.add(new JLabel("Module:"));
        innerTopPanel.add(this.moduleBox);
        topPanel.add((Component)innerTopPanel, "West");
        this.add((Component)topPanel, "North");
        JPanel centerPanel = new JPanel(new GridLayout(2, 1));
        JPanel ruleLhsPanel = new JPanel(new BorderLayout());
        ruleLhsPanel.setBorder(BorderFactory.createTitledBorder("Left Hand Side (Premisse)"));
        this.ruleLhsArea = new JTextArea();
        ruleLhsPanel.add(new JScrollPane(this.ruleLhsArea));
        JPanel ruleRhsPanel = new JPanel(new BorderLayout());
        ruleRhsPanel.setBorder(BorderFactory.createTitledBorder("Right Hand Side (Action)"));
        this.ruleRhsArea = new JTextArea();
        ruleRhsPanel.add(new JScrollPane(this.ruleRhsArea));
        centerPanel.add(ruleLhsPanel);
        centerPanel.add(ruleRhsPanel);
        this.add((Component)centerPanel, "Center");
    }

    public void setStringChannel(StringChannel channel) {
        this.channel = channel;
    }

    public void init() {
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.addButton)) {
            String ruleRhs;
            StringBuilder buffer = new StringBuilder();
            buffer.append("(defrule " + this.nameField.getText() + " \"" + this.commentField.getText() + "\"");
            String ruleLhs = this.ruleLhsArea.getText().trim();
            if (!ruleLhs.startsWith("(")) {
                ruleLhs = "(" + ruleLhs + ")";
            }
            if (!(ruleRhs = this.ruleRhsArea.getText().trim()).startsWith("(")) {
                ruleRhs = "(" + ruleRhs + ")";
            }
            buffer.append("\n" + ruleLhs + "\n => \n" + ruleRhs + "\n");
            buffer.append(")");
            this.channel.executeCommand(buffer.toString());
            JOptionPane.showMessageDialog(this, "Rule defined.\nPlease check the log for Messages.");
        } else if (event.getSource() == this.cancelButton) {
            this.close();
        }
    }
}

