/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.application.gui;

import org.jamocha.application.gui.TableRowModel;

public class TableModelQuickSort {
    private boolean ascending;
    private TableRowModel model;
    private int column;
    private Class clazz;

    public static void sort(TableRowModel model, boolean ascending, int column) {
        TableModelQuickSort quick = new TableModelQuickSort();
        quick.model = model;
        quick.ascending = ascending;
        quick.column = column;
        quick.clazz = model.getColumnClass(column);
        quick.quicksort(0, model.getRowCount() - 1);
        model.fireTableDataChanged();
    }

    private void quicksort(int p, int r) {
        if (p < r) {
            int q = this.partition(p, r);
            if (q == r) {
                --q;
            }
            this.quicksort(p, q);
            this.quicksort(q + 1, r);
        }
    }

    private int partition(int lo, int hi) {
        Object pivot = this.model.getValueAt(lo, this.column);
        while (true) {
            if (this.compare(this.model.getValueAt(hi, this.column), pivot) >= 0L && lo < hi) {
                --hi;
                continue;
            }
            while (this.compare(this.model.getValueAt(lo, this.column), pivot) < 0L && lo < hi) {
                ++lo;
            }
            if (lo >= hi) break;
            Object temp = this.model.getRowAt(lo);
            this.model.setRowAt(this.model.getRowAt(hi), lo);
            this.model.setRowAt(temp, hi);
        }
        return hi;
    }

    private long compare(Object a, Object b) {
        long res = 0L;
        if (this.clazz.equals(Integer.class)) {
            res = (Integer)a - (Integer)b;
        } else if (this.clazz.equals(Long.class)) {
            res = (Long)a - (Long)b;
        } else if (this.clazz.equals(String.class)) {
            res = ((String)a).compareToIgnoreCase((String)b);
        }
        if (!this.ascending) {
            res *= -1L;
        }
        return res;
    }
}

