/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.application.gui;

import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jamocha.application.gui.BatchResultBrowser;
import org.jamocha.application.gui.BrowserControl;
import org.jamocha.application.gui.JamochaMenuBar;
import org.jamocha.application.gui.icons.IconLoader;
import org.jamocha.application.gui.tab.AbstractJamochaPanel;
import org.jamocha.application.gui.tab.AgendaPanel;
import org.jamocha.application.gui.tab.FactsPanel;
import org.jamocha.application.gui.tab.FunctionsPanel;
import org.jamocha.application.gui.tab.LogPanel;
import org.jamocha.application.gui.tab.RulesPanel;
import org.jamocha.application.gui.tab.SettingsPanel;
import org.jamocha.application.gui.tab.ShellPanel;
import org.jamocha.application.gui.tab.TemplatesPanel;
import org.jamocha.application.gui.tab.ViewerPanel;
import org.jamocha.communication.BatchThread;
import org.jamocha.communication.messagerouter.InterestType;
import org.jamocha.communication.messagerouter.StringChannel;
import org.jamocha.engine.Engine;
import org.jamocha.settings.JamochaSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JamochaGui
extends JFrame
implements ChangeListener,
ActionListener {
    private static final String GUI_LOCY = "gui.locy";
    private static final String GUI_LOCX = "gui.locx";
    private static final String GUI_HEIGHT = "gui.height";
    private static final String GUI_WIDTH = "gui.width";
    static final long serialVersionUID = 1L;
    private final Engine engine;
    private final JamochaMenuBar menuBar;
    private final JButton batchResultsButton;
    private final JLabel logoLabel;
    private final JTabbedPane tabbedPane;
    private final List<AbstractJamochaPanel> panels = new LinkedList<AbstractJamochaPanel>();
    private boolean exitOnClose = false;
    private StringChannel stringChannel;
    private final BatchThread batchThread;
    public static final String CROSS_PLATFORM_LOOK_AND_FEEL = "crossplatform";
    public static final String SYSTEM_LOOK_AND_FEEL = "system";
    public static final String METAL_LOOK_AND_FEEL = "javax.swing.plaf.metal.MetalLookAndFeel";
    public static final String WINDOWS_LOOK_AND_FEEL = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
    public static final String GTK_LOOK_AND_FEEL = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
    public static final String MOTIF_LOOK_AND_FEEL = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";

    public JamochaGui(Engine engine, BatchThread batchThread) {
        this.setLayout(new BorderLayout());
        this.setTitle("Jamocha");
        this.setSizeAndLocation();
        JPanel logoPanel = new JPanel(new BorderLayout());
        this.logoLabel = new JLabel(IconLoader.getImageIcon("jamocha"));
        this.logoLabel.setCursor(new Cursor(12));
        this.logoLabel.setToolTipText("visit www.jamocha.org");
        this.logoLabel.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                BrowserControl.displayURL("http://www.jamocha.org", JamochaGui.this);
            }
        });
        logoPanel.add((Component)this.logoLabel, "East");
        JPanel batchResultsPanel = new JPanel();
        this.batchResultsButton = new JButton(IconLoader.getImageIcon("lorry_error"));
        this.batchResultsButton.setToolTipText("Click here to view batch results.");
        this.batchResultsButton.setVisible(false);
        this.batchResultsButton.addActionListener(this);
        batchResultsPanel.add(this.batchResultsButton);
        logoPanel.add((Component)batchResultsPanel, "West");
        this.add((Component)logoPanel, "North");
        this.tabbedPane = new JTabbedPane();
        this.add((Component)this.tabbedPane, "Center");
        this.tabbedPane.setFocusTraversalKeysEnabled(true);
        this.menuBar = new JamochaMenuBar(this);
        this.setJMenuBar(this.menuBar);
        this.engine = engine;
        ShellPanel shellPanel = new ShellPanel(this);
        this.tabbedPane.addTab("Shell", IconLoader.getImageIcon("application_osx_terminal"), shellPanel, "Jamocha Shell");
        this.panels.add(shellPanel);
        FactsPanel factsPanel = new FactsPanel(this);
        this.tabbedPane.addTab("Facts", IconLoader.getImageIcon("database"), factsPanel, "View or modify Facts");
        this.panels.add(factsPanel);
        TemplatesPanel templatesPanel = new TemplatesPanel(this);
        this.tabbedPane.addTab("Templates", IconLoader.getImageIcon("brick"), templatesPanel, "View or modify Templates");
        this.panels.add(templatesPanel);
        RulesPanel rulesPanel = new RulesPanel(this);
        this.tabbedPane.addTab("Rules", IconLoader.getImageIcon("car"), rulesPanel, "View or modify Rules");
        this.panels.add(rulesPanel);
        FunctionsPanel functionsPanel = new FunctionsPanel(this);
        this.tabbedPane.addTab("Functions", IconLoader.getImageIcon("cog"), functionsPanel, "View Functions");
        this.panels.add(functionsPanel);
        AgendaPanel agendaPanel = new AgendaPanel(this);
        this.tabbedPane.addTab("Agenda", IconLoader.getImageIcon("sport_8ball"), agendaPanel, "View all Activations");
        this.panels.add(agendaPanel);
        ViewerPanel viewerPanel = new ViewerPanel(this);
        this.tabbedPane.addTab("Rete viewer", IconLoader.getImageIcon("eye"), viewerPanel, "View the Rete-network");
        this.panels.add(viewerPanel);
        LogPanel logPanel = new LogPanel(this);
        this.tabbedPane.addTab("Log", IconLoader.getImageIcon("monitor"), logPanel, "View alle messages from or to the Rete-engine");
        this.panels.add(logPanel);
        SettingsPanel settingsPanel = new SettingsPanel(this);
        this.tabbedPane.addTab("Settings", IconLoader.getImageIcon("wrench"), settingsPanel, "Settings for Jamocha");
        this.panels.add(settingsPanel);
        this.add((Component)this.tabbedPane, "Center");
        this.tabbedPane.addChangeListener(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                JamochaGui.this.close();
            }
        });
        this.batchThread = batchThread;
    }

    public void informOfNewBatchResults() {
        this.batchResultsButton.setVisible(true);
        this.batchResultsButton.setIcon(IconLoader.getImageIcon("lorry_error"));
    }

    public void processBatchFiles(List<String> files) {
        this.batchThread.processBatchFiles(files);
    }

    private void setSizeAndLocation() {
        JamochaSettings prefs = JamochaSettings.getInstance();
        int width = prefs.getInt(GUI_WIDTH);
        int height = prefs.getInt(GUI_HEIGHT);
        int locx = prefs.getInt(GUI_LOCX);
        int locy = prefs.getInt(GUI_LOCY);
        if (locx == -1 || locy == -1) {
            this.setLocationByPlatform(true);
        } else {
            this.setLocation(locx, locy);
        }
        this.setMinimumSize(new Dimension(500, 300));
        this.setPreferredSize(new Dimension(750, 550));
        if (width <= 100 || height <= 50) {
            this.setSize(750, 550);
        } else {
            this.setSize(width, height);
        }
    }

    public void setExitOnClose(boolean exitOnClose) {
        this.exitOnClose = exitOnClose;
    }

    public void showCloseGuiMenuItem(boolean show) {
        this.menuBar.showCloseGui(show);
    }

    public void showQuitMenuItem(boolean show) {
        this.menuBar.showQuit(show);
    }

    public Engine getEngine() {
        return this.engine;
    }

    public StringChannel getStringChannel() {
        if (this.stringChannel == null) {
            this.stringChannel = this.getEngine().getMessageRouter().openChannel("gui_string_channel", InterestType.NONE);
        }
        return this.stringChannel;
    }

    public StringChannel getBatchChannel() {
        return this.batchThread.getBatchChannel();
    }

    public void showGui() {
        this.setVisible(true);
        this.panels.get(0).setFocus();
    }

    public static String exceptionToString(Exception exception) {
        StringBuilder res = new StringBuilder();
        StackTraceElement[] str = exception.getStackTrace();
        for (int i = 0; i < str.length; ++i) {
            res.append(str[i] + System.getProperty("line.separator"));
        }
        return res.toString();
    }

    public void close() {
        if (this.stringChannel != null) {
            this.getEngine().getMessageRouter().closeChannel(this.stringChannel);
        }
        JamochaSettings prefs = JamochaSettings.getInstance();
        prefs.set(GUI_WIDTH, this.getWidth());
        prefs.set(GUI_HEIGHT, this.getHeight());
        prefs.set(GUI_LOCX, this.getX());
        prefs.set(GUI_LOCY, this.getY());
        for (AbstractJamochaPanel panel : this.panels) {
            panel.close();
        }
        this.setVisible(false);
        this.dispose();
        this.batchThread.setGui(null);
        if (this.exitOnClose) {
            this.batchThread.stopThread();
            this.engine.clearAll();
            System.exit(0);
        }
    }

    public void setLookAndFeel(String lookAndFeelClassName) {
        try {
            if (lookAndFeelClassName.equals(CROSS_PLATFORM_LOOK_AND_FEEL)) {
                lookAndFeelClassName = UIManager.getCrossPlatformLookAndFeelClassName();
            } else if (lookAndFeelClassName.equals(SYSTEM_LOOK_AND_FEEL)) {
                lookAndFeelClassName = UIManager.getSystemLookAndFeelClassName();
            }
            UIManager.setLookAndFeel(lookAndFeelClassName);
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (Exception exc) {
            try {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public Set<AWTKeyStroke> getFocusTraversalKeys(int id) {
        if (id == 0 || id == 1) {
            return Collections.emptySet();
        }
        return super.getFocusTraversalKeys(id);
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        ((AbstractJamochaPanel)this.tabbedPane.getSelectedComponent()).setFocus();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.batchResultsButton) {
            BatchResultBrowser browser = new BatchResultBrowser(this.batchResultsButton);
            browser.setResults(this.batchThread.getBatchResults());
            browser.setVisible(true);
        }
    }
}

