/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.application;

import java.util.LinkedList;
import java.util.List;
import javax.swing.UIManager;
import org.jamocha.application.Shell;
import org.jamocha.application.gui.JamochaGui;
import org.jamocha.communication.BatchThread;
import org.jamocha.engine.Engine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jamocha {
    private JamochaGui jamochaGui;
    private Shell shell;
    private Engine engine = new Engine();
    private BatchThread batchThread = new BatchThread(this.engine);

    public static void main(String[] args) {
        boolean startGui = false;
        boolean startShell = false;
        LinkedList<String> batchFiles = new LinkedList<String>();
        if (null != args) {
            boolean inBatchFiles = false;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].startsWith("-")) {
                    inBatchFiles = false;
                }
                if (inBatchFiles) {
                    batchFiles.add(args[i]);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-gui")) {
                    startGui = true;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-shell")) {
                    startShell = true;
                    continue;
                }
                if (!args[i].equals("-batch")) continue;
                inBatchFiles = true;
            }
        }
        Jamocha jamocha = new Jamocha(startGui, startShell, batchFiles);
        if (!startShell && !startGui) {
            jamocha.showUsage();
            return;
        }
        if (!startShell) {
            jamocha.getJamochaGui().showCloseGuiMenuItem(false);
            jamocha.getJamochaGui().setExitOnClose(true);
        }
    }

    public Jamocha(boolean startGui, boolean startShell, List<String> batchFiles) {
        this.batchThread.start();
        if (startShell) {
            this.startShell();
        }
        if (startGui) {
            this.startGui();
            this.batchThread.setGui(this.getJamochaGui());
        }
        if (batchFiles != null && !batchFiles.isEmpty()) {
            this.batchThread.processBatchFiles(batchFiles);
        }
    }

    public void setGUITitle(String title) {
        if (this.jamochaGui != null) {
            this.jamochaGui.setTitle(title);
        }
    }

    public void batchFiles(List<String> batchFiles) {
        if (batchFiles != null) {
            this.batchThread.processBatchFiles(batchFiles);
        }
    }

    public Engine getEngine() {
        return this.engine;
    }

    public void startShell() {
        if (this.shell == null) {
            this.shell = new Shell(this.engine);
            Thread shellThread = new Thread("Shell Thread"){

                public void run() {
                    Jamocha.this.shell.run();
                }
            };
            shellThread.start();
        }
    }

    public void startGui() {
        if (this.jamochaGui == null) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.jamochaGui = new JamochaGui(this.engine, this.batchThread);
            Thread guiThread = new Thread("GUI Thread"){

                public void run() {
                    Jamocha.this.jamochaGui.showGui();
                }
            };
            guiThread.start();
        }
    }

    public void showUsage() {
        String sep = System.getProperty("line.separator");
        System.out.println("You have to pass one or more of the following arguments:" + sep + sep + "-gui:" + sep + "     Starts a graphical user interface." + sep + "-shell:" + sep + "     Starts a simple Shell." + sep + sep + "Optional arguments:" + sep + sep + "-batch [batchfile...]:" + sep + "     Processes a list of given files (separated by blanks) as batch-files.");
        System.exit(0);
    }

    public JamochaGui getJamochaGui() {
        return this.jamochaGui;
    }

    public Shell getShell() {
        return this.shell;
    }
}

