/* Generated By:JJTree&JavaCC: Do not edit this line. SFPParser.java */
/*
 * Copyright 2007 Karl-Heinz Krempels, Sebastian Reinartz
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.jamocha.org/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */
package org.jamocha.languages.clips.parser;

import org.jamocha.parser.Parser;
import org.jamocha.parser.ParserUtils;
import org.jamocha.parser.Expression;
import org.jamocha.parser.JamochaValue;

import org.jamocha.engine.Engine;

public class SFPParser implements/*@bgen(jjtree)*/ SFPParserTreeConstants,Parser, SFPParserConstants {/*@bgen(jjtree)*/
  protected JJTSFPParserState jjtree = new JJTSFPParserState();
        public Expression nextExpression() throws ParseException {
                SFPStart n = Start();
                if (n != null) {
                        Object result = n.jjtAccept(new SFPInterpreter(), null);
                        if (result != null) {
                                return (org.jamocha.parser.Expression) result;
                        }
                }
                return null;
        }

        public static void main(String args[])
        {
                boolean verbose = (args != null && args.length == 1 && "verbose".equals(args[0]));
                if(!verbose)System.out.println("Note: For verbose output type \"java Main verbose\".\n");
                System.out.print("SFP> ");
                Engine engine = new Engine();
                SFPParser p = new SFPParser(System.in);
                try
                {
                while (true)
                        {
                                SFPStart n = p.Start();
                                if (n==null) System.exit(0);
                                n.dump(" ");
                                org.jamocha.parser.Expression val = null;
                                val = (org.jamocha.parser.Expression)n.jjtAccept(new SFPInterpreter(), null);
                        }
                }
                catch (Exception e)
                {
                        System.err.println("ERROR: " + e.getMessage());
                        if(verbose)e.printStackTrace();
                }
        }

/* TODO (From Clips Manual):
Data Types:
<file-name> ::= A symbol or string which is a valid file name (including path information)
	for the operating system under which CLIPS is running
<slot-name> ::= A valid deftemplate_construct slot name
<...-name> ::= A <symbol> where the ellipsis indicate what the symbol represents.
	For example, <rule-name> is a symbol which represents the name of a rule.
*/

/**********************************************
 * Cool Grammar Specs.
 */

// Start rule is a construct at a time, the parser reads all the constructs into a list.
  final public SFPStart Start() throws ParseException {
 /*@bgen(jjtree) Start */
  SFPStart jjtn000 = new SFPStart(this, JJTSTART);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LBRACE:
      case INTEGER:
      case FLOAT:
      case DATETIME:
      case STRING:
      case GLOBALVAR:
      case TRUE:
      case FALSE:
      case NIL:
      case SINGLEVAR:
      case MULTIVAR:
      case SYMBOL:
        if (jj_2_1(2)) {
          Construct();
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case LBRACE:
          case INTEGER:
          case FLOAT:
          case DATETIME:
          case STRING:
          case GLOBALVAR:
          case TRUE:
          case FALSE:
          case NIL:
          case SINGLEVAR:
          case MULTIVAR:
          case SYMBOL:
            Expression();
            break;
          default:
            jj_la1[0] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
            jjtree.closeNodeScope(jjtn000, true);
            jjtc000 = false;
            {if (true) return jjtn000;}
        break;
      case 0:
        jj_consume_token(0);
                  jjtree.closeNodeScope(jjtn000, true);
                  jjtc000 = false;
                  {if (true) return null;}
        break;
      default:
        jj_la1[1] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
     if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte000;}
     }
     if (jjte000 instanceof ParseException) {
       {if (true) throw (ParseException)jjte000;}
     }
     {if (true) throw (Error)jjte000;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
     }
    }
    throw new Error("Missing return statement in function");
  }

/*
<number> ::= <float> | <integer> 
<lexeme> ::= <symbol> | <string>
<constant> ::= <datetime> | <symbol> | <string> | <integer> | <float>
*/


/**
*		Float
**/
  final public SimpleNode Float() throws ParseException {
 /*@bgen(jjtree) Float */
  SFPFloat jjtn000 = new SFPFloat(this, JJTFLOAT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(FLOAT);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.setName(t.image);
                {if (true) return jjtn000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Integer
**/
  final public SimpleNode Integer() throws ParseException {
 /*@bgen(jjtree) Integer */
  SFPInteger jjtn000 = new SFPInteger(this, JJTINTEGER);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(INTEGER);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.setName(t.image);
                {if (true) return jjtn000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		DateTime
**/
  final public SimpleNode DateTime() throws ParseException {
 /*@bgen(jjtree) DateTime */
  SFPDateTime jjtn000 = new SFPDateTime(this, JJTDATETIME);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(DATETIME);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.setName(t.image);
                {if (true) return jjtn000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Number
**/
  final public void Number() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FLOAT:
      Float();
      break;
    case INTEGER:
      Integer();
      break;
    default:
      jj_la1[2] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
*		Symbol
**/
  final public SimpleNode Symbol() throws ParseException {
 /*@bgen(jjtree) Symbol */
  SFPSymbol jjtn000 = new SFPSymbol(this, JJTSYMBOL);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(SYMBOL);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.setName(t.image);
                {if (true) return jjtn000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		String
**/
  final public SimpleNode String() throws ParseException {
 /*@bgen(jjtree) String */
  SFPString jjtn000 = new SFPString(this, JJTSTRING);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(STRING);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.setName(ParserUtils.getStringLiteral(t.image));
                {if (true) return jjtn000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		True
**/
  final public SimpleNode True() throws ParseException {
 /*@bgen(jjtree) True */
  SFPTrue jjtn000 = new SFPTrue(this, JJTTRUE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(TRUE);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.setName(t.image);
                {if (true) return jjtn000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

  final public SimpleNode Nil() throws ParseException {
 /*@bgen(jjtree) Nil */
  SFPNil jjtn000 = new SFPNil(this, JJTNIL);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(NIL);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.setName(t.image);
                {if (true) return jjtn000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		SymbolType
**/
  final public SimpleNode SymbolType() throws ParseException {
 /*@bgen(jjtree) SymbolType */
  SFPSymbolType jjtn000 = new SFPSymbolType(this, JJTSYMBOLTYPE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(SYMBOL_TYPE);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.setName(t.image);
                {if (true) return jjtn000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		StringType
**/
  final public SimpleNode StringType() throws ParseException {
 /*@bgen(jjtree) StringType */
  SFPStringType jjtn000 = new SFPStringType(this, JJTSTRINGTYPE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(STRING_TYPE);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.setName(t.image);
                {if (true) return jjtn000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		DateTimeType
**/
  final public SimpleNode DateTimeType() throws ParseException {
 /*@bgen(jjtree) DateTimeType */
  SFPDateTimeType jjtn000 = new SFPDateTimeType(this, JJTDATETIMETYPE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(DATETIME_TYPE);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.setName(t.image);
                {if (true) return jjtn000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		LexemeType
**/
  final public SimpleNode LexemeType() throws ParseException {
 /*@bgen(jjtree) LexemeType */
  SFPLexemeType jjtn000 = new SFPLexemeType(this, JJTLEXEMETYPE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(LEXEME_TYPE);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.setName(t.image);
                {if (true) return jjtn000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		BooleanType
**/
  final public SimpleNode BooleanType() throws ParseException {
 /*@bgen(jjtree) BooleanType */
  SFPBooleanType jjtn000 = new SFPBooleanType(this, JJTBOOLEANTYPE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(BOOLEAN_TYPE);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.setName(t.image);
                {if (true) return jjtn000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		IntegerType
**/
  final public SimpleNode IntegerType() throws ParseException {
 /*@bgen(jjtree) IntegerType */
  SFPIntegerType jjtn000 = new SFPIntegerType(this, JJTINTEGERTYPE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(INTEGER_TYPE);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.setName(t.image);
                {if (true) return jjtn000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		longType
**/
  final public SimpleNode LongType() throws ParseException {
 /*@bgen(jjtree) LongType */
  SFPLongType jjtn000 = new SFPLongType(this, JJTLONGTYPE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(LONG_TYPE);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.setName(t.image);
                {if (true) return jjtn000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		ShortType
**/
  final public SimpleNode ShortType() throws ParseException {
 /*@bgen(jjtree) ShortType */
  SFPShortType jjtn000 = new SFPShortType(this, JJTSHORTTYPE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(SHORT_TYPE);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.setName(t.image);
                {if (true) return jjtn000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		FloatType
**/
  final public SimpleNode FloatType() throws ParseException {
 /*@bgen(jjtree) FloatType */
  SFPFloatType jjtn000 = new SFPFloatType(this, JJTFLOATTYPE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(FLOAT_TYPE);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.setName(t.image);
                {if (true) return jjtn000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		DoubleType
**/
  final public SimpleNode DoubleType() throws ParseException {
 /*@bgen(jjtree) DoubleType */
  SFPDoubleType jjtn000 = new SFPDoubleType(this, JJTDOUBLETYPE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(DOUBLE_TYPE);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.setName(t.image);
                {if (true) return jjtn000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		NumberType
**/
  final public SimpleNode NumberType() throws ParseException {
 /*@bgen(jjtree) NumberType */
  SFPNumberType jjtn000 = new SFPNumberType(this, JJTNUMBERTYPE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(NUMBER_TYPE);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.setName(t.image);
                {if (true) return jjtn000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		False
**/
  final public SimpleNode False() throws ParseException {
 /*@bgen(jjtree) False */
  SFPFalse jjtn000 = new SFPFalse(this, JJTFALSE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(FALSE);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.setName(t.image);
                {if (true) return jjtn000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Lexeme
**/
  final public void Lexeme() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRING:
      String();
      break;
    case SYMBOL:
      Symbol();
      break;
    default:
      jj_la1[3] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
*		Constant
**/
  final public SimpleNode Constant() throws ParseException {
 /*@bgen(jjtree) Constant */
  SFPConstant jjtn000 = new SFPConstant(this, JJTCONSTANT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NIL:
        Nil();
        break;
      case DATETIME:
        DateTime();
        break;
      case SYMBOL:
        Symbol();
        break;
      case STRING:
        String();
        break;
      case INTEGER:
        Integer();
        break;
      case FLOAT:
        Float();
        break;
      case TRUE:
      case FALSE:
        BooleanSymbol();
        break;
      default:
        jj_la1[4] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Construct Description
**/
  final public SimpleNode ConstructDescription() throws ParseException {
 /*@bgen(jjtree) ConstructDescription */
  SFPConstructDescription jjtn000 = new SFPConstructDescription(this, JJTCONSTRUCTDESCRIPTION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      String();
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Single Variable
**/
// This is used exactly then when only the variables value is needed
  final public SimpleNode SingleVariable() throws ParseException {
 /*@bgen(jjtree) SingleVariable */
  SFPSingleVariable jjtn000 = new SFPSingleVariable(this, JJTSINGLEVARIABLE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(SINGLEVAR);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          jjtn000.setName(t.image); {if (true) return jjtn000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Global Variable
**/
// This is used exactly then when only the variables value is needed
  final public SimpleNode GlobalVariable() throws ParseException {
 /*@bgen(jjtree) GlobalVariable */
  SFPGlobalVariable jjtn000 = new SFPGlobalVariable(this, JJTGLOBALVARIABLE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(GLOBALVAR);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          jjtn000.setName(t.image); {if (true) return jjtn000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Multi Variable
**/
// This is used exactly then when only the variables contents are needed
  final public SimpleNode MultiVariable() throws ParseException {
 /*@bgen(jjtree) MultiVariable */
  SFPMultiVariable jjtn000 = new SFPMultiVariable(this, JJTMULTIVARIABLE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(MULTIVAR);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          jjtn000.setName(t.image); {if (true) return jjtn000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Variable
**/
// This is used exactly then when only the variables value is needed
  final public void Variable() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SINGLEVAR:
      SingleVariable();
      break;
    case MULTIVAR:
      MultiVariable();
      break;
    case GLOBALVAR:
      GlobalVariable();
      break;
    default:
      jj_la1[5] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
*		Variable Type
**/
// This is used exactly then when only the variables contents are needed
  final public SimpleNode VariableType() throws ParseException {
 /*@bgen(jjtree) VariableType */
  SFPVariableType jjtn000 = new SFPVariableType(this, JJTVARIABLETYPE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(VARIABLE_TYPE);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.setName(t.image);
                {if (true) return jjtn000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Function Call
**/

// <function-call> ::= (<function-name> <expression>*)
  final public void FunctionCall() throws ParseException {
    jj_consume_token(LBRACE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ASSERT:
      AssertFunc();
      break;
    case MODIFY:
      Modify();
      break;
    case RETRACT:
      RetractFunc();
      break;
    case FIND_FACT_BY_FACT:
      FindFactByFactFunc();
      break;
    case IF:
      IfElseFunc();
      break;
    case WHILE:
      WhileFunc();
      break;
    case LOOP_FOR_COUNT:
      LoopForCountFunc();
      break;
    case SYMBOL:
      AnyFunction();
      break;
    case SWITCH:
      SwitchCaseFunc();
      break;
    default:
      jj_la1[6] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(RBRACE);
  }

/**
*		Any Function
**/
  final public SimpleNode AnyFunction() throws ParseException {
 /*@bgen(jjtree) AnyFunction */
  SFPAnyFunction jjtn000 = new SFPAnyFunction(this, JJTANYFUNCTION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      Symbol();
      label_1:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LBRACE:
        case INTEGER:
        case FLOAT:
        case DATETIME:
        case STRING:
        case GLOBALVAR:
        case TRUE:
        case FALSE:
        case NIL:
        case SINGLEVAR:
        case MULTIVAR:
        case SYMBOL:
          ;
          break;
        default:
          jj_la1[7] = jj_gen;
          break label_1;
        }
        Expression();
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Expression
**/
  final public SimpleNode Expression() throws ParseException {
 /*@bgen(jjtree) Expression */
  SFPExpression jjtn000 = new SFPExpression(this, JJTEXPRESSION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      if (jj_2_2(2)) {
        Constant();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case GLOBALVAR:
        case SINGLEVAR:
        case MULTIVAR:
          Variable();
          break;
        case LBRACE:
          FunctionCall();
          break;
        default:
          jj_la1[8] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/****
**		 Special functions wich are defined by CLIPS to have
**		a non-standart syntax (e.g. not all parameters are expressions)
****/

/**
*		Assert Function
**/
  final public SimpleNode AssertFunc() throws ParseException {
 /*@bgen(jjtree) AssertFunc */
  SFPAssertFunc jjtn000 = new SFPAssertFunc(this, JJTASSERTFUNC);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(ASSERT);
      label_2:
      while (true) {
        RHSPattern();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LBRACE:
          ;
          break;
        default:
          jj_la1[9] = jj_gen;
          break label_2;
        }
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Modify Function
**/
  final public SimpleNode Modify() throws ParseException {
 /*@bgen(jjtree) Modify */
  SFPModify jjtn000 = new SFPModify(this, JJTMODIFY);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(MODIFY);
      ModifyPattern();
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		FindFactByFact Function
**/
  final public SimpleNode FindFactByFactFunc() throws ParseException {
 /*@bgen(jjtree) FindFactByFactFunc */
  SFPFindFactByFactFunc jjtn000 = new SFPFindFactByFactFunc(this, JJTFINDFACTBYFACTFUNC);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(FIND_FACT_BY_FACT);
      RHSPattern();
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Retract Function
**/
  final public SimpleNode RetractFunc() throws ParseException {
 /*@bgen(jjtree) RetractFunc */
  SFPRetractFunc jjtn000 = new SFPRetractFunc(this, JJTRETRACTFUNC);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(RETRACT);
      label_3:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LBRACE:
        case INTEGER:
        case FLOAT:
        case DATETIME:
        case STRING:
        case GLOBALVAR:
        case TRUE:
        case FALSE:
        case NIL:
        case SINGLEVAR:
        case MULTIVAR:
        case SYMBOL:
          ;
          break;
        default:
          jj_la1[10] = jj_gen;
          break label_3;
        }
        Expression();
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		If Else Function
**/
  final public SimpleNode IfElseFunc() throws ParseException {
 /*@bgen(jjtree) IfElseFunc */
  SFPIfElseFunc jjtn000 = new SFPIfElseFunc(this, JJTIFELSEFUNC);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(IF);
      Expression();
      jj_consume_token(THEN);
      ActionList();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ELSE:
        jj_consume_token(ELSE);
        ActionList();
        break;
      default:
        jj_la1[11] = jj_gen;
        ;
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		While Function
**/
  final public SimpleNode WhileFunc() throws ParseException {
 /*@bgen(jjtree) WhileFunc */
  SFPWhileFunc jjtn000 = new SFPWhileFunc(this, JJTWHILEFUNC);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(WHILE);
      Expression();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DO:
        jj_consume_token(DO);
        break;
      default:
        jj_la1[12] = jj_gen;
        ;
      }
      ActionList();
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Loop For Count Function
**/
  final public SimpleNode LoopForCountFunc() throws ParseException {
 /*@bgen(jjtree) LoopForCountFunc */
  SFPLoopForCountFunc jjtn000 = new SFPLoopForCountFunc(this, JJTLOOPFORCOUNTFUNC);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(LOOP_FOR_COUNT);
      jj_consume_token(LBRACE);
      SingleVariable();
      Expression();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LBRACE:
      case INTEGER:
      case FLOAT:
      case DATETIME:
      case STRING:
      case GLOBALVAR:
      case TRUE:
      case FALSE:
      case NIL:
      case SINGLEVAR:
      case MULTIVAR:
      case SYMBOL:
        Expression();
        break;
      default:
        jj_la1[13] = jj_gen;
        ;
      }
      jj_consume_token(RBRACE);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DO:
        jj_consume_token(DO);
        break;
      default:
        jj_la1[14] = jj_gen;
        ;
      }
      ActionList();
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Case Switch Function
**/
  final public SimpleNode SwitchCaseFunc() throws ParseException {
 /*@bgen(jjtree) SwitchCaseFunc */
  SFPSwitchCaseFunc jjtn000 = new SFPSwitchCaseFunc(this, JJTSWITCHCASEFUNC);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(SWITCH);
      Expression();
      label_4:
      while (true) {
        if (jj_2_3(2)) {
          ;
        } else {
          break label_4;
        }
        CaseStatement();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LBRACE:
        jj_consume_token(LBRACE);
        SwitchDefaults();
        jj_consume_token(RBRACE);
        break;
      default:
        jj_la1[15] = jj_gen;
        ;
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Case Statement Function
**/
  final public SimpleNode CaseStatement() throws ParseException {
 /*@bgen(jjtree) CaseStatement */
  SFPCaseStatement jjtn000 = new SFPCaseStatement(this, JJTCASESTATEMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(LBRACE);
      jj_consume_token(CASE);
      Expression();
      jj_consume_token(THEN);
      ActionList();
      jj_consume_token(RBRACE);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Default Statements for SwitchCaseFunc
**/
  final public SimpleNode SwitchDefaults() throws ParseException {
 /*@bgen(jjtree) SwitchDefaults */
  SFPSwitchDefaults jjtn000 = new SFPSwitchDefaults(this, JJTSWITCHDEFAULTS);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(LBRACE);
      jj_consume_token(DEFAULT_ATR);
      ActionList();
      jj_consume_token(RBRACE);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Construct - Definition Main Handler 
**/
  final public void Construct() throws ParseException {
    jj_consume_token(LBRACE);
    if (jj_2_4(2)) {
      DeftemplateConstruct();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DEFGLOBAL:
        DefglobalConstruct();
        break;
      case DEFRULE:
        DefruleConstruct();
        break;
      case DEFFUNCTION:
        DeffunctionConstruct();
        break;
      case DEFMODULE:
        DefmoduleConstruct();
        break;
      default:
        jj_la1[16] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(RBRACE);
  }

/**
*		Deftemplate Construct
**/
// <deftemplate-construct> ::= (deftemplate <deftemplate-name> [<comment>] <slot-definition>*)
  final public SimpleNode DeftemplateConstruct() throws ParseException {
 /*@bgen(jjtree) DeftemplateConstruct */
  SFPDeftemplateConstruct jjtn000 = new SFPDeftemplateConstruct(this, JJTDEFTEMPLATECONSTRUCT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(DEFTEMPLATE);
      Symbol();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STRING:
        ConstructDescription();
        break;
      default:
        jj_la1[17] = jj_gen;
        ;
      }
      label_5:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LBRACE:
          ;
          break;
        default:
          jj_la1[18] = jj_gen;
          break label_5;
        }
        SlotDefinition();
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

  final public SimpleNode Silent() throws ParseException {
 /*@bgen(jjtree) Silent */
  SFPSilent jjtn000 = new SFPSilent(this, JJTSILENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(SILENT);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
         {if (true) return jjtn000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Slot Definition
**/
//<slot-definition> ::= <single-slot-definition> | <multislot-definition>
  final public SimpleNode SlotDefinition() throws ParseException {
 /*@bgen(jjtree) SlotDefinition */
  SFPSlotDefinition jjtn000 = new SFPSlotDefinition(this, JJTSLOTDEFINITION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(LBRACE);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SILENT:
        Silent();
        break;
      default:
        jj_la1[19] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SLOT:
        SingleSlotDefinition();
        break;
      case MULTISLOT:
        MultiSlotDefinition();
        break;
      default:
        jj_la1[20] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(RBRACE);
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
     {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Single Slot Definition
**/
//< single-slot-definition> ::= ( slot <slot-name> <template-attribute>*)
  final public SimpleNode SingleSlotDefinition() throws ParseException {
 /*@bgen(jjtree) SingleSlotDefinition */
  SFPSingleSlotDefinition jjtn000 = new SFPSingleSlotDefinition(this, JJTSINGLESLOTDEFINITION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(SLOT);
      Symbol();
      label_6:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LBRACE:
          ;
          break;
        default:
          jj_la1[21] = jj_gen;
          break label_6;
        }
        TemplateAttribute();
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Multi Slot Definition
**/
//<multislot-definition> ::= ( multislot <slot-name> <template-attribute>*)
  final public SimpleNode MultiSlotDefinition() throws ParseException {
 /*@bgen(jjtree) MultiSlotDefinition */
  SFPMultiSlotDefinition jjtn000 = new SFPMultiSlotDefinition(this, JJTMULTISLOTDEFINITION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(MULTISLOT);
      Symbol();
      label_7:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LBRACE:
          ;
          break;
        default:
          jj_la1[22] = jj_gen;
          break label_7;
        }
        TemplateAttribute();
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Template Attribute
**/
//<template-attribute> ::= <default-attribute> | <constraint-attribute>
  final public void TemplateAttribute() throws ParseException {
    jj_consume_token(LBRACE);
    if (jj_2_5(2)) {
      DefaultAttribute();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DYNAMIC_ATR:
        DynamicAttribute();
        break;
      case TYPE:
      case ALLOWED_SYMBOLS:
      case ALLOWED_STRINGS:
      case ALLOWED_LEXEMES:
      case ALLOWED_INTEGERS:
      case ALLOWED_LONGS:
      case ALLOWED_SHORTS:
      case ALLOWED_FLOATS:
      case ALLOWED_DOUBLES:
      case ALLOWED_NUMBERS:
      case ALLOWED_VALUES:
      case RANGE:
      case CARDINALITY:
        ConstraintAttribute();
        break;
      default:
        jj_la1[23] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(RBRACE);
  }

/**
*		Attributes
**/
// A dummy node to have a list of attributes
  final public SimpleNode Attributes() throws ParseException {
 /*@bgen(jjtree) Attributes */
  SFPAttributes jjtn000 = new SFPAttributes(this, JJTATTRIBUTES);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      label_8:
      while (true) {
        if (jj_2_6(2)) {
          ;
        } else {
          break label_8;
        }
        Expression();
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Default Attribute
**/
//<default-attribute> ::= (default ?DERIVE | ?NONE | <expression>*) | (default-dynamic <expression>*)
  final public SimpleNode DefaultAttribute() throws ParseException {
 /*@bgen(jjtree) DefaultAttribute */
  SFPDefaultAttribute jjtn000 = new SFPDefaultAttribute(this, JJTDEFAULTATTRIBUTE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(DEFAULT_ATR);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ATR_DERIVE:
        DeriveAttribute();
        break;
      case ATR_NONE:
        NoneAttribute();
        break;
      default:
        jj_la1[24] = jj_gen;
        DefaultAttributes();
      }
                  jjtree.closeNodeScope(jjtn000, true);
                  jjtc000 = false;
                  {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
                  if (jjtc000) {
                    jjtree.clearNodeScope(jjtn000);
                    jjtc000 = false;
                  } else {
                    jjtree.popNode();
                  }
                  if (jjte000 instanceof RuntimeException) {
                    {if (true) throw (RuntimeException)jjte000;}
                  }
                  if (jjte000 instanceof ParseException) {
                    {if (true) throw (ParseException)jjte000;}
                  }
                  {if (true) throw (Error)jjte000;}
    } finally {
                  if (jjtc000) {
                    jjtree.closeNodeScope(jjtn000, true);
                  }
    }
    throw new Error("Missing return statement in function");
  }

  final public SimpleNode DefaultAttributes() throws ParseException {
 /*@bgen(jjtree) DefaultAttributes */
  SFPDefaultAttributes jjtn000 = new SFPDefaultAttributes(this, JJTDEFAULTATTRIBUTES);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      Attributes();
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Derive Attribute
**/
  final public SimpleNode DeriveAttribute() throws ParseException {
 /*@bgen(jjtree) DeriveAttribute */
  SFPDeriveAttribute jjtn000 = new SFPDeriveAttribute(this, JJTDERIVEATTRIBUTE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(ATR_DERIVE);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.setName(t.image);
                {if (true) return jjtn000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		None Attribute
**/
  final public SimpleNode NoneAttribute() throws ParseException {
 /*@bgen(jjtree) NoneAttribute */
  SFPNoneAttribute jjtn000 = new SFPNoneAttribute(this, JJTNONEATTRIBUTE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(ATR_NONE);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.setName(t.image);
                {if (true) return jjtn000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Dynamic Attribute
**/

//<default-attribute> ::= (default ?DERIVE | ?NONE | <expression>*) | (default-dynamic <expression>*)
  final public SimpleNode DynamicAttribute() throws ParseException {
 /*@bgen(jjtree) DynamicAttribute */
  SFPDynamicAttribute jjtn000 = new SFPDynamicAttribute(this, JJTDYNAMICATTRIBUTE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(DYNAMIC_ATR);
      Attributes();
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

  final public SimpleNode ModifyPattern() throws ParseException {
 /*@bgen(jjtree) ModifyPattern */
  SFPModifyPattern jjtn000 = new SFPModifyPattern(this, JJTMODIFYPATTERN);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      Variable();
      label_9:
      while (true) {
        RHSSlot();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LBRACE:
          ;
          break;
        default:
          jj_la1[25] = jj_gen;
          break label_9;
        }
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

  final public SimpleNode RHSSlot() throws ParseException {
 /*@bgen(jjtree) RHSSlot */
  SFPRHSSlot jjtn000 = new SFPRHSSlot(this, JJTRHSSLOT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(LBRACE);
      Symbol();
      label_10:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LBRACE:
        case INTEGER:
        case FLOAT:
        case DATETIME:
        case STRING:
        case GLOBALVAR:
        case TRUE:
        case FALSE:
        case NIL:
        case SINGLEVAR:
        case MULTIVAR:
        case SYMBOL:
          ;
          break;
        default:
          jj_la1[26] = jj_gen;
          break label_10;
        }
        RHSField();
      }
      jj_consume_token(RBRACE);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Fact Construct
**/


/**
*		Right Hand Site Pattern
**/
// <RHS-pattern> ::= <ordered-RHS-pattern> | <template-RHS-pattern>
  final public SimpleNode RHSPattern() throws ParseException {
 /*@bgen(jjtree) RHSPattern */
  SFPRHSPattern jjtn000 = new SFPRHSPattern(this, JJTRHSPATTERN);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(LBRACE);
      Symbol();
      if (jj_2_7(2)) {
        jj_consume_token(LBRACE);
        TemporalValidity();
        jj_consume_token(RBRACE);
      } else {
        ;
      }
      label_11:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LBRACE:
        case INTEGER:
        case FLOAT:
        case DATETIME:
        case STRING:
        case GLOBALVAR:
        case TRUE:
        case FALSE:
        case NIL:
        case SINGLEVAR:
        case MULTIVAR:
        case SYMBOL:
          ;
          break;
        default:
          jj_la1[27] = jj_gen;
          break label_11;
        }
        RHSField();
      }
      jj_consume_token(RBRACE);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Right Hand Site Field
**/

//<RHS-field> ::= <variable> | <constant> | <function-call>
  final public void RHSField() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case GLOBALVAR:
    case SINGLEVAR:
    case MULTIVAR:
      Variable();
      break;
    case INTEGER:
    case FLOAT:
    case DATETIME:
    case STRING:
    case TRUE:
    case FALSE:
    case NIL:
    case SYMBOL:
      Constant();
      break;
    case LBRACE:
      FunctionCall();
      break;
    default:
      jj_la1[28] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
*		Define Rule Construct
**/

/*
<defrule-construct> ::= (defrule <rule-name> [<comment>] [<declaration>] <conditional-element>* => <expression>*) 
<rule-property> ::= (salience <integer-expression>) | (auto-focus <boolean-symbol>)
<boolean-symbol> ::= TRUE | FALSE
<conditional-element> ::= <pattern-CE> | <assigned-pattern-CE> | <not-CE> | <and-CE> | <or-CE> |
	<logical-CE> | <test-CE> | <exists-CE> | <forall-CE>
<pattern-CE> ::= <ordered-pattern-CE> | <template-pattern-CE> | <object-pattern-CE>
<assigned-pattern-CE> ::= <single-field-variable> <- <pattern-CE>
<not-CE> ::= (not <conditional-element>)
<and-CE> ::= (and <conditional-element>+)
<or-CE> ::= (or <conditional-element>+)
<logical-CE> ::= (logical <conditional-element>+)
<test-CE> ::= (test <function-call>)
<exists-CE> ::= (exists <conditional-element>+)
<forall-CE> ::= (forall <conditional-element> <conditional-element>+)
<ordered-pattern-CE> ::= (<symbol> <constraint>*)
<template-pattern-CE> ::= (<deftemplate-name> <LHS-slot>*)
<object-pattern-CE> ::= (object <attribute-constraint>*)
<attribute-constraint> ::= (is-a <constraint>) | (name <constraint>) | (<slot-name> <constraint>*)
<LHS-slot> ::= <single-field-LHS-slot> | <multifield-LHS-slot>
<single-field-LHS-slot> ::= (<slot-name> <constraint>)
<multifield-LHS-slot> ::= (<slot-name> <constraint>*)
<constraint> ::= ? | $? | <connected-constraint>
<connected-constraint>::= <single-constraint> | <single-constraint> & <connected-constraint> |
	<single-constraint> | <connected-constraint>
<single-constraint> ::= <term> | ~<term>
<term> ::= <constant> | <single-field-variable> | <multifield-variable> | 
	:<function-call> | =<function-call>
*/



/**
*		Define Rule Construct
**/

// <defrule-construct> ::= (defrule <rule-name> [<comment>] [<declaration>] <conditional-element>* => <expression>*) 
  final public SimpleNode DefruleConstruct() throws ParseException {
 /*@bgen(jjtree) DefruleConstruct */
  SFPDefruleConstruct jjtn000 = new SFPDefruleConstruct(this, JJTDEFRULECONSTRUCT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(DEFRULE);
      Symbol();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STRING:
        ConstructDescription();
        break;
      default:
        jj_la1[29] = jj_gen;
        ;
      }
      if (jj_2_8(3)) {
        Declaration();
      } else {
        ;
      }
      label_12:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LBRACE:
        case SINGLEVAR:
          ;
          break;
        default:
          jj_la1[30] = jj_gen;
          break label_12;
        }
        ConditionalElement();
      }
      jj_consume_token(ARROW);
      ActionList();
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Action List
**/

// Create Dummy node to have fixed number of children in Defrule
  final public SimpleNode ActionList() throws ParseException {
                         /*@bgen(jjtree) ActionList */
  SFPActionList jjtn000 = new SFPActionList(this, JJTACTIONLIST);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      label_13:
      while (true) {
        if (jj_2_9(2)) {
          ;
        } else {
          break label_13;
        }
        Expression();
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Declaration
**/

//<declaration> ::= (declare <rule-property>+)
  final public SimpleNode Declaration() throws ParseException {
 /*@bgen(jjtree) Declaration */
  SFPDeclaration jjtn000 = new SFPDeclaration(this, JJTDECLARATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(LBRACE);
      jj_consume_token(DECLARE);
      label_14:
      while (true) {
        RuleProperty();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LBRACE:
          ;
          break;
        default:
          jj_la1[31] = jj_gen;
          break label_14;
        }
      }
      jj_consume_token(RBRACE);
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Rule Property
**/

// <rule-property> ::= (salience <integer-expression>) | (auto-focus <boolean-symbol>)
  final public void RuleProperty() throws ParseException {
    jj_consume_token(LBRACE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SALIENCE:
      Salience();
      break;
    case AUTOFOCUS:
      AutoFocus();
      break;
    case SLOWCOMPILE:
      SlowCompile();
      break;
    case RULEVERSION:
      RuleVersion();
      break;
    case TEMPORALVALIDITY:
      TemporalValidityDeclaration();
      break;
    default:
      jj_la1[32] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(RBRACE);
  }

  final public SimpleNode TemporalValidityDeclaration() throws ParseException {
 /*@bgen(jjtree) TemporalValidityDeclaration */
  SFPTemporalValidityDeclaration jjtn000 = new SFPTemporalValidityDeclaration(this, JJTTEMPORALVALIDITYDECLARATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      TemporalValidity();
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Temporal Validity
**/
  final public SimpleNode TemporalValidity() throws ParseException {
 /*@bgen(jjtree) TemporalValidity */
  SFPTemporalValidity jjtn000 = new SFPTemporalValidity(this, JJTTEMPORALVALIDITY);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(TEMPORALVALIDITY);
      label_15:
      while (true) {
        TemporalAttribute();
        if (jj_2_10(2)) {
          ;
        } else {
          break label_15;
        }
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Temporal Attribute
**/
  final public void TemporalAttribute() throws ParseException {
    jj_consume_token(LBRACE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MILLISECOND:
      TAMillisecond();
      break;
    case SECOND:
      TASecond();
      break;
    case MINUTE:
      TAMinute();
      break;
    case HOUR:
      TAHour();
      break;
    case DAY:
      TADay();
      break;
    case MONTH:
      TAMonth();
      break;
    case YEAR:
      TAYear();
      break;
    case WEEKDAY:
      TAWeekday();
      break;
    case DURATION:
      TADuration();
      break;
    default:
      jj_la1[33] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(RBRACE);
  }

  final public SimpleNode TAMillisecond() throws ParseException {
 /*@bgen(jjtree) TAMillisecond */
  SFPTAMillisecond jjtn000 = new SFPTAMillisecond(this, JJTTAMILLISECOND);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(MILLISECOND);
      Expression();
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public SimpleNode TASecond() throws ParseException {
 /*@bgen(jjtree) TASecond */
  SFPTASecond jjtn000 = new SFPTASecond(this, JJTTASECOND);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(SECOND);
      Expression();
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

  final public SimpleNode TAMinute() throws ParseException {
 /*@bgen(jjtree) TAMinute */
  SFPTAMinute jjtn000 = new SFPTAMinute(this, JJTTAMINUTE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(MINUTE);
      Expression();
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

  final public SimpleNode TAHour() throws ParseException {
 /*@bgen(jjtree) TAHour */
  SFPTAHour jjtn000 = new SFPTAHour(this, JJTTAHOUR);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(HOUR);
      Expression();
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

  final public SimpleNode TADay() throws ParseException {
 /*@bgen(jjtree) TADay */
  SFPTADay jjtn000 = new SFPTADay(this, JJTTADAY);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(DAY);
      Expression();
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

  final public SimpleNode TAMonth() throws ParseException {
 /*@bgen(jjtree) TAMonth */
  SFPTAMonth jjtn000 = new SFPTAMonth(this, JJTTAMONTH);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(MONTH);
      Expression();
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

  final public SimpleNode TAYear() throws ParseException {
 /*@bgen(jjtree) TAYear */
  SFPTAYear jjtn000 = new SFPTAYear(this, JJTTAYEAR);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(YEAR);
      Expression();
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

  final public SimpleNode TAWeekday() throws ParseException {
 /*@bgen(jjtree) TAWeekday */
  SFPTAWeekday jjtn000 = new SFPTAWeekday(this, JJTTAWEEKDAY);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(WEEKDAY);
      Expression();
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

  final public SimpleNode TADuration() throws ParseException {
 /*@bgen(jjtree) TADuration */
  SFPTADuration jjtn000 = new SFPTADuration(this, JJTTADURATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(DURATION);
      Expression();
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Salience
**/
  final public SimpleNode Salience() throws ParseException {
 /*@bgen(jjtree) Salience */
  SFPSalience jjtn000 = new SFPSalience(this, JJTSALIENCE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(SALIENCE);
      Expression();
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Auto Focus
**/
  final public SimpleNode AutoFocus() throws ParseException {
 /*@bgen(jjtree) AutoFocus */
  SFPAutoFocus jjtn000 = new SFPAutoFocus(this, JJTAUTOFOCUS);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(AUTOFOCUS);
      BooleanSymbol();
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*       Slow Compile
**/
  final public SimpleNode SlowCompile() throws ParseException {
 /*@bgen(jjtree) SlowCompile */
  SFPSlowCompile jjtn000 = new SFPSlowCompile(this, JJTSLOWCOMPILE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(SLOWCOMPILE);
      BooleanSymbol();
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Rule Version
**/
  final public SimpleNode RuleVersion() throws ParseException {
 /*@bgen(jjtree) RuleVersion */
  SFPRuleVersion jjtn000 = new SFPRuleVersion(this, JJTRULEVERSION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(RULEVERSION);
      Expression();
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Boolean Symbol
**/

//<boolean-symbol> ::= TRUE | FALSE
  final public void BooleanSymbol() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TRUE:
      True();
      break;
    case FALSE:
      False();
      break;
    default:
      jj_la1[34] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
*		Conditional Element
**/

//<conditional-element> ::= <pattern-CE> | <assigned-pattern-CE> | <not-CE> | <and-CE> | <or-CE> |
//                          <logical-CE> | <test-CE> | <exists-CE> | <forall-CE>
  final public void ConditionalElement() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACE:
      jj_consume_token(LBRACE);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SYMBOL:
        TemplatePatternCE();
        break;
      case NOT:
      case AND:
      case OR:
        BooleanFunction();
        break;
      case LOGICAL:
        LogicalCE();
        break;
      case TEST:
        TestCE();
        break;
      case EXISTS:
        ExistsCE();
        break;
      case FORALL:
        ForallCE();
        break;
      default:
        jj_la1[35] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(RBRACE);
      break;
    case SINGLEVAR:
      AssignedPatternCE();
      break;
    default:
      jj_la1[36] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
*		Boolean Function
**/
  final public void BooleanFunction() throws ParseException {
    if (jj_2_11(2)) {
      NotFunction();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AND:
        AndFunction();
        break;
      case OR:
        OrFunction();
        break;
      default:
        jj_la1[37] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/**
*		And Function
**/
  final public SimpleNode NotFunction() throws ParseException {
 /*@bgen(jjtree) NotFunction */
  SFPNotFunction jjtn000 = new SFPNotFunction(this, JJTNOTFUNCTION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(NOT);
      ConditionalElement();
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		And Function
**/
  final public SimpleNode AndFunction() throws ParseException {
 /*@bgen(jjtree) AndFunction */
  SFPAndFunction jjtn000 = new SFPAndFunction(this, JJTANDFUNCTION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(AND);
      label_16:
      while (true) {
        ConditionalElement();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LBRACE:
        case SINGLEVAR:
          ;
          break;
        default:
          jj_la1[38] = jj_gen;
          break label_16;
        }
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Or Function
**/
  final public SimpleNode OrFunction() throws ParseException {
 /*@bgen(jjtree) OrFunction */
  SFPOrFunction jjtn000 = new SFPOrFunction(this, JJTORFUNCTION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(OR);
      label_17:
      while (true) {
        ConditionalElement();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LBRACE:
        case SINGLEVAR:
          ;
          break;
        default:
          jj_la1[39] = jj_gen;
          break label_17;
        }
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Pattern Conditional Element
**/

//<assigned-pattern-CE> ::= <single-field-variable> <- <pattern-CE>
// Create and return conditions
  final public SimpleNode AssignedPatternCE() throws ParseException {
 /*@bgen(jjtree) AssignedPatternCE */
  SFPAssignedPatternCE jjtn000 = new SFPAssignedPatternCE(this, JJTASSIGNEDPATTERNCE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      SingleVariable();
      jj_consume_token(ASSIGN);
      jj_consume_token(LBRACE);
      TemplatePatternCE();
      jj_consume_token(RBRACE);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Logical CE
**/

//<logical-CE> ::= (logical <conditional-element>+)
// Create and return conditions
  final public SimpleNode LogicalCE() throws ParseException {
 /*@bgen(jjtree) LogicalCE */
  SFPLogicalCE jjtn000 = new SFPLogicalCE(this, JJTLOGICALCE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(LOGICAL);
      label_18:
      while (true) {
        ConditionalElement();
        if (jj_2_12(2)) {
          ;
        } else {
          break label_18;
        }
      }
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Test CE
**/

//<test-CE> ::= (test <function-call>)
// Create and return conditions (initialize the function before execution, to get a node
  final public SimpleNode TestCE() throws ParseException {
 /*@bgen(jjtree) TestCE */
  SFPTestCE jjtn000 = new SFPTestCE(this, JJTTESTCE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(TEST);
      FunctionCall();
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Exists CE
**/

//<exists-CE> ::= (exists <conditional-element>+)
// Create and return conditions
  final public SimpleNode ExistsCE() throws ParseException {
 /*@bgen(jjtree) ExistsCE */
  SFPExistsCE jjtn000 = new SFPExistsCE(this, JJTEXISTSCE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(EXISTS);
      label_19:
      while (true) {
        ConditionalElement();
        if (jj_2_13(2)) {
          ;
        } else {
          break label_19;
        }
      }
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Forall CE
**/

//<forall-CE> ::= (forall <conditional-element> <conditional-element>+)
// Create and return conditions
  final public SimpleNode ForallCE() throws ParseException {
 /*@bgen(jjtree) ForallCE */
  SFPForallCE jjtn000 = new SFPForallCE(this, JJTFORALLCE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(FORALL);
      ConditionalElement();
      label_20:
      while (true) {
        ConditionalElement();
        if (jj_2_14(2)) {
          ;
        } else {
          break label_20;
        }
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
         {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Template Pattern CE
**/

//<template-pattern-CE> ::= (<deftemplate-name> <LHS-slot>*)
  final public SimpleNode TemplatePatternCE() throws ParseException {
 /*@bgen(jjtree) TemplatePatternCE */
  SFPTemplatePatternCE jjtn000 = new SFPTemplatePatternCE(this, JJTTEMPLATEPATTERNCE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      Symbol();
      if (jj_2_15(2)) {
        label_21:
        while (true) {
          UnorderedLHSFactBody();
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case LBRACE:
            ;
            break;
          default:
            jj_la1[40] = jj_gen;
            break label_21;
          }
        }
      } else {
        OrderedLHSFactBody();
      }
     jjtree.closeNodeScope(jjtn000, true);
     jjtc000 = false;
     {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public SimpleNode UnorderedLHSFactBody() throws ParseException {
 /*@bgen(jjtree) UnorderedLHSFactBody */
  SFPUnorderedLHSFactBody jjtn000 = new SFPUnorderedLHSFactBody(this, JJTUNORDEREDLHSFACTBODY);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(LBRACE);
      LHSSlot();
      jj_consume_token(RBRACE);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

  final public SimpleNode OrderedLHSFactBody() throws ParseException {
 /*@bgen(jjtree) OrderedLHSFactBody */
  SFPOrderedLHSFactBody jjtn000 = new SFPOrderedLHSFactBody(this, JJTORDEREDLHSFACTBODY);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      label_22:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case INTEGER:
        case FLOAT:
        case DATETIME:
        case STRING:
        case SFWILDCARD:
        case MFWILDCARD:
        case TRUE:
        case FALSE:
        case NIL:
        case TILDE:
        case COLON:
        case EQUALS:
        case SINGLEVAR:
        case MULTIVAR:
        case SYMBOL:
          ;
          break;
        default:
          jj_la1[41] = jj_gen;
          break label_22;
        }
        Constraint();
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		LHSSlot
**/

//<LHS-slot> ::= <single-field-LHS-slot> | <multifield-LHS-slot>
  final public SimpleNode LHSSlot() throws ParseException {
 /*@bgen(jjtree) LHSSlot */
  SFPLHSSlot jjtn000 = new SFPLHSSlot(this, JJTLHSSLOT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      Symbol();
      Constraint();
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Constraint
**/

//<constraint> ::= ? | $? | <connected-constraint>
  final public void Constraint() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SFWILDCARD:
      SingleFieldWildcard();
      break;
    case MFWILDCARD:
      MultiFieldWildcard();
      break;
    case INTEGER:
    case FLOAT:
    case DATETIME:
    case STRING:
    case TRUE:
    case FALSE:
    case NIL:
    case TILDE:
    case COLON:
    case EQUALS:
    case SINGLEVAR:
    case MULTIVAR:
    case SYMBOL:
      ConnectedConstraint();
      break;
    default:
      jj_la1[42] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
*		Singlefield Wildcard
**/
  final public SimpleNode SingleFieldWildcard() throws ParseException {
 /*@bgen(jjtree) SingleFieldWildcard */
  SFPSingleFieldWildcard jjtn000 = new SFPSingleFieldWildcard(this, JJTSINGLEFIELDWILDCARD);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(SFWILDCARD);
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      {if (true) return jjtn000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Multifield Wildcard
**/
  final public SimpleNode MultiFieldWildcard() throws ParseException {
 /*@bgen(jjtree) MultiFieldWildcard */
  SFPMultiFieldWildcard jjtn000 = new SFPMultiFieldWildcard(this, JJTMULTIFIELDWILDCARD);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(MFWILDCARD);
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      {if (true) return jjtn000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Connected Constraint
**/

//<connected-constraint>::= <single-constraint> | <single-constraint> & <connected-constraint> |
//	<single-constraint> | <connected-constraint>
  final public SimpleNode ConnectedConstraint() throws ParseException {
 /*@bgen(jjtree) ConnectedConstraint */
  SFPConnectedConstraint jjtn000 = new SFPConnectedConstraint(this, JJTCONNECTEDCONSTRAINT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      Term();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AMPERSAND:
      case LINE:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case AMPERSAND:
          AmpersandConnectedConstraint();
          break;
        case LINE:
          LineConnectedConstraint();
          break;
        default:
          jj_la1[43] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[44] = jj_gen;
        ;
      }
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
     {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Ampersand Connected Constraint
**/
  final public SimpleNode AmpersandConnectedConstraint() throws ParseException {
 /*@bgen(jjtree) AmpersandConnectedConstraint */
  SFPAmpersandConnectedConstraint jjtn000 = new SFPAmpersandConnectedConstraint(this, JJTAMPERSANDCONNECTEDCONSTRAINT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(AMPERSAND);
      Term();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AMPERSAND:
      case LINE:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LINE:
          LineConnectedConstraint();
          break;
        case AMPERSAND:
          AmpersandConnectedConstraint();
          break;
        default:
          jj_la1[45] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[46] = jj_gen;
        ;
      }
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Line Connected Constraint
**/
  final public SimpleNode LineConnectedConstraint() throws ParseException {
 /*@bgen(jjtree) LineConnectedConstraint */
  SFPLineConnectedConstraint jjtn000 = new SFPLineConnectedConstraint(this, JJTLINECONNECTEDCONSTRAINT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(LINE);
      Term();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AMPERSAND:
      case LINE:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LINE:
          LineConnectedConstraint();
          break;
        case AMPERSAND:
          AmpersandConnectedConstraint();
          break;
        default:
          jj_la1[47] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[48] = jj_gen;
        ;
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Term
**/

//<term> ::= <constant> | <single-field-variable> | <multifield-variable> | 
//	:<function-call> | =<function-call>
  final public SimpleNode Term() throws ParseException {
 /*@bgen(jjtree) Term */
  SFPTerm jjtn000 = new SFPTerm(this, JJTTERM);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TILDE:
        Negation();
        break;
      default:
        jj_la1[49] = jj_gen;
        ;
      }
      if (jj_2_16(3)) {
        Constant();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SINGLEVAR:
          SingleVariable();
          break;
        case MULTIVAR:
          MultiVariable();
          break;
        case COLON:
          Colon();
          break;
        case EQUALS:
          Equals();
          break;
        default:
          jj_la1[50] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
     {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Negation
**/
  final public SimpleNode Negation() throws ParseException {
 /*@bgen(jjtree) Negation */
  SFPNegation jjtn000 = new SFPNegation(this, JJTNEGATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(TILDE);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          {if (true) return jjtn000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Colon
**/
  final public SimpleNode Colon() throws ParseException {
 /*@bgen(jjtree) Colon */
  SFPColon jjtn000 = new SFPColon(this, JJTCOLON);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(COLON);
      FunctionCall();
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Equals
**/
  final public SimpleNode Equals() throws ParseException {
 /*@bgen(jjtree) Equals */
  SFPEquals jjtn000 = new SFPEquals(this, JJTEQUALS);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(EQUALS);
      FunctionCall();
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Defglobal Construct
**/

//<defglobal-construct> ::= (defglobal [<defmodule-name>] <global-assignment>*)
  final public SimpleNode DefglobalConstruct() throws ParseException {
 /*@bgen(jjtree) DefglobalConstruct */
  SFPDefglobalConstruct jjtn000 = new SFPDefglobalConstruct(this, JJTDEFGLOBALCONSTRUCT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(DEFGLOBAL);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SYMBOL:
        Symbol();
        break;
      default:
        jj_la1[51] = jj_gen;
        ;
      }
      label_23:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case GLOBALVAR:
          ;
          break;
        default:
          jj_la1[52] = jj_gen;
          break label_23;
        }
        GlobalAssignment();
      }
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Global Assignment
**/

//<global-assignment> ::= <global-variable> = <expression>
  final public SimpleNode GlobalAssignment() throws ParseException {
 /*@bgen(jjtree) GlobalAssignment */
  SFPGlobalAssignment jjtn000 = new SFPGlobalAssignment(this, JJTGLOBALASSIGNMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      GlobalVariable();
      jj_consume_token(EQUALS);
      Expression();
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Deffunction Construct
**/

//<deffunction-construct> 
//	::= (deffunction <name> [(functiongroup <groupname>)] [<comment>] (<regular-parameter>* [<wildcard-parameter>]) <expression>*)
  final public SimpleNode DeffunctionConstruct() throws ParseException {
 /*@bgen(jjtree) DeffunctionConstruct */
  SFPDeffunctionConstruct jjtn000 = new SFPDeffunctionConstruct(this, JJTDEFFUNCTIONCONSTRUCT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(DEFFUNCTION);
      Symbol();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STRING:
        ConstructDescription();
        break;
      default:
        jj_la1[53] = jj_gen;
        ;
      }
      jj_consume_token(LBRACE);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FUNCTIONGROUP:
        FunctionGroup();
        jj_consume_token(RBRACE);
        jj_consume_token(LBRACE);
        break;
      default:
        jj_la1[54] = jj_gen;
        ;
      }
      label_24:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SINGLEVAR:
          ;
          break;
        default:
          jj_la1[55] = jj_gen;
          break label_24;
        }
        SingleVariable();
      }
      label_25:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case MULTIVAR:
          ;
          break;
        default:
          jj_la1[56] = jj_gen;
          break label_25;
        }
        MultiVariable();
      }
      jj_consume_token(RBRACE);
      ActionList();
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Function Group
**/
  final public SimpleNode FunctionGroup() throws ParseException {
 /*@bgen(jjtree) FunctionGroup */
  SFPFunctionGroup jjtn000 = new SFPFunctionGroup(this, JJTFUNCTIONGROUP);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(FUNCTIONGROUP);
      Lexeme();
           jjtree.closeNodeScope(jjtn000, true);
           jjtc000 = false;
           {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
                  if (jjtc000) {
                    jjtree.clearNodeScope(jjtn000);
                    jjtc000 = false;
                  } else {
                    jjtree.popNode();
                  }
                  if (jjte000 instanceof RuntimeException) {
                    {if (true) throw (RuntimeException)jjte000;}
                  }
                  if (jjte000 instanceof ParseException) {
                    {if (true) throw (ParseException)jjte000;}
                  }
                  {if (true) throw (Error)jjte000;}
    } finally {
                  if (jjtc000) {
                    jjtree.closeNodeScope(jjtn000, true);
                  }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Defgeneric Construct 
**/

//	<defgeneric-construct> ::= (defgeneric <name> [<comment>])
  final public SimpleNode DefgenericConstruct() throws ParseException {
 /*@bgen(jjtree) DefgenericConstruct */
  SFPDefgenericConstruct jjtn000 = new SFPDefgenericConstruct(this, JJTDEFGENERICCONSTRUCT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(DEFGENERIC);
      Symbol();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STRING:
        ConstructDescription();
        break;
      default:
        jj_la1[57] = jj_gen;
        ;
      }
       jjtree.closeNodeScope(jjtn000, true);
       jjtc000 = false;
       {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
       if (jjtc000) {
         jjtree.clearNodeScope(jjtn000);
         jjtc000 = false;
       } else {
         jjtree.popNode();
       }
       if (jjte000 instanceof RuntimeException) {
         {if (true) throw (RuntimeException)jjte000;}
       }
       if (jjte000 instanceof ParseException) {
         {if (true) throw (ParseException)jjte000;}
       }
       {if (true) throw (Error)jjte000;}
    } finally {
       if (jjtc000) {
         jjtree.closeNodeScope(jjtn000, true);
       }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Parameter Restriction 
**/

//<parameter-restriction> ::= <single-field-variable> | (<single-field-variable> <type>* [<query>])
  final public SimpleNode ParameterRestriction() throws ParseException {
                                     /*@bgen(jjtree) ParameterRestriction */
  SFPParameterRestriction jjtn000 = new SFPParameterRestriction(this, JJTPARAMETERRESTRICTION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      if (jj_2_17(2)) {
        SingleVariable();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LBRACE:
          jj_consume_token(LBRACE);
          SingleVariable();
          label_26:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case SYMBOL_TYPE:
            case STRING_TYPE:
            case DATETIME_TYPE:
            case LEXEME_TYPE:
            case INTEGER_TYPE:
            case SHORT_TYPE:
            case LONG_TYPE:
            case FLOAT_TYPE:
            case DOUBLE_TYPE:
            case NUMBER_TYPE:
            case BOOLEAN_TYPE:
              ;
              break;
            default:
              jj_la1[58] = jj_gen;
              break label_26;
            }
            AllowedType();
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case LBRACE:
          case GLOBALVAR:
            Query();
            break;
          default:
            jj_la1[59] = jj_gen;
            ;
          }
          jj_consume_token(RBRACE);
          break;
        default:
          jj_la1[60] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Wildcard Parameter Restriction 
**/

//<wildcard-parameter-restriction> ::= <multifield-variable> | (<multifield-variable> <type>* [<query>])
  final public SimpleNode WildcardParameterRestriction() throws ParseException {
                                             /*@bgen(jjtree) WildcardParameterRestriction */
  SFPWildcardParameterRestriction jjtn000 = new SFPWildcardParameterRestriction(this, JJTWILDCARDPARAMETERRESTRICTION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      if (jj_2_18(2)) {
        MultiVariable();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LBRACE:
          jj_consume_token(LBRACE);
          MultiVariable();
          label_27:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case SYMBOL_TYPE:
            case STRING_TYPE:
            case DATETIME_TYPE:
            case LEXEME_TYPE:
            case INTEGER_TYPE:
            case SHORT_TYPE:
            case LONG_TYPE:
            case FLOAT_TYPE:
            case DOUBLE_TYPE:
            case NUMBER_TYPE:
            case BOOLEAN_TYPE:
              ;
              break;
            default:
              jj_la1[61] = jj_gen;
              break label_27;
            }
            AllowedType();
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case LBRACE:
          case GLOBALVAR:
            Query();
            break;
          default:
            jj_la1[62] = jj_gen;
            ;
          }
          jj_consume_token(RBRACE);
          break;
        default:
          jj_la1[63] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Query 
**/

//<query> ::= <global-variable> | <function-call>
  final public void Query() throws ParseException {
                /*@bgen(jjtree) Query */
                 SFPQuery jjtn000 = new SFPQuery(this, JJTQUERY);
                 boolean jjtc000 = true;
                 jjtree.openNodeScope(jjtn000);Token t;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case GLOBALVAR:
        GlobalVariable();
        break;
      case LBRACE:
        FunctionCall();
        break;
      default:
        jj_la1[64] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
                  if (jjtc000) {
                    jjtree.clearNodeScope(jjtn000);
                    jjtc000 = false;
                  } else {
                    jjtree.popNode();
                  }
                  if (jjte000 instanceof RuntimeException) {
                    {if (true) throw (RuntimeException)jjte000;}
                  }
                  if (jjte000 instanceof ParseException) {
                    {if (true) throw (ParseException)jjte000;}
                  }
                  {if (true) throw (Error)jjte000;}
    } finally {
                  if (jjtc000) {
                    jjtree.closeNodeScope(jjtn000, true);
                  }
    }
  }

/**
*		Constraint Attribute
**/

//<constraint-attribute> ::= <type-attribute> | <allowed-constant-attribute> | 
//	<range-attribute> | <cardinality-attribute>
  final public void ConstraintAttribute() throws ParseException {
    if (jj_2_19(2)) {
      TypeAttribute();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALLOWED_SYMBOLS:
      case ALLOWED_STRINGS:
      case ALLOWED_LEXEMES:
      case ALLOWED_INTEGERS:
      case ALLOWED_LONGS:
      case ALLOWED_SHORTS:
      case ALLOWED_FLOATS:
      case ALLOWED_DOUBLES:
      case ALLOWED_NUMBERS:
      case ALLOWED_VALUES:
        AllowedConstantAttribute();
        break;
      case RANGE:
        RangeAttribute();
        break;
      case CARDINALITY:
        CardinalityAttribute();
        break;
      default:
        jj_la1[65] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/**
*		Type Attribute
**/

//<type-attribute> ::= (type <type-specification>)
  final public SimpleNode TypeAttribute() throws ParseException {
 /*@bgen(jjtree) TypeAttribute */
  SFPTypeAttribute jjtn000 = new SFPTypeAttribute(this, JJTTYPEATTRIBUTE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(TYPE);
      TypeSpecification();
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Type Specification
**/

//<type-specification> ::= <allowed-type>+ | ?VARIABLE
  final public SimpleNode TypeSpecification() throws ParseException {
 /*@bgen(jjtree) TypeSpecification */
  SFPTypeSpecification jjtn000 = new SFPTypeSpecification(this, JJTTYPESPECIFICATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SYMBOL_TYPE:
      case STRING_TYPE:
      case DATETIME_TYPE:
      case LEXEME_TYPE:
      case INTEGER_TYPE:
      case SHORT_TYPE:
      case LONG_TYPE:
      case FLOAT_TYPE:
      case DOUBLE_TYPE:
      case NUMBER_TYPE:
      case BOOLEAN_TYPE:
        label_28:
        while (true) {
          AllowedType();
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SYMBOL_TYPE:
          case STRING_TYPE:
          case DATETIME_TYPE:
          case LEXEME_TYPE:
          case INTEGER_TYPE:
          case SHORT_TYPE:
          case LONG_TYPE:
          case FLOAT_TYPE:
          case DOUBLE_TYPE:
          case NUMBER_TYPE:
          case BOOLEAN_TYPE:
            ;
            break;
          default:
            jj_la1[66] = jj_gen;
            break label_28;
          }
        }
        break;
      case VARIABLE_TYPE:
        VariableType();
        break;
      default:
        jj_la1[67] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Allowed Type
**/

//<allowed-type> ::= SYMBOL | STRING | LEXEME | INTEGER | FLOAT | NUMBER |
// EXTERNAL-ADDRESS | FACT-ADDRESS | DATETIME
  final public void AllowedType() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SYMBOL_TYPE:
      SymbolType();
      break;
    case STRING_TYPE:
      StringType();
      break;
    case DATETIME_TYPE:
      DateTimeType();
      break;
    case LEXEME_TYPE:
      LexemeType();
      break;
    case INTEGER_TYPE:
      IntegerType();
      break;
    case LONG_TYPE:
      LongType();
      break;
    case SHORT_TYPE:
      ShortType();
      break;
    case FLOAT_TYPE:
      FloatType();
      break;
    case DOUBLE_TYPE:
      DoubleType();
      break;
    case NUMBER_TYPE:
      NumberType();
      break;
    case BOOLEAN_TYPE:
      BooleanType();
      break;
    default:
      jj_la1[68] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
*		Allowed Constant Atrributes
**/

// <allowed-constant-attribute> ::= (allowed-symbols <symbol-list>) | (allowed-strings <string-list>) |
//	(allowed-lexemes <lexeme-list> | (allowed-integers <integer-list>) | (allowed-floats <float-list>) |
//	(allowed-numbers <number-list>) | (allowed-values <value-list>)
  final public SimpleNode AllowedConstantAttribute() throws ParseException {
 /*@bgen(jjtree) AllowedConstantAttribute */
  SFPAllowedConstantAttribute jjtn000 = new SFPAllowedConstantAttribute(this, JJTALLOWEDCONSTANTATTRIBUTE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALLOWED_SYMBOLS:
        t = jj_consume_token(ALLOWED_SYMBOLS);
        SymbolList();
        break;
      case ALLOWED_STRINGS:
        t = jj_consume_token(ALLOWED_STRINGS);
        StringList();
        break;
      case ALLOWED_LEXEMES:
        t = jj_consume_token(ALLOWED_LEXEMES);
        LexemeList();
        break;
      case ALLOWED_INTEGERS:
        t = jj_consume_token(ALLOWED_INTEGERS);
        IntegerList();
        break;
      case ALLOWED_LONGS:
        t = jj_consume_token(ALLOWED_LONGS);
        IntegerList();
        break;
      case ALLOWED_SHORTS:
        t = jj_consume_token(ALLOWED_SHORTS);
        IntegerList();
        break;
      case ALLOWED_FLOATS:
        t = jj_consume_token(ALLOWED_FLOATS);
        FloatList();
        break;
      case ALLOWED_DOUBLES:
        t = jj_consume_token(ALLOWED_DOUBLES);
        FloatList();
        break;
      case ALLOWED_NUMBERS:
        t = jj_consume_token(ALLOWED_NUMBERS);
        NumberList();
        break;
      case ALLOWED_VALUES:
        t = jj_consume_token(ALLOWED_VALUES);
        ValueList();
        break;
      default:
        jj_la1[69] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
                jjtn000.setName(t.image);
                {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Symbol List
**/

//<symbol-list> ::= <symbol>+ | ?VARIABLE
  final public SimpleNode SymbolList() throws ParseException {
                           /*@bgen(jjtree) SymbolList */
  SFPSymbolList jjtn000 = new SFPSymbolList(this, JJTSYMBOLLIST);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SYMBOL:
        label_29:
        while (true) {
          jj_consume_token(SYMBOL);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SYMBOL:
            ;
            break;
          default:
            jj_la1[70] = jj_gen;
            break label_29;
          }
        }
        break;
      case VARIABLE_TYPE:
        VariableType();
        break;
      default:
        jj_la1[71] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		String List
**/

//<string-list> ::= <string>+ | ?VARIABLE
  final public SimpleNode StringList() throws ParseException {
 /*@bgen(jjtree) StringList */
  SFPStringList jjtn000 = new SFPStringList(this, JJTSTRINGLIST);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STRING:
        label_30:
        while (true) {
          jj_consume_token(STRING);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case STRING:
            ;
            break;
          default:
            jj_la1[72] = jj_gen;
            break label_30;
          }
        }
        break;
      case VARIABLE_TYPE:
        VariableType();
        break;
      default:
        jj_la1[73] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Lexeme List
**/

//<lexeme-list> ::= <lexeme>+ | ?VARIABLE
  final public SimpleNode LexemeList() throws ParseException {
 /*@bgen(jjtree) LexemeList */
  SFPLexemeList jjtn000 = new SFPLexemeList(this, JJTLEXEMELIST);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STRING:
      case SYMBOL:
        label_31:
        while (true) {
          Lexeme();
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case STRING:
          case SYMBOL:
            ;
            break;
          default:
            jj_la1[74] = jj_gen;
            break label_31;
          }
        }
        break;
      case VARIABLE_TYPE:
        VariableType();
        break;
      default:
        jj_la1[75] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Integer List
**/

//<integer-list> ::= <integer>+ | ?VARIABLE
  final public SimpleNode IntegerList() throws ParseException {
 /*@bgen(jjtree) IntegerList */
  SFPIntegerList jjtn000 = new SFPIntegerList(this, JJTINTEGERLIST);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTEGER:
        label_32:
        while (true) {
          jj_consume_token(INTEGER);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case INTEGER:
            ;
            break;
          default:
            jj_la1[76] = jj_gen;
            break label_32;
          }
        }
        break;
      case VARIABLE_TYPE:
        VariableType();
        break;
      default:
        jj_la1[77] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Float List
**/

//<float-list> ::= <float>+ | ?VARIABLE
  final public SimpleNode FloatList() throws ParseException {
 /*@bgen(jjtree) FloatList */
  SFPFloatList jjtn000 = new SFPFloatList(this, JJTFLOATLIST);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FLOAT:
        label_33:
        while (true) {
          jj_consume_token(FLOAT);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case FLOAT:
            ;
            break;
          default:
            jj_la1[78] = jj_gen;
            break label_33;
          }
        }
        break;
      case VARIABLE_TYPE:
        VariableType();
        break;
      default:
        jj_la1[79] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Number List
**/

//<number-list> ::= <number>+ | ?VARIABLE
  final public SimpleNode NumberList() throws ParseException {
 /*@bgen(jjtree) NumberList */
  SFPNumberList jjtn000 = new SFPNumberList(this, JJTNUMBERLIST);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTEGER:
      case FLOAT:
        label_34:
        while (true) {
          Number();
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case INTEGER:
          case FLOAT:
            ;
            break;
          default:
            jj_la1[80] = jj_gen;
            break label_34;
          }
        }
        break;
      case VARIABLE_TYPE:
        VariableType();
        break;
      default:
        jj_la1[81] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Value List
**/

//<value-list> ::= <constant>+ | ?VARIABLE
  final public SimpleNode ValueList() throws ParseException {
 /*@bgen(jjtree) ValueList */
  SFPValueList jjtn000 = new SFPValueList(this, JJTVALUELIST);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTEGER:
      case FLOAT:
      case DATETIME:
      case STRING:
      case TRUE:
      case FALSE:
      case NIL:
      case SYMBOL:
        label_35:
        while (true) {
          Constant();
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case INTEGER:
          case FLOAT:
          case DATETIME:
          case STRING:
          case TRUE:
          case FALSE:
          case NIL:
          case SYMBOL:
            ;
            break;
          default:
            jj_la1[82] = jj_gen;
            break label_35;
          }
        }
        break;
      case VARIABLE_TYPE:
        VariableType();
        break;
      default:
        jj_la1[83] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Range Attribute
**/

//<range-attribute> ::= (range <range-specification> <range-specification>)
  final public SimpleNode RangeAttribute() throws ParseException {
 /*@bgen(jjtree) RangeAttribute */
  SFPRangeAttribute jjtn000 = new SFPRangeAttribute(this, JJTRANGEATTRIBUTE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(RANGE);
      RangeSpecification();
      RangeSpecification();
     jjtree.closeNodeScope(jjtn000, true);
     jjtc000 = false;
     {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Range Specification
**/

//<range-specification> ::= <number> | ?VARIABLE
  final public SimpleNode RangeSpecification() throws ParseException {
 /*@bgen(jjtree) RangeSpecification */
  SFPRangeSpecification jjtn000 = new SFPRangeSpecification(this, JJTRANGESPECIFICATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTEGER:
      case FLOAT:
        Number();
        break;
      case VARIABLE_TYPE:
        VariableType();
        break;
      default:
        jj_la1[84] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

//<cardinality-attribute> ::= (cardinality <cardinality-specification> <cardinality-specification>)
  final public SimpleNode CardinalityAttribute() throws ParseException {
 /*@bgen(jjtree) CardinalityAttribute */
  SFPCardinalityAttribute jjtn000 = new SFPCardinalityAttribute(this, JJTCARDINALITYATTRIBUTE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(CARDINALITY);
      CardinalitySpecification();
      CardinalitySpecification();
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Cardinality Specification
**/

//<cardinality-specification> ::= <integer> | ?VARIABLE
  final public SimpleNode CardinalitySpecification() throws ParseException {
 /*@bgen(jjtree) CardinalitySpecification */
  SFPCardinalitySpecification jjtn000 = new SFPCardinalitySpecification(this, JJTCARDINALITYSPECIFICATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTEGER:
        Integer();
        break;
      case VARIABLE_TYPE:
        VariableType();
        break;
      default:
        jj_la1[85] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
*		Defmodule Construct
**/

//	<defmodule-construct> ::= (defmodule <module-name> [<comment>] )
  final public SimpleNode DefmoduleConstruct() throws ParseException {
 /*@bgen(jjtree) DefmoduleConstruct */
  SFPDefmoduleConstruct jjtn000 = new SFPDefmoduleConstruct(this, JJTDEFMODULECONSTRUCT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(DEFMODULE);
      Symbol();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STRING:
        ConstructDescription();
        break;
      default:
        jj_la1[86] = jj_gen;
        ;
      }
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  final private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  final private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  final private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  final private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  final private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  final private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  final private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  final private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_9(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  final private boolean jj_2_10(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_10(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  final private boolean jj_2_11(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_11(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  final private boolean jj_2_12(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_12(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  final private boolean jj_2_13(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_13(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  final private boolean jj_2_14(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_14(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  final private boolean jj_2_15(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_15(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(14, xla); }
  }

  final private boolean jj_2_16(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_16(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(15, xla); }
  }

  final private boolean jj_2_17(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_17(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(16, xla); }
  }

  final private boolean jj_2_18(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_18(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(17, xla); }
  }

  final private boolean jj_2_19(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_19(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(18, xla); }
  }

  final private boolean jj_3R_124() {
    if (jj_3R_144()) return true;
    return false;
  }

  final private boolean jj_3R_123() {
    if (jj_3R_143()) return true;
    return false;
  }

  final private boolean jj_3_6() {
    if (jj_3R_41()) return true;
    return false;
  }

  final private boolean jj_3R_115() {
    Token xsp;
    if (jj_3R_138()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_138()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_126() {
    if (jj_3R_146()) return true;
    return false;
  }

  final private boolean jj_3R_105() {
    if (jj_scan_token(WEEKDAY)) return true;
    return false;
  }

  final private boolean jj_3R_119() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_6()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_81() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_115()) {
    jj_scanpos = xsp;
    if (jj_3R_116()) return true;
    }
    return false;
  }

  final private boolean jj_3R_104() {
    if (jj_scan_token(YEAR)) return true;
    return false;
  }

  final private boolean jj_3R_96() {
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_123()) {
    jj_scanpos = xsp;
    if (jj_3R_124()) {
    jj_scanpos = xsp;
    if (jj_3R_125()) {
    jj_scanpos = xsp;
    if (jj_3R_126()) {
    jj_scanpos = xsp;
    if (jj_3R_127()) {
    jj_scanpos = xsp;
    if (jj_3R_128()) {
    jj_scanpos = xsp;
    if (jj_3R_129()) {
    jj_scanpos = xsp;
    if (jj_3R_130()) {
    jj_scanpos = xsp;
    if (jj_3R_131()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3_5() {
    if (jj_3R_40()) return true;
    return false;
  }

  final private boolean jj_3R_87() {
    if (jj_scan_token(DATETIME)) return true;
    return false;
  }

  final private boolean jj_3R_103() {
    if (jj_scan_token(MONTH)) return true;
    return false;
  }

  final private boolean jj_3R_50() {
    if (jj_scan_token(TYPE)) return true;
    if (jj_3R_81()) return true;
    return false;
  }

  final private boolean jj_3R_102() {
    if (jj_scan_token(DAY)) return true;
    return false;
  }

  final private boolean jj_3R_139() {
    if (jj_scan_token(VARIABLE_TYPE)) return true;
    return false;
  }

  final private boolean jj_3R_101() {
    if (jj_scan_token(HOUR)) return true;
    return false;
  }

  final private boolean jj_3R_89() {
    if (jj_scan_token(INTEGER)) return true;
    return false;
  }

  final private boolean jj_3R_122() {
    if (jj_3R_142()) return true;
    return false;
  }

  final private boolean jj_3_19() {
    if (jj_3R_50()) return true;
    return false;
  }

  final private boolean jj_3R_121() {
    if (jj_3R_49()) return true;
    return false;
  }

  final private boolean jj_3R_120() {
    if (jj_3R_48()) return true;
    return false;
  }

  final private boolean jj_3R_100() {
    if (jj_scan_token(MINUTE)) return true;
    return false;
  }

  final private boolean jj_3R_114() {
    if (jj_3R_62()) return true;
    return false;
  }

  final private boolean jj_3R_95() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_120()) {
    jj_scanpos = xsp;
    if (jj_3R_121()) {
    jj_scanpos = xsp;
    if (jj_3R_122()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_99() {
    if (jj_scan_token(SECOND)) return true;
    return false;
  }

  final private boolean jj_3R_90() {
    if (jj_scan_token(FLOAT)) return true;
    return false;
  }

  final private boolean jj_3R_77() {
    if (jj_3R_106()) return true;
    return false;
  }

  final private boolean jj_3R_98() {
    if (jj_scan_token(MILLISECOND)) return true;
    return false;
  }

  final private boolean jj_3R_76() {
    if (jj_3R_105()) return true;
    return false;
  }

  final private boolean jj_3R_72() {
    if (jj_3R_101()) return true;
    return false;
  }

  final private boolean jj_3R_75() {
    if (jj_3R_104()) return true;
    return false;
  }

  final private boolean jj_3R_71() {
    if (jj_3R_100()) return true;
    return false;
  }

  final private boolean jj_3R_47() {
    if (jj_3R_80()) return true;
    return false;
  }

  final private boolean jj_3R_49() {
    if (jj_scan_token(MULTIVAR)) return true;
    return false;
  }

  final private boolean jj_3R_74() {
    if (jj_3R_103()) return true;
    return false;
  }

  final private boolean jj_3R_70() {
    if (jj_3R_99()) return true;
    return false;
  }

  final private boolean jj_3R_73() {
    if (jj_3R_102()) return true;
    return false;
  }

  final private boolean jj_3R_80() {
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_114()) return true;
    return false;
  }

  final private boolean jj_3R_69() {
    if (jj_3R_98()) return true;
    return false;
  }

  final private boolean jj_3R_142() {
    if (jj_scan_token(GLOBALVAR)) return true;
    return false;
  }

  final private boolean jj_3R_44() {
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_69()) {
    jj_scanpos = xsp;
    if (jj_3R_70()) {
    jj_scanpos = xsp;
    if (jj_3R_71()) {
    jj_scanpos = xsp;
    if (jj_3R_72()) {
    jj_scanpos = xsp;
    if (jj_3R_73()) {
    jj_scanpos = xsp;
    if (jj_3R_74()) {
    jj_scanpos = xsp;
    if (jj_3R_75()) {
    jj_scanpos = xsp;
    if (jj_3R_76()) {
    jj_scanpos = xsp;
    if (jj_3R_77()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3_15() {
    Token xsp;
    if (jj_3R_47()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_47()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3_1() {
    if (jj_3R_36()) return true;
    return false;
  }

  final private boolean jj_3_18() {
    if (jj_3R_49()) return true;
    return false;
  }

  final private boolean jj_3_10() {
    if (jj_3R_44()) return true;
    return false;
  }

  final private boolean jj_3R_132() {
    if (jj_3R_62()) return true;
    return false;
  }

  final private boolean jj_3R_42() {
    if (jj_scan_token(TEMPORALVALIDITY)) return true;
    return false;
  }

  final private boolean jj_3R_48() {
    if (jj_scan_token(SINGLEVAR)) return true;
    return false;
  }

  final private boolean jj_3_14() {
    if (jj_3R_46()) return true;
    return false;
  }

  final private boolean jj_3R_137() {
    if (jj_scan_token(FORALL)) return true;
    return false;
  }

  final private boolean jj_3R_85() {
    if (jj_scan_token(DEFMODULE)) return true;
    return false;
  }

  final private boolean jj_3_17() {
    if (jj_3R_48()) return true;
    return false;
  }

  final private boolean jj_3R_61() {
    if (jj_3R_91()) return true;
    return false;
  }

  final private boolean jj_3R_54() {
    if (jj_3R_85()) return true;
    return false;
  }

  final private boolean jj_3R_60() {
    if (jj_3R_90()) return true;
    return false;
  }

  final private boolean jj_3R_53() {
    if (jj_3R_84()) return true;
    return false;
  }

  final private boolean jj_3R_39() {
    if (jj_scan_token(DEFTEMPLATE)) return true;
    if (jj_3R_62()) return true;
    return false;
  }

  final private boolean jj_3R_59() {
    if (jj_3R_89()) return true;
    return false;
  }

  final private boolean jj_3R_52() {
    if (jj_3R_83()) return true;
    return false;
  }

  final private boolean jj_3_13() {
    if (jj_3R_46()) return true;
    return false;
  }

  final private boolean jj_3R_58() {
    if (jj_3R_88()) return true;
    return false;
  }

  final private boolean jj_3R_51() {
    if (jj_3R_82()) return true;
    return false;
  }

  final private boolean jj_3R_56() {
    if (jj_3R_87()) return true;
    return false;
  }

  final private boolean jj_3R_55() {
    if (jj_3R_86()) return true;
    return false;
  }

  final private boolean jj_3R_97() {
    if (jj_scan_token(LBRACE)) return true;
    return false;
  }

  final private boolean jj_3R_57() {
    if (jj_3R_62()) return true;
    return false;
  }

  final private boolean jj_3_4() {
    if (jj_3R_39()) return true;
    return false;
  }

  final private boolean jj_3R_68() {
    if (jj_3R_97()) return true;
    return false;
  }

  final private boolean jj_3R_37() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_55()) {
    jj_scanpos = xsp;
    if (jj_3R_56()) {
    jj_scanpos = xsp;
    if (jj_3R_57()) {
    jj_scanpos = xsp;
    if (jj_3R_58()) {
    jj_scanpos = xsp;
    if (jj_3R_59()) {
    jj_scanpos = xsp;
    if (jj_3R_60()) {
    jj_scanpos = xsp;
    if (jj_3R_61()) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_136() {
    if (jj_scan_token(EXISTS)) return true;
    return false;
  }

  final private boolean jj_3R_36() {
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_4()) {
    jj_scanpos = xsp;
    if (jj_3R_51()) {
    jj_scanpos = xsp;
    if (jj_3R_52()) {
    jj_scanpos = xsp;
    if (jj_3R_53()) {
    jj_scanpos = xsp;
    if (jj_3R_54()) return true;
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_43() {
    if (jj_scan_token(LBRACE)) return true;
    if (jj_scan_token(DECLARE)) return true;
    Token xsp;
    if (jj_3R_68()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_68()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_135() {
    if (jj_scan_token(TEST)) return true;
    return false;
  }

  final private boolean jj_3_9() {
    if (jj_3R_41()) return true;
    return false;
  }

  final private boolean jj_3_8() {
    if (jj_3R_43()) return true;
    return false;
  }

  final private boolean jj_3R_141() {
    if (jj_scan_token(FALSE)) return true;
    return false;
  }

  final private boolean jj_3_12() {
    if (jj_3R_46()) return true;
    return false;
  }

  final private boolean jj_3R_38() {
    if (jj_scan_token(LBRACE)) return true;
    if (jj_scan_token(CASE)) return true;
    return false;
  }

  final private boolean jj_3R_134() {
    if (jj_scan_token(LOGICAL)) return true;
    return false;
  }

  final private boolean jj_3R_177() {
    if (jj_scan_token(NUMBER_TYPE)) return true;
    return false;
  }

  final private boolean jj_3_3() {
    if (jj_3R_38()) return true;
    return false;
  }

  final private boolean jj_3R_83() {
    if (jj_scan_token(DEFRULE)) return true;
    return false;
  }

  final private boolean jj_3R_84() {
    if (jj_scan_token(DEFFUNCTION)) return true;
    return false;
  }

  final private boolean jj_3R_176() {
    if (jj_scan_token(DOUBLE_TYPE)) return true;
    return false;
  }

  final private boolean jj_3R_113() {
    if (jj_3R_48()) return true;
    if (jj_scan_token(ASSIGN)) return true;
    return false;
  }

  final private boolean jj_3R_151() {
    if (jj_scan_token(SWITCH)) return true;
    return false;
  }

  final private boolean jj_3R_175() {
    if (jj_scan_token(FLOAT_TYPE)) return true;
    return false;
  }

  final private boolean jj_3R_156() {
    if (jj_scan_token(OR)) return true;
    return false;
  }

  final private boolean jj_3R_174() {
    if (jj_scan_token(SHORT_TYPE)) return true;
    return false;
  }

  final private boolean jj_3R_149() {
    if (jj_scan_token(LOOP_FOR_COUNT)) return true;
    return false;
  }

  final private boolean jj_3R_155() {
    if (jj_scan_token(AND)) return true;
    return false;
  }

  final private boolean jj_3R_173() {
    if (jj_scan_token(LONG_TYPE)) return true;
    return false;
  }

  final private boolean jj_3R_82() {
    if (jj_scan_token(DEFGLOBAL)) return true;
    return false;
  }

  final private boolean jj_3R_112() {
    if (jj_3R_137()) return true;
    return false;
  }

  final private boolean jj_3R_111() {
    if (jj_3R_136()) return true;
    return false;
  }

  final private boolean jj_3R_110() {
    if (jj_3R_135()) return true;
    return false;
  }

  final private boolean jj_3R_109() {
    if (jj_3R_134()) return true;
    return false;
  }

  final private boolean jj_3R_108() {
    if (jj_3R_133()) return true;
    return false;
  }

  final private boolean jj_3R_107() {
    if (jj_3R_132()) return true;
    return false;
  }

  final private boolean jj_3R_45() {
    if (jj_scan_token(NOT)) return true;
    if (jj_3R_46()) return true;
    return false;
  }

  final private boolean jj_3R_172() {
    if (jj_scan_token(INTEGER_TYPE)) return true;
    return false;
  }

  final private boolean jj_3R_148() {
    if (jj_scan_token(WHILE)) return true;
    return false;
  }

  final private boolean jj_3R_153() {
    if (jj_3R_156()) return true;
    return false;
  }

  final private boolean jj_3_7() {
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_42()) return true;
    return false;
  }

  final private boolean jj_3R_152() {
    if (jj_3R_155()) return true;
    return false;
  }

  final private boolean jj_3R_79() {
    if (jj_3R_113()) return true;
    return false;
  }

  final private boolean jj_3_11() {
    if (jj_3R_45()) return true;
    return false;
  }

  final private boolean jj_3R_178() {
    if (jj_scan_token(BOOLEAN_TYPE)) return true;
    return false;
  }

  final private boolean jj_3R_133() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_11()) {
    jj_scanpos = xsp;
    if (jj_3R_152()) {
    jj_scanpos = xsp;
    if (jj_3R_153()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_147() {
    if (jj_scan_token(IF)) return true;
    return false;
  }

  final private boolean jj_3R_171() {
    if (jj_scan_token(LEXEME_TYPE)) return true;
    return false;
  }

  final private boolean jj_3R_78() {
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_107()) {
    jj_scanpos = xsp;
    if (jj_3R_108()) {
    jj_scanpos = xsp;
    if (jj_3R_109()) {
    jj_scanpos = xsp;
    if (jj_3R_110()) {
    jj_scanpos = xsp;
    if (jj_3R_111()) {
    jj_scanpos = xsp;
    if (jj_3R_112()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_46() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_78()) {
    jj_scanpos = xsp;
    if (jj_3R_79()) return true;
    }
    return false;
  }

  final private boolean jj_3R_170() {
    if (jj_scan_token(DATETIME_TYPE)) return true;
    return false;
  }

  final private boolean jj_3R_145() {
    if (jj_scan_token(RETRACT)) return true;
    return false;
  }

  final private boolean jj_3_16() {
    if (jj_3R_37()) return true;
    return false;
  }

  final private boolean jj_3R_169() {
    if (jj_scan_token(STRING_TYPE)) return true;
    return false;
  }

  final private boolean jj_3R_118() {
    if (jj_3R_141()) return true;
    return false;
  }

  final private boolean jj_3R_117() {
    if (jj_3R_140()) return true;
    return false;
  }

  final private boolean jj_3R_146() {
    if (jj_scan_token(FIND_FACT_BY_FACT)) return true;
    return false;
  }

  final private boolean jj_3R_91() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_117()) {
    jj_scanpos = xsp;
    if (jj_3R_118()) return true;
    }
    return false;
  }

  final private boolean jj_3R_168() {
    if (jj_scan_token(SYMBOL_TYPE)) return true;
    return false;
  }

  final private boolean jj_3R_144() {
    if (jj_scan_token(MODIFY)) return true;
    return false;
  }

  final private boolean jj_3R_86() {
    if (jj_scan_token(NIL)) return true;
    return false;
  }

  final private boolean jj_3R_93() {
    if (jj_scan_token(ATR_NONE)) return true;
    return false;
  }

  final private boolean jj_3R_143() {
    if (jj_scan_token(ASSERT)) return true;
    return false;
  }

  final private boolean jj_3R_140() {
    if (jj_scan_token(TRUE)) return true;
    return false;
  }

  final private boolean jj_3R_167() {
    if (jj_3R_178()) return true;
    return false;
  }

  final private boolean jj_3R_166() {
    if (jj_3R_177()) return true;
    return false;
  }

  final private boolean jj_3R_165() {
    if (jj_3R_176()) return true;
    return false;
  }

  final private boolean jj_3R_67() {
    if (jj_3R_96()) return true;
    return false;
  }

  final private boolean jj_3R_164() {
    if (jj_3R_175()) return true;
    return false;
  }

  final private boolean jj_3R_66() {
    if (jj_3R_95()) return true;
    return false;
  }

  final private boolean jj_3R_163() {
    if (jj_3R_174()) return true;
    return false;
  }

  final private boolean jj_3R_92() {
    if (jj_scan_token(ATR_DERIVE)) return true;
    return false;
  }

  final private boolean jj_3R_162() {
    if (jj_3R_173()) return true;
    return false;
  }

  final private boolean jj_3_2() {
    if (jj_3R_37()) return true;
    return false;
  }

  final private boolean jj_3R_161() {
    if (jj_3R_172()) return true;
    return false;
  }

  final private boolean jj_3R_160() {
    if (jj_3R_171()) return true;
    return false;
  }

  final private boolean jj_3R_159() {
    if (jj_3R_170()) return true;
    return false;
  }

  final private boolean jj_3R_158() {
    if (jj_3R_169()) return true;
    return false;
  }

  final private boolean jj_3R_65() {
    if (jj_3R_94()) return true;
    return false;
  }

  final private boolean jj_3R_157() {
    if (jj_3R_168()) return true;
    return false;
  }

  final private boolean jj_3R_88() {
    if (jj_scan_token(STRING)) return true;
    return false;
  }

  final private boolean jj_3R_64() {
    if (jj_3R_93()) return true;
    return false;
  }

  final private boolean jj_3R_63() {
    if (jj_3R_92()) return true;
    return false;
  }

  final private boolean jj_3R_41() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_2()) {
    jj_scanpos = xsp;
    if (jj_3R_66()) {
    jj_scanpos = xsp;
    if (jj_3R_67()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_40() {
    if (jj_scan_token(DEFAULT_ATR)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_63()) {
    jj_scanpos = xsp;
    if (jj_3R_64()) {
    jj_scanpos = xsp;
    if (jj_3R_65()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_94() {
    if (jj_3R_119()) return true;
    return false;
  }

  final private boolean jj_3R_154() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_157()) {
    jj_scanpos = xsp;
    if (jj_3R_158()) {
    jj_scanpos = xsp;
    if (jj_3R_159()) {
    jj_scanpos = xsp;
    if (jj_3R_160()) {
    jj_scanpos = xsp;
    if (jj_3R_161()) {
    jj_scanpos = xsp;
    if (jj_3R_162()) {
    jj_scanpos = xsp;
    if (jj_3R_163()) {
    jj_scanpos = xsp;
    if (jj_3R_164()) {
    jj_scanpos = xsp;
    if (jj_3R_165()) {
    jj_scanpos = xsp;
    if (jj_3R_166()) {
    jj_scanpos = xsp;
    if (jj_3R_167()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_62() {
    if (jj_scan_token(SYMBOL)) return true;
    return false;
  }

  final private boolean jj_3R_116() {
    if (jj_3R_139()) return true;
    return false;
  }

  final private boolean jj_3R_138() {
    if (jj_3R_154()) return true;
    return false;
  }

  final private boolean jj_3R_131() {
    if (jj_3R_151()) return true;
    return false;
  }

  final private boolean jj_3R_130() {
    if (jj_3R_150()) return true;
    return false;
  }

  final private boolean jj_3R_129() {
    if (jj_3R_149()) return true;
    return false;
  }

  final private boolean jj_3R_150() {
    if (jj_3R_62()) return true;
    return false;
  }

  final private boolean jj_3R_128() {
    if (jj_3R_148()) return true;
    return false;
  }

  final private boolean jj_3R_127() {
    if (jj_3R_147()) return true;
    return false;
  }

  final private boolean jj_3R_106() {
    if (jj_scan_token(DURATION)) return true;
    return false;
  }

  final private boolean jj_3R_125() {
    if (jj_3R_145()) return true;
    return false;
  }

  public SFPParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  public Token token, jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  public boolean lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[87];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static {
      jj_la1_0();
      jj_la1_1();
      jj_la1_2();
      jj_la1_3();
   }
   private static void jj_la1_0() {
      jj_la1_0 = new int[] {0x128640,0x128641,0x600,0x20000,0x28600,0x100000,0x0,0x128640,0x100040,0x40,0x128640,0x0,0x0,0x128640,0x0,0x40,0x33000000,0x20000,0x40,0x10000,0x0,0x40,0x40,0x80000000,0x0,0x40,0x128640,0x128640,0x128640,0x20000,0x40,0x40,0x0,0x0,0x0,0x0,0x40,0x0,0x40,0x40,0x40,0xe8600,0xe8600,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100000,0x20000,0x4000000,0x0,0x0,0x20000,0x0,0x100040,0x40,0x0,0x100040,0x40,0x100040,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x20000,0x20000,0x20000,0x200,0x200,0x400,0x400,0x600,0x600,0x28600,0x28600,0x600,0x200,0x20000,};
   }
   private static void jj_la1_1() {
      jj_la1_1 = new int[] {0x7000000,0x7000000,0x0,0x0,0x7000000,0x0,0x0,0x7000000,0x0,0x0,0x7000000,0x0,0x0,0x7000000,0x0,0x0,0x0,0x0,0x0,0x0,0x50,0x0,0x0,0x800000,0x6,0x0,0x7000000,0x7000000,0x7000000,0x0,0x0,0x0,0x600d00,0x1ff000,0x3000000,0xb8000000,0x0,0x30000000,0x0,0x0,0x0,0x7000000,0x7000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7000000,0x7000000,0x0,0x0,0x0,};
   }
   private static void jj_la1_2() {
      jj_la1_2 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xff000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7,0x0,0x0,0x0,0x0,0x0,0x320,0x320,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0x20,0x300,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3ff800,0x0,0x0,0x3ff800,0x0,0x0,0x0,0xff000000,0x3ff800,0x3ffc00,0x3ff800,0xff000000,0x0,0x400,0x0,0x400,0x0,0x400,0x0,0x400,0x0,0x400,0x0,0x400,0x0,0x400,0x400,0x400,0x0,};
   }
   private static void jj_la1_3() {
      jj_la1_3 = new int[] {0x700000,0x700000,0x0,0x400000,0x400000,0x300000,0x4349e0,0x700000,0x300000,0x0,0x700000,0x2000,0x8000,0x700000,0x8000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf,0x0,0x0,0x700000,0x700000,0x700000,0x0,0x100000,0x0,0x0,0x0,0x0,0x400000,0x100000,0x0,0x100000,0x100000,0x0,0x700000,0x700000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x300000,0x400000,0x0,0x0,0x0,0x100000,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf,0x0,0x0,0x0,0x3,0x400000,0x400000,0x0,0x0,0x400000,0x400000,0x0,0x0,0x0,0x0,0x0,0x0,0x400000,0x400000,0x0,0x0,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[19];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  public SFPParser(java.io.InputStream stream) {
     this(stream, null);
  }
  public SFPParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new SFPParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 87; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 87; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public SFPParser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new SFPParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 87; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 87; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public SFPParser(SFPParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 87; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(SFPParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 87; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  final private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      boolean exists = false;
      for (java.util.Enumeration e = jj_expentries.elements(); e.hasMoreElements();) {
        int[] oldentry = (int[])(e.nextElement());
        if (oldentry.length == jj_expentry.length) {
          exists = true;
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              exists = false;
              break;
            }
          }
          if (exists) break;
        }
      }
      if (!exists) jj_expentries.addElement(jj_expentry);
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[119];
    for (int i = 0; i < 119; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 87; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 119; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

  final private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 19; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
            case 9: jj_3_10(); break;
            case 10: jj_3_11(); break;
            case 11: jj_3_12(); break;
            case 12: jj_3_13(); break;
            case 13: jj_3_14(); break;
            case 14: jj_3_15(); break;
            case 15: jj_3_16(); break;
            case 16: jj_3_17(); break;
            case 17: jj_3_18(); break;
            case 18: jj_3_19(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  final private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
