/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.settings;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.jamocha.Constants;
import org.jamocha.settings.SettingsChangedListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JamochaSettings {
    private static JamochaSettings singleton = null;
    private final Preferences preferences;
    private final Properties defaults;
    private Map<String, JamochaSetting> settings;
    private Map<String, String> friendlyName2Name;
    private Map<String, List<SettingsChangedListener>> name2SettingsChangedListener = new HashMap<String, List<SettingsChangedListener>>();

    private JamochaSettings() {
        this.preferences = Preferences.userRoot().node("org/jamocha");
        this.defaults = new Properties();
        String defaultPropName = "default.properties";
        try {
            defaultPropName = this.getClass().getPackage().getName().replace('.', '/') + "/" + defaultPropName;
        }
        catch (Exception any) {
            // empty catch block
        }
        InputStream propertyStream = this.getClass().getClassLoader().getResourceAsStream(defaultPropName);
        if (propertyStream != null) {
            try {
                this.defaults.load(propertyStream);
            }
            catch (IOException ioe) {
                System.err.println("Error reading default properties:" + defaultPropName);
                System.exit(-1);
            }
        }
        this.readSettings();
    }

    public static JamochaSettings getInstance() {
        if (singleton == null) {
            singleton = new JamochaSettings();
        }
        return singleton;
    }

    public Object get(String key) {
        JamochaSetting prop = this.settings.get(key);
        if (prop != null) {
            return prop.currentValue;
        }
        return null;
    }

    public Object getDefault(String key) {
        return this.settings.get((Object)key).defaultValue;
    }

    public String getString(String key) {
        return (String)this.get(key);
    }

    public boolean getBoolean(String key) {
        return (Boolean)this.get(key);
    }

    public double getDouble(String key) {
        return (Double)this.get(key);
    }

    public float getFloat(String key) {
        return ((Float)this.get(key)).floatValue();
    }

    public int getInt(String key) {
        return (Integer)this.get(key);
    }

    public long getLong(String key) {
        return (Long)this.get(key);
    }

    public String getFriendlyName(String key) {
        JamochaSetting setting = this.settings.get(key);
        return setting != null ? setting.friendlyName : null;
    }

    public Set<String> getSettings() {
        return this.settings.keySet();
    }

    public boolean set(String key, String value) {
        String name;
        JamochaSetting setting = this.settings.get(key);
        if (setting == null && (name = this.friendlyName2Name.get(key)) != null) {
            setting = this.settings.get(name);
            key = name;
        }
        if (setting != null) {
            setting.setCurrentValue(value);
            this.preferences.put(key, value);
            this.informListeners(key);
            return true;
        }
        return false;
    }

    public boolean set(String key, int value) {
        return this.set(key, "" + value);
    }

    public boolean set(String key, boolean value) {
        return this.set(key, "" + value);
    }

    public boolean toDefault(String key) {
        String name;
        JamochaSetting setting = this.settings.get(key);
        if (setting == null && (name = this.friendlyName2Name.get(key)) != null) {
            setting = this.settings.get(name);
            key = name;
        }
        if (setting != null) {
            setting.toDefault();
            this.preferences.put(key, setting.currentValue.toString());
            this.informListeners(key);
            return true;
        }
        return false;
    }

    private void readSettings() {
        this.settings = new HashMap<String, JamochaSetting>();
        this.friendlyName2Name = new HashMap<String, String>();
        Set<Object> keys = this.defaults.keySet();
        for (Object key : keys) {
            String[] splits = this.defaults.getProperty(key.toString()).split(":");
            String type = splits[0];
            String defaultValue = splits[1];
            String friendlyName = splits.length > 2 ? splits[2] : "";
            String currentValue = this.preferences.get(key.toString(), defaultValue);
            this.addProperty(key.toString(), friendlyName, defaultValue, currentValue, type);
        }
    }

    public String getSettingsTable() {
        JamochaSetting sett;
        StringBuilder res = new StringBuilder();
        int firstColWidth = 0;
        int secondColWidth = 0;
        int thirdColWidth = 0;
        int forthColWidth = 0;
        Collection<String> keys = this.friendlyName2Name.values();
        for (String key : keys) {
            sett = this.settings.get(key);
            firstColWidth = Math.max(firstColWidth, sett.friendlyName.length());
            secondColWidth = Math.max(secondColWidth, sett.getTypeString().length());
            thirdColWidth = Math.max(thirdColWidth, sett.defaultValue.toString().length());
            forthColWidth = Math.max(forthColWidth, sett.currentValue.toString().length());
        }
        firstColWidth = Math.max(firstColWidth, "Name:".length());
        secondColWidth = Math.max(secondColWidth, "Type:".length());
        thirdColWidth = Math.max(thirdColWidth, "Default value:".length());
        forthColWidth = Math.max(forthColWidth, "Current value:".length());
        res.append("| Name:");
        this.appendCharChain(res, ' ', firstColWidth - 5);
        res.append(" | Type:");
        this.appendCharChain(res, ' ', secondColWidth - 5);
        res.append(" | Default value:");
        this.appendCharChain(res, ' ', thirdColWidth - 14);
        res.append(" | Current value:");
        this.appendCharChain(res, ' ', forthColWidth - 14);
        res.append(" |").append(Constants.LINEBREAK);
        this.appendCharChain(res, '=', res.length() - 1);
        res.append(Constants.LINEBREAK);
        ArrayList<String> keyList = new ArrayList<String>(keys);
        Collections.sort(keyList);
        for (String key : keyList) {
            sett = this.settings.get(key);
            res.append("| ").append(sett.friendlyName);
            this.appendCharChain(res, ' ', firstColWidth - sett.friendlyName.length());
            String type = sett.getTypeString();
            res.append(" | ").append(type);
            this.appendCharChain(res, ' ', secondColWidth - type.length());
            res.append(" | ").append(sett.defaultValue);
            this.appendCharChain(res, ' ', thirdColWidth - sett.defaultValue.toString().length());
            res.append(" | ").append(sett.currentValue);
            this.appendCharChain(res, ' ', forthColWidth - sett.currentValue.toString().length());
            res.append(" |").append(Constants.LINEBREAK);
        }
        return res.toString();
    }

    public void addListener(SettingsChangedListener listener, String[] settingNames) {
        for (String settingName : settingNames) {
            List<SettingsChangedListener> listeners = this.name2SettingsChangedListener.get(settingName);
            if (listeners == null) {
                listeners = new ArrayList<SettingsChangedListener>();
                this.name2SettingsChangedListener.put(settingName, listeners);
            }
            listeners.add(listener);
            if (this.get(settingName) == null) continue;
            listener.settingsChanged(settingName);
        }
    }

    public void removeListener(SettingsChangedListener listener) {
        assert (false);
    }

    protected void informListeners(String propertyName) {
        List<SettingsChangedListener> listeners = this.name2SettingsChangedListener.get(propertyName);
        if (listeners != null) {
            for (SettingsChangedListener l : listeners) {
                l.settingsChanged(propertyName);
            }
        }
    }

    private void addProperty(String name, String friendlyName, String defaultValue, String currentValue, String type) {
        this.settings.put(name, new JamochaSetting(name, friendlyName, defaultValue, currentValue, type));
        if (!friendlyName.equals("") && friendlyName != null) {
            this.friendlyName2Name.put(friendlyName, name);
        }
    }

    protected void finalize() {
        try {
            this.preferences.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    protected void appendCharChain(StringBuilder sb, char c, int length) {
        for (int i = 0; i < length; ++i) {
            sb.append(c);
        }
    }

    private class JamochaSetting {
        static final int TYPE_INT = 0;
        static final int TYPE_LONG = 1;
        static final int TYPE_DOUBLE = 2;
        static final int TYPE_FLOAT = 3;
        static final int TYPE_STRING = 4;
        static final int TYPE_BOOLEAN = 5;
        private int type;
        String name;
        String friendlyName;
        Object defaultValue;
        Object currentValue;

        public JamochaSetting(String name, String friendlyName, String defaultValue, String currentValue, String type) {
            this.type = this.getType(type);
            this.name = name;
            this.friendlyName = friendlyName;
            this.defaultValue = this.getValue(defaultValue);
            this.currentValue = this.getValue(currentValue);
        }

        public void toDefault() {
            this.currentValue = this.defaultValue;
        }

        public String getTypeString() {
            switch (this.type) {
                case 0: {
                    return "Integer";
                }
                case 1: {
                    return "Long";
                }
                case 2: {
                    return "Double";
                }
                case 3: {
                    return "Float";
                }
                case 4: {
                    return "String";
                }
                case 5: {
                    return "Boolean";
                }
            }
            return "Unknown";
        }

        private int getType(String typeString) {
            if (typeString.equals("int")) {
                return 0;
            }
            if (typeString.equals("long")) {
                return 1;
            }
            if (typeString.equals("double")) {
                return 2;
            }
            if (typeString.equals("float")) {
                return 3;
            }
            if (typeString.equals("string")) {
                return 4;
            }
            if (typeString.equals("boolean")) {
                return 5;
            }
            return -1;
        }

        private Object getValue(String value) {
            switch (this.type) {
                case 0: {
                    return Integer.parseInt(value);
                }
                case 1: {
                    return Long.parseLong(value);
                }
                case 2: {
                    return Double.parseDouble(value);
                }
                case 3: {
                    return Float.valueOf(Float.parseFloat(value));
                }
                case 4: {
                    return value;
                }
                case 5: {
                    return Boolean.parseBoolean(value);
                }
            }
            return null;
        }

        public void resetValue() {
            this.currentValue = this.defaultValue;
        }

        public Object setCurrentValue(String newValue) {
            this.currentValue = this.getValue(newValue);
            return this.currentValue;
        }
    }
}

