/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rules;

import java.util.ArrayList;
import java.util.List;
import org.jamocha.engine.BoundParam;
import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.configurations.Signature;
import org.jamocha.formatter.Formatter;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.JamochaValue;
import org.jamocha.rules.AbstractCondition;
import org.jamocha.rules.BoundConstraint;
import org.jamocha.rules.Condition;
import org.jamocha.rules.ConditionVisitor;
import org.jamocha.rules.Constraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestCondition
extends AbstractCondition {
    private static final long serialVersionUID = 1L;
    protected Signature func = null;

    protected TestCondition() {
    }

    public TestCondition(Signature function) {
        this.func = function;
    }

    public Signature getFunction() {
        return this.func;
    }

    protected boolean executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        this.func.setParameters(params);
        JamochaValue rv = this.func.getValue(engine);
        return rv.getBooleanValue();
    }

    @Override
    public String format(Formatter visitor) {
        return visitor.visit(this);
    }

    @Override
    public Condition clone() {
        TestCondition result = new TestCondition();
        result.func = (Signature)this.func.clone();
        return result;
    }

    @Override
    public List<Constraint> getConstraints() {
        ArrayList<Constraint> result = new ArrayList<Constraint>();
        this.evaluateConstraints(this.func.getParameters(), result);
        return result;
    }

    private void evaluateConstraints(Parameter[] parameters, List<Constraint> result) {
        for (Parameter p : parameters) {
            if (p instanceof BoundParam) {
                BoundParam bp = (BoundParam)p;
                BoundConstraint bc = new BoundConstraint(null, bp.getVariableName(), false);
                result.add(bc);
                continue;
            }
            if (!(p instanceof Signature)) continue;
            Signature s = (Signature)p;
            this.evaluateConstraints(s.getParameters(), result);
        }
    }

    @Override
    public int getComplexity() {
        return 10000;
    }

    @Override
    public List<Constraint> getFlatConstraints() {
        return this.getConstraints();
    }

    @Override
    public boolean testEquals(Condition o) {
        return false;
    }

    @Override
    public <T, S> S acceptVisitor(ConditionVisitor<T, S> visitor, T data) {
        return visitor.visit(this, data);
    }

    @Override
    public String dump(String prefix) {
        return prefix + "test";
    }
}

