/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.parser;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import org.jamocha.engine.BoundParam;
import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.workingmemory.elements.Fact;
import org.jamocha.engine.workingmemory.elements.Slot;
import org.jamocha.formatter.Formattable;
import org.jamocha.formatter.Formatter;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.IllegalConversionException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.ParserFactory;
import org.jamocha.parser.ParserUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JamochaValue
implements Parameter,
Formattable {
    public static final JamochaValue NIL = new JamochaValue(JamochaType.NIL, null);
    public static final JamochaValue TRUE = new JamochaValue(JamochaType.BOOLEAN, true);
    public static final JamochaValue FALSE = new JamochaValue(JamochaType.BOOLEAN, false);
    public static final JamochaValue EMPTY_LIST = new JamochaValue(JamochaType.LIST, new JamochaValue[0]);
    private JamochaType type;
    private Object value;

    @Override
    public Object clone() {
        return this;
    }

    public static JamochaValue singletonList(JamochaValue value) {
        if (value == null || value.equals(NIL)) {
            return EMPTY_LIST;
        }
        return new JamochaValue(JamochaType.LIST, new JamochaValue[]{value});
    }

    public static JamochaValue newBoolean(boolean value) {
        return value ? TRUE : FALSE;
    }

    public static JamochaValue newDate(GregorianCalendar value) {
        return new JamochaValue(JamochaType.DATETIME, value);
    }

    public static JamochaValue newLong(long value) {
        return new JamochaValue(JamochaType.LONG, value);
    }

    public static JamochaValue newDouble(double value) {
        return new JamochaValue(JamochaType.DOUBLE, value);
    }

    public static JamochaValue newString(String value) {
        return new JamochaValue(JamochaType.STRING, value);
    }

    public static JamochaValue newObject(Object value) {
        return new JamochaValue(JamochaType.OBJECT, value);
    }

    public static JamochaValue newIdentifier(String value) {
        return new JamochaValue(JamochaType.IDENTIFIER, value);
    }

    public static JamochaValue newFact(Fact value) {
        return new JamochaValue(JamochaType.FACT, value);
    }

    public static JamochaValue newFactId(long value) {
        return new JamochaValue(JamochaType.FACT_ID, value);
    }

    public static JamochaValue newList(JamochaValue[] values) {
        return new JamochaValue(JamochaType.LIST, values);
    }

    public static JamochaValue newList(List<JamochaValue> list) {
        return new JamochaValue(JamochaType.LIST, list.toArray());
    }

    public static JamochaValue newList() {
        return new JamochaValue(JamochaType.LIST, new JamochaValue[0]);
    }

    public static JamochaValue newBinding(BoundParam value) {
        return new JamochaValue(JamochaType.BINDING, value);
    }

    public static JamochaValue newSlot(Slot value) {
        return new JamochaValue(JamochaType.SLOT, value);
    }

    public static JamochaValue newValueAutoType(Object value) {
        return new JamochaValue(value);
    }

    protected JamochaValue(JamochaType type, Object value) {
        if (type == null) {
            throw new IllegalArgumentException("type of a value can't be null.");
        }
        if (!JamochaType.NIL.equals((Object)type) && value == null) {
            throw new IllegalArgumentException("the value for type " + (Object)((Object)type) + " can't be null.");
        }
        this.type = type;
        switch (type) {
            case BOOLEAN: {
                if (value instanceof Boolean) {
                    this.value = value;
                    break;
                }
                this.value = Boolean.TRUE;
                break;
            }
            case DOUBLE: 
            case LONG: {
                if (value instanceof Number) {
                    this.value = value;
                    break;
                }
                throw new IllegalArgumentException("the value for type " + (Object)((Object)type) + " must be of type java.lang.Number.");
            }
            case DATETIME: {
                if (value instanceof GregorianCalendar) {
                    this.value = value;
                    break;
                }
                throw new IllegalArgumentException("the value for type " + (Object)((Object)type) + " must be of type java.util.GregorianCalendar.");
            }
            case STRING: {
                if (value instanceof String) {
                    this.value = value;
                    break;
                }
                throw new IllegalArgumentException("the value for type " + (Object)((Object)type) + " must be of type java.lang.String.");
            }
            case FACT: {
                if (value instanceof Fact) {
                    this.value = value;
                    break;
                }
                throw new IllegalArgumentException("the value for type " + (Object)((Object)type) + " must be of type org.jamocha.rete.Fact.");
            }
            case FACT_ID: {
                if (value instanceof Long) {
                    this.value = value;
                    break;
                }
                throw new IllegalArgumentException("the value for type " + (Object)((Object)type) + " must be of type java.lang.Long.");
            }
            case LIST: {
                if (value instanceof JamochaValue[]) {
                    this.value = value;
                    break;
                }
                throw new IllegalArgumentException("the value for type " + (Object)((Object)type) + " must be of type org.jamocha.parser.JamochaValue[].");
            }
            case NIL: 
            case OBJECT: {
                this.value = value;
            }
        }
        this.type = type;
        this.value = value;
    }

    protected JamochaValue(Object object) {
        if (object == null) {
            this.type = JamochaType.NIL;
        } else if (object instanceof Long || object instanceof Integer || object instanceof Short || object instanceof Byte) {
            this.value = ((Number)object).longValue();
            this.type = JamochaType.LONG;
        } else if (object instanceof Double || object instanceof Float) {
            this.value = ((Number)object).doubleValue();
            this.type = JamochaType.DOUBLE;
        } else if (object instanceof String) {
            this.value = object;
            this.type = JamochaType.STRING;
        } else if (object instanceof GregorianCalendar) {
            this.value = object;
            this.type = JamochaType.DATETIME;
        } else if (object instanceof Boolean) {
            this.value = object;
            this.type = JamochaType.BOOLEAN;
        } else if (object instanceof Collection) {
            Collection collection = (Collection)object;
            JamochaValue[] array = new JamochaValue[collection.size()];
            Iterator it = collection.iterator();
            for (int i = 0; i < collection.size() && it.hasNext(); ++i) {
                array[i] = new JamochaValue(it.next());
            }
        } else if (object instanceof Fact) {
            this.value = object;
            this.type = JamochaType.FACT;
        } else {
            this.value = object;
            this.type = JamochaType.OBJECT;
        }
    }

    public JamochaType getType() {
        return this.type;
    }

    public Object getObjectValue() {
        return this.value;
    }

    public Slot getSlotValue() {
        return (Slot)this.value;
    }

    public boolean getBooleanValue() {
        return (Boolean)this.value;
    }

    public double getDoubleValue() {
        return ((Number)this.value).doubleValue();
    }

    public long getLongValue() {
        if (this.type == JamochaType.DATETIME) {
            return this.getDateValue().getTimeInMillis();
        }
        if (this.type == JamochaType.STRING) {
            return Long.parseLong(this.value.toString());
        }
        return ((Number)this.value).longValue();
    }

    public String getStringValue() {
        return (String)this.value;
    }

    public GregorianCalendar getDateValue() {
        return (GregorianCalendar)this.value;
    }

    public String getIdentifierValue() {
        return (String)this.value;
    }

    @Deprecated
    public Fact getFactValue() {
        if (this.type.equals((Object)JamochaType.FACT)) {
            return (Fact)this.value;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Fact getFactValue(Engine e) {
        Engine.ModifySynchronizer modifySynchronizer = e.getModifySynchronizer();
        synchronized (modifySynchronizer) {
            if (this.type.equals((Object)JamochaType.FACT)) {
                return (Fact)this.value;
            }
            if (this.type.equals((Object)JamochaType.FACT_ID) || this.type.equals((Object)JamochaType.LONG)) {
                return e.getFactById((Long)this.value);
            }
            if (this.value instanceof Fact) {
                return (Fact)this.value;
            }
            return null;
        }
    }

    public long getFactIdValue() {
        return ((Number)this.value).longValue();
    }

    public JamochaValue getListValue(int index) {
        return ((JamochaValue[])this.value)[index];
    }

    public int getListCount() {
        return ((JamochaValue[])this.value).length;
    }

    public String toString() {
        if (this.type.equals((Object)JamochaType.STRING)) {
            return ParserUtils.getStringLiteral(ParserFactory.getFormatter().visit(this));
        }
        return this.format(ParserFactory.getFormatter());
    }

    public JamochaValue implicitCast(JamochaType type) throws IllegalConversionException {
        if (type.equals((Object)JamochaType.UNDEFINED) || type.equals((Object)this.type)) {
            return this;
        }
        if (type.equals((Object)JamochaType.LIST)) {
            return JamochaValue.singletonList(this);
        }
        if (type.equals((Object)JamochaType.STRING)) {
            if (this.value != null) {
                return JamochaValue.newString(this.value.toString());
            }
            return JamochaValue.newString("");
        }
        switch (this.type) {
            case BOOLEAN: {
                switch (type) {
                    case BOOLEAN: {
                        return this;
                    }
                    case DOUBLE: {
                        return JamochaValue.newDouble((Boolean)this.value != false ? 1.0 : 0.0);
                    }
                    case LONG: {
                        return JamochaValue.newLong((Boolean)this.value != false ? 1L : 0L);
                    }
                }
            }
            case DATETIME: {
                switch (type) {
                    case LONG: {
                        return JamochaValue.newLong(((Calendar)this.value).getTimeInMillis() / 1000L);
                    }
                    case DOUBLE: {
                        return JamochaValue.newDouble(((Number)(((Calendar)this.value).getTimeInMillis() / 1000L)).doubleValue());
                    }
                    case DATETIME: {
                        return this;
                    }
                }
            }
            case DOUBLE: {
                switch (type) {
                    case BOOLEAN: {
                        return JamochaValue.newBoolean(((Number)this.value).doubleValue() != 0.0);
                    }
                    case DOUBLE: {
                        return this;
                    }
                    case LONG: {
                        return JamochaValue.newLong(((Number)this.value).longValue());
                    }
                }
            }
            case LONG: {
                switch (type) {
                    case BOOLEAN: {
                        return JamochaValue.newBoolean(((Number)this.value).longValue() != 0L);
                    }
                    case DOUBLE: {
                        return JamochaValue.newDouble(((Number)this.value).doubleValue());
                    }
                    case LONG: {
                        return this;
                    }
                    case FACT_ID: {
                        return JamochaValue.newFactId((Long)this.value);
                    }
                    case DATETIME: {
                        GregorianCalendar foo = new GregorianCalendar();
                        foo.setTimeZone(TimeZone.getTimeZone("UTC"));
                        foo.setTimeInMillis((Long)this.value);
                        return JamochaValue.newDate(foo);
                    }
                }
                break;
            }
            case FACT_ID: {
                switch (type) {
                    case BOOLEAN: {
                        return JamochaValue.newBoolean(((Number)this.value).longValue() != 0L);
                    }
                    case DOUBLE: {
                        return JamochaValue.newDouble(((Number)this.value).doubleValue());
                    }
                    case LONG: {
                        return JamochaValue.newLong((Long)this.value);
                    }
                    case FACT_ID: {
                        return this;
                    }
                }
                break;
            }
            case FACT: {
                switch (type) {
                    case FACT_ID: {
                        return JamochaValue.newFactId(((Fact)this.value).getFactId());
                    }
                }
            }
            case OBJECT: {
                switch (type) {
                    case BOOLEAN: {
                        return JamochaValue.newBoolean((Boolean)this.value);
                    }
                    case DOUBLE: {
                        return JamochaValue.newDouble((Double)this.value);
                    }
                    case LONG: {
                        return JamochaValue.newLong((Long)this.value);
                    }
                }
            }
        }
        throw new IllegalConversionException("Unable to cast " + (Object)((Object)this.type) + " to type " + (Object)((Object)type) + ".");
    }

    public boolean is(JamochaType type) {
        return this.type == type;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        if (this.type == JamochaType.LIST) {
            JamochaValue[] temp;
            for (JamochaValue obj : temp = (JamochaValue[])this.value) {
                result = 31 * result + (obj == null ? 0 : obj.hashCode());
            }
        } else {
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        JamochaValue other = (JamochaValue)obj;
        if (this.value == null) {
            return other.value == null || other.value == "NIL";
        }
        if (this.value instanceof JamochaValue[] && other.value instanceof JamochaValue[]) {
            Object[] a1 = (JamochaValue[])this.value;
            Object[] a2 = (JamochaValue[])other.value;
            return Arrays.equals(a1, a2);
        }
        return this.value.equals(other.value);
    }

    @Override
    public boolean isFactBinding() {
        return false;
    }

    private String fillToFixedLength(int val, String fill, int length) {
        String res = String.valueOf(val);
        while (res.length() < length) {
            res = fill + res;
        }
        return res;
    }

    @Override
    public String getExpressionString() {
        StringBuilder sb = new StringBuilder();
        switch (this.getType()) {
            case NIL: {
                return "NIL";
            }
            case STRING: {
                return "\"" + this.getStringValue() + "\"";
            }
            case FACT_ID: {
                return "f-" + this.getFactIdValue();
            }
            case DATETIME: {
                GregorianCalendar c = this.getDateValue();
                sb.append(this.fillToFixedLength(c.get(1), "0", 4)).append('-');
                sb.append(this.fillToFixedLength(c.get(2) + 1, "0", 2)).append('-');
                sb.append(this.fillToFixedLength(c.get(5), "0", 2)).append(' ');
                sb.append(this.fillToFixedLength(c.get(11), "0", 2)).append(':');
                sb.append(this.fillToFixedLength(c.get(12), "0", 2)).append(':');
                sb.append(this.fillToFixedLength(c.get(13), "0", 2)).append(".");
                sb.append(this.fillToFixedLength(c.get(14), "0", 3));
                int gmtOffsetMillis = c.get(15);
                if (gmtOffsetMillis >= 0) {
                    sb.append('+');
                } else {
                    sb.append('-');
                }
                int gmtOffsetHours = Math.abs(gmtOffsetMillis / 3600000);
                sb.append(this.fillToFixedLength(gmtOffsetHours, "0", 2));
                break;
            }
            case LIST: {
                sb.append('[');
                for (int i = 0; i < this.getListCount(); ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(this.getListValue(i).getExpressionString());
                }
                sb.append(']');
                break;
            }
            case SLOT: {
                sb.append('(');
                Slot slot = this.getSlotValue();
                sb.append(slot.getName());
                sb.append(' ');
                sb.append(slot.getValue().getExpressionString());
                sb.append(')');
                break;
            }
            default: {
                sb.append(this.getObjectValue().toString());
            }
        }
        return sb.toString();
    }

    @Override
    public String format(Formatter visitor) {
        return visitor.visit(this);
    }

    @Override
    public JamochaValue getValue(Engine engine) throws EvaluationException {
        return this;
    }
}

