/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.parser;

import java.util.GregorianCalendar;
import org.jamocha.parser.JamochaValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum JamochaType {
    UNDEFINED,
    NIL,
    BOOLEAN,
    LONG,
    DOUBLE,
    DATETIME,
    STRING,
    LIST,
    OBJECT,
    IDENTIFIER,
    FACT,
    FACT_ID,
    SLOT,
    BINDING;

    public static final JamochaType[] NONE;
    public static final JamochaType[] BOOLEANS;
    public static final JamochaType[] IDENTIFIERS;
    public static final JamochaType[] OBJECTS;
    public static final JamochaType[] ANY;
    public static final JamochaType[] NUMBERS;
    public static final JamochaType[] LONGS;
    public static final JamochaType[] DOUBLES;
    public static final JamochaType[] DATETIMES;
    public static final JamochaType[] STRINGS;
    public static final JamochaType[] FACTS;
    public static final JamochaType[] FACT_IDS;
    public static final JamochaType[] SLOTS;
    public static final JamochaType[] PRIMITIVES;
    public static final JamochaType[] LISTS;

    public static JamochaType getMappingType(Class<?> clzz) {
        if (clzz.isArray()) {
            return LIST;
        }
        if (clzz.isPrimitive()) {
            if (clzz == Integer.TYPE) {
                return LONG;
            }
            if (clzz == Short.TYPE) {
                return LONG;
            }
            if (clzz == Long.TYPE) {
                return LONG;
            }
            if (clzz == Float.TYPE) {
                return DOUBLE;
            }
            if (clzz == Byte.TYPE) {
                return LONG;
            }
            if (clzz == Double.TYPE) {
                return DOUBLE;
            }
            if (clzz == Boolean.TYPE) {
                return BOOLEAN;
            }
        } else {
            if (clzz == String.class) {
                return STRING;
            }
            if (clzz == GregorianCalendar.class) {
                return DATETIME;
            }
        }
        return OBJECT;
    }

    public static JamochaValue getDefaultValue(JamochaType type) {
        switch (type) {
            case NIL: 
            case UNDEFINED: 
            case DATETIME: 
            case OBJECT: 
            case IDENTIFIER: 
            case FACT: 
            case FACT_ID: 
            case SLOT: 
            case BINDING: {
                return JamochaValue.NIL;
            }
            case BOOLEAN: {
                return JamochaValue.FALSE;
            }
            case LONG: {
                return JamochaValue.newLong(0L);
            }
            case DOUBLE: {
                return JamochaValue.newDouble(0.0);
            }
            case STRING: {
                return JamochaValue.newString("");
            }
            case LIST: {
                return JamochaValue.EMPTY_LIST;
            }
        }
        throw new RuntimeException("Wrong JamochaType");
    }

    static {
        NONE = new JamochaType[0];
        BOOLEANS = new JamochaType[]{BOOLEAN};
        IDENTIFIERS = new JamochaType[]{IDENTIFIER};
        OBJECTS = new JamochaType[]{OBJECT};
        ANY = new JamochaType[]{UNDEFINED};
        NUMBERS = new JamochaType[]{DOUBLE, LONG};
        LONGS = new JamochaType[]{LONG};
        DOUBLES = new JamochaType[]{DOUBLE};
        DATETIMES = new JamochaType[]{DATETIME};
        STRINGS = new JamochaType[]{STRING};
        FACTS = new JamochaType[]{FACT};
        FACT_IDS = new JamochaType[]{FACT_ID};
        SLOTS = new JamochaType[]{SLOT};
        PRIMITIVES = new JamochaType[]{BOOLEAN, LONG, DOUBLE, STRING};
        LISTS = new JamochaType[]{LIST};
    }
}

