/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.languages.sl.sl2clips_adapter.performative;

import java.util.List;
import org.jamocha.languages.sl.parser.ParseException;
import org.jamocha.languages.sl.parser.SLParser;
import org.jamocha.languages.sl.sl2clips_adapter.AdapterTranslationException;
import org.jamocha.languages.sl.sl2clips_adapter.configurations.ActionSLConfiguration;
import org.jamocha.languages.sl.sl2clips_adapter.configurations.ContentSLConfiguration;
import org.jamocha.languages.sl.sl2clips_adapter.configurations.IdentifyingExpressionSLConfiguration;
import org.jamocha.languages.sl.sl2clips_adapter.configurations.SLCompileType;
import org.jamocha.languages.sl.sl2clips_adapter.configurations.SLConfiguration;
import org.jamocha.languages.sl.sl2clips_adapter.performative.SLPerformativeTranslator;

class Proxy
extends SLPerformativeTranslator {
    Proxy() {
    }

    public String getCLIPS(String slContent) throws AdapterTranslationException {
        ContentSLConfiguration contentConf;
        try {
            contentConf = SLParser.parse(slContent);
        }
        catch (ParseException e) {
            throw new AdapterTranslationException("Could not translate from SL to CLIPS.", e);
        }
        List<SLConfiguration> results = contentConf.getExpressions();
        this.checkContentItemCount(results, 3);
        int uniqueId = this.getUniqueId();
        String ruleName = "proxy-" + uniqueId;
        String bindName = "?*proxy-" + uniqueId + "*";
        IdentifyingExpressionSLConfiguration conf = (IdentifyingExpressionSLConfiguration)results.get(0);
        String refOp = conf.getRefOp().compile(SLCompileType.RULE_LHS);
        String binding = conf.getTermOrIE().compile(SLCompileType.RULE_RESULT);
        ActionSLConfiguration actConf = (ActionSLConfiguration)results.get(1);
        String proxyMessage = actConf.compile(SLCompileType.ASSERT_MESSAGE_AS_TEMPLATE);
        StringBuilder result = new StringBuilder();
        result.append("(bind ");
        result.append(bindName);
        result.append(" (create$ ))");
        result.append("(defrule ");
        result.append(ruleName);
        result.append(" ");
        result.append(conf.getWff().compile(SLCompileType.RULE_LHS));
        result.append(results.get(2).compile(SLCompileType.RULE_LHS));
        result.append(" => ");
        result.append("(bind ");
        result.append(bindName);
        result.append(" (insert-list$ ");
        result.append(bindName);
        result.append(" 1 ");
        result.append(binding);
        result.append(")))");
        result.append("(fire)");
        result.append("(undefrule \"");
        result.append(ruleName);
        result.append("\")");
        result.append("(assert (agent-proxy-result (message %MSG%)");
        result.append("(proxyMessage ");
        result.append(proxyMessage);
        result.append(")(refOp \"");
        result.append(refOp);
        result.append("\")(agents ");
        result.append(bindName);
        result.append(")))");
        return result.toString();
    }
}

