/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.languages.sl.sl2clips_adapter.configurations;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jamocha.languages.sl.sl2clips_adapter.configurations.SLCompileType;
import org.jamocha.languages.sl.sl2clips_adapter.configurations.SLConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionCallOrFactSLConfiguration
implements SLConfiguration {
    private static final String[] isSLMessage = new String[]{"accept-proposal", "agree", "cancel", "cfp", "confirm", "disconfirm", "failure", "inform", "inform-if", "inform-ref", "not-understood", "propagate", "propose", "proxy", "query-if", "query-ref", "refuse", "reject-proposal", "request", "request-when", "request-whenever", "subscribe"};
    private SLConfiguration name;
    private Map<SLConfiguration, SLConfiguration> slots = new HashMap<SLConfiguration, SLConfiguration>();
    private List<SLConfiguration> slotNames = new LinkedList<SLConfiguration>();

    public Map<SLConfiguration, SLConfiguration> getSlots() {
        return this.slots;
    }

    public void addSlot(SLConfiguration name, SLConfiguration value) {
        this.slotNames.add(name);
        this.slots.put(name, value);
    }

    public SLConfiguration getSlot(SLConfiguration name) {
        return this.slots.get(name);
    }

    public SLConfiguration getSlot(String name, SLCompileType compileType) {
        for (SLConfiguration slotName : this.slotNames) {
            if (!name.equals(slotName.compile(compileType))) continue;
            return this.slots.get(slotName);
        }
        return null;
    }

    public SLConfiguration getName() {
        return this.name;
    }

    public void setName(SLConfiguration templateName) {
        this.name = templateName;
    }

    public boolean isSLMessage() {
        String nameStr = this.name.compile(SLCompileType.ACTION_AND_ASSERT);
        for (String temp : isSLMessage) {
            if (!nameStr.equalsIgnoreCase(temp)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String compile(SLCompileType compileType) {
        StringBuilder res = new StringBuilder();
        boolean messageAsTemplate = false;
        if (compileType.equals((Object)SLCompileType.ACTION_AND_ASSERT) && this.isSLMessage()) {
            compileType = SLCompileType.ASSERT_MESSAGE_AS_TEMPLATE;
        }
        switch (compileType) {
            case ACTION_AND_ASSERT: {
                res.append("(").append(this.name.compile(compileType));
                for (SLConfiguration slotName : this.slotNames) {
                    if (this.slots.get(slotName) == null) continue;
                    res.append(" ");
                    res.append(this.slots.get(slotName).compile(SLCompileType.ASSERT));
                }
                res.append(")");
                break;
            }
            case ASSERT: {
                res.append("(assert (").append(this.name.compile(compileType));
                for (SLConfiguration slotName : this.slotNames) {
                    res.append(" (").append(slotName.compile(compileType)).append(" ");
                    if (this.slots.get(slotName) != null) {
                        res.append(this.slots.get(slotName).compile(compileType));
                    }
                    res.append(")");
                }
                res.append("))");
                break;
            }
            case ASSERT_MESSAGE_AS_TEMPLATE: {
                messageAsTemplate = true;
            }
            case ASSERT_MESSAGE: {
                res.append("(assert (agent-message (performative ");
                res.append(this.name.compile(compileType));
                res.append(")");
                if (messageAsTemplate) {
                    res.append("(is-template TRUE)");
                } else {
                    res.append("(incoming TRUE)");
                }
                for (SLConfiguration slotName : this.slotNames) {
                    String slotNameString = slotName.compile(SLCompileType.ASSERT);
                    if (slotNameString.equalsIgnoreCase("performative")) continue;
                    res.append(" (").append(slotNameString.toLowerCase()).append(" ");
                    if (this.slots.get(slotName) != null) {
                        res.append(this.slots.get(slotName).compile(SLCompileType.ASSERT));
                    }
                    res.append(")");
                }
                res.append("))");
                break;
            }
            case RULE_LHS: {
                res.append("(").append(this.name.compile(compileType));
                for (SLConfiguration slotName : this.slotNames) {
                    res.append(" (").append(slotName.compile(compileType)).append(" ");
                    if (this.slots.get(slotName) != null) {
                        res.append(this.slots.get(slotName).compile(compileType));
                    } else {
                        res.append("NIL");
                    }
                    res.append(")");
                }
                res.append(")");
            }
        }
        return res.toString();
    }
}

