/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.formatter;

import java.util.LinkedList;
import java.util.List;
import org.jamocha.engine.BoundParam;
import org.jamocha.engine.ExpressionCollection;
import org.jamocha.engine.ExpressionList;
import org.jamocha.engine.ExpressionSequence;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.configurations.AssertConfiguration;
import org.jamocha.engine.configurations.DeclarationConfiguration;
import org.jamocha.engine.configurations.DeffunctionConfiguration;
import org.jamocha.engine.configurations.DefmoduleConfiguration;
import org.jamocha.engine.configurations.DefruleConfiguration;
import org.jamocha.engine.configurations.IfElseConfiguration;
import org.jamocha.engine.configurations.LoopForCountConfiguration;
import org.jamocha.engine.configurations.ModifyConfiguration;
import org.jamocha.engine.configurations.Signature;
import org.jamocha.engine.configurations.SlotConfiguration;
import org.jamocha.engine.configurations.WhileDoConfiguration;
import org.jamocha.engine.functions.Function;
import org.jamocha.engine.nodes.joinfilter.LeftFieldAddress;
import org.jamocha.engine.nodes.joinfilter.RightFieldAddress;
import org.jamocha.engine.workingmemory.elements.Deftemplate;
import org.jamocha.engine.workingmemory.elements.Fact;
import org.jamocha.engine.workingmemory.elements.MultiSlot;
import org.jamocha.engine.workingmemory.elements.Slot;
import org.jamocha.engine.workingmemory.elements.TemplateSlot;
import org.jamocha.formatter.Formatter;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.JamochaValue;
import org.jamocha.rules.Action;
import org.jamocha.rules.AndCondition;
import org.jamocha.rules.BoundConstraint;
import org.jamocha.rules.Condition;
import org.jamocha.rules.Constraint;
import org.jamocha.rules.FunctionAction;
import org.jamocha.rules.LiteralConstraint;
import org.jamocha.rules.NotExistsCondition;
import org.jamocha.rules.ObjectCondition;
import org.jamocha.rules.OrCondition;
import org.jamocha.rules.OrderedFactConstraint;
import org.jamocha.rules.Rule;
import org.jamocha.rules.TestCondition;

public class SFPFormatter
extends Formatter {
    public String visit(Function object) {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        sb.append(object.getName());
        sb.append(')');
        return sb.toString();
    }

    public String visit(JamochaValue object) {
        return object.getExpressionString();
    }

    public String visit(Signature object) {
        Parameter[] params;
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        sb.append(object.getSignatureName());
        for (Parameter param : params = object.getParameters()) {
            sb.append(' ');
            sb.append(param.format(this));
        }
        sb.append(')');
        return sb.toString();
    }

    public String visit(SlotConfiguration object) {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        sb.append(object.getSlotName());
        Parameter[] params = object.getSlotValues();
        this.increaseIndent();
        for (Parameter param : params) {
            sb.append(' ');
            sb.append(param.format(this));
        }
        this.decreaseIndent();
        sb.append(')');
        return sb.toString();
    }

    public String visit(DeffunctionConfiguration object) {
        StringBuilder sb = new StringBuilder();
        sb.append(object.getFunctionName());
        if (object.getFunctionDescription() != null) {
            this.newLine(sb);
            sb.append("\"").append(object.getFunctionDescription()).append("\"");
        }
        if (object.definesFunctionGroup()) {
            this.newLine(sb);
            sb.append("(functiongroup \"").append(object.getFunctionGroup()).append("\")");
        }
        this.newLine(sb);
        sb.append('(');
        Parameter[] params = object.getParams();
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                sb.append(' ');
            }
            sb.append(params[i].format(this));
        }
        sb.append(')');
        if (object.getActions().size() > 0) {
            this.newLine(sb);
            sb.append(object.getActions().format(this));
        }
        this.newLine(sb);
        return sb.toString();
    }

    public String visit(BoundParam object) {
        return "?" + object.getVariableName();
    }

    public String visit(ExpressionList object) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < object.size(); ++i) {
            if (i > 0) {
                sb.append(' ');
            }
            sb.append(object.get(i).format(this));
        }
        return sb.toString();
    }

    public String visit(ExpressionSequence object) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < object.size(); ++i) {
            if (i > 0) {
                sb.append(' ');
            }
            sb.append(object.get(i).format(this));
        }
        return sb.toString();
    }

    public String visit(AssertConfiguration object) {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        sb.append(object.getTemplateName());
        Parameter[] slots = object.getData();
        this.increaseIndent();
        for (Parameter slot : slots) {
            this.newLine(sb);
            sb.append(slot.format(this));
        }
        this.decreaseIndent();
        this.newLine(sb);
        sb.append(')');
        return sb.toString();
    }

    public String visit(DefmoduleConfiguration object) {
        return object.getModuleName();
    }

    public String visit(DefruleConfiguration object) {
        Condition[] conditions;
        StringBuilder sb = new StringBuilder();
        sb.append(object.getRuleName());
        this.increaseIndent();
        if (object.getRuleDescription() != null) {
            this.newLine(sb);
            sb.append("\"").append(object.getRuleDescription()).append("\"");
        }
        if (object.getDeclarationConfiguration() != null) {
            this.newLine(sb);
            sb.append(object.getDeclarationConfiguration().format(this));
        }
        this.newLine(sb);
        for (Condition condition : conditions = object.getConditions()) {
            sb.append(condition.format(this));
            this.newLine(sb);
        }
        sb.append("=>");
        this.newLine(sb);
        sb.append(object.getActions().format(this));
        this.decreaseIndent();
        this.newLine(sb);
        return sb.toString();
    }

    public String visit(IfElseConfiguration object) {
        StringBuilder sb = new StringBuilder();
        sb.append(object.getCondition().format(this));
        sb.append(" then ");
        this.increaseIndent();
        this.newLine(sb);
        sb.append(object.getThenActions().format(this));
        this.decreaseIndent();
        this.newLine(sb);
        ExpressionCollection elseActions = object.getElseActions();
        if (elseActions != null) {
            sb.append("else");
            this.increaseIndent();
            this.newLine(sb);
            sb.append(object.getElseActions().format(this));
            this.decreaseIndent();
            this.newLine(sb);
        }
        return sb.toString();
    }

    public String visit(LoopForCountConfiguration object) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append(object.getLoopVar().format(this));
        sb.append(" ");
        sb.append(object.getStartIndex().format(this));
        sb.append(" ");
        sb.append(object.getEndIndex().format(this));
        sb.append(") do");
        this.increaseIndent();
        this.newLine(sb);
        sb.append(object.getActions().format(this));
        this.decreaseIndent();
        this.newLine(sb);
        return sb.toString();
    }

    public String visit(ModifyConfiguration object) {
        SlotConfiguration[] scArray;
        StringBuilder sb = new StringBuilder();
        sb.append("?");
        sb.append(((BoundParam)object.getFactBinding()).getVariableName());
        for (SlotConfiguration sc : scArray = object.getSlots()) {
            sb.append(" ");
            sb.append(sc.format(this));
        }
        return sb.toString();
    }

    public String visit(WhileDoConfiguration object) {
        StringBuilder sb = new StringBuilder();
        this.increaseIndent();
        this.newLine(sb);
        sb.append(object.getCondition().format(this));
        this.decreaseIndent();
        this.newLine(sb);
        sb.append(" do ");
        this.increaseIndent();
        this.newLine(sb);
        sb.append(object.getWhileActions().format(this));
        this.decreaseIndent();
        this.newLine(sb);
        return sb.toString();
    }

    public String visit(Rule object) {
        StringBuilder buf = new StringBuilder();
        buf.append("(defrule ").append(object.parentModule().getName());
        buf.append("::").append(object.getName());
        this.increaseIndent();
        this.newLine(buf);
        buf.append("(declare ");
        this.increaseIndent();
        this.newLine(buf);
        buf.append("(salience ").append(object.getSalience()).append(") ");
        this.newLine(buf);
        this.decreaseIndent();
        this.newLine(buf);
        buf.append(") ");
        this.newLine(buf);
        List<Condition> conditions = object.getConditions();
        for (int idx = 0; idx < conditions.size(); ++idx) {
            Condition c = conditions.get(idx);
            buf.append(c.format(this));
            if (idx == conditions.size() - 1) {
                this.decreaseIndent();
            }
            this.newLine(buf);
        }
        buf.append("=>");
        this.increaseIndent();
        this.newLine(buf);
        List<Action> actions = object.getActions();
        for (int idx = 0; idx < actions.size(); ++idx) {
            buf.append(actions.get(idx).format(this));
            if (idx == actions.size() - 1) {
                this.decreaseIndent();
            }
            this.newLine(buf);
        }
        buf.append(')');
        return buf.toString();
    }

    public String visit(ObjectCondition object) {
        StringBuilder sb = new StringBuilder();
        List<Constraint> constraints = object.getConstraints();
        LinkedList<Constraint> remainingConstraints = new LinkedList<Constraint>(constraints);
        for (Constraint constraint : constraints) {
            BoundConstraint bc;
            if (!(constraint instanceof BoundConstraint) || !(bc = (BoundConstraint)constraint).isFactBinding() || !bc.getConstraintName().equals(object.getTemplateName())) continue;
            sb.append("?").append(bc.getConstraintName());
            sb.append(" <- ");
            remainingConstraints.remove(constraint);
            break;
        }
        sb.append('(').append(object.getTemplateName());
        this.increaseIndent();
        for (Constraint constraint : remainingConstraints) {
            this.newLine(sb);
            sb.append(constraint.format(this));
        }
        this.decreaseIndent();
        this.newLine(sb);
        sb.append(')');
        return sb.toString();
    }

    public String visit(TestCondition object) {
        StringBuilder sb = new StringBuilder();
        sb.append("(test ");
        sb.append(object.getFunction().format(this));
        sb.append(')');
        return sb.toString();
    }

    public String visit(BoundConstraint object) {
        StringBuilder sb = new StringBuilder();
        sb.append('(').append(object.getSlotName()).append(" ");
        sb.append("?").append(object.getConstraintName());
        sb.append(')');
        return sb.toString();
    }

    public String visit(LiteralConstraint object) {
        StringBuilder sb = new StringBuilder();
        sb.append('(').append(object.getSlotName());
        sb.append(' ').append(object.getValue().format(this));
        sb.append(')');
        return sb.toString();
    }

    public String visit(LeftFieldAddress object) {
        return "[inTuple|elem=" + object.getTupleIndex().get() + "|slot=" + object.getSlotIndex() + "]";
    }

    public String visit(RightFieldAddress object) {
        return null;
    }

    public String visit(FunctionAction object) {
        StringBuilder sb = new StringBuilder();
        sb.append('(').append(object.getFunction().getName());
        for (Parameter param : object.getParameters()) {
            sb.append(' ');
            sb.append(param.format(this));
        }
        sb.append(')');
        this.newLine(sb);
        return sb.toString();
    }

    public String visit(DeclarationConfiguration object) {
        StringBuilder sb = new StringBuilder();
        sb.append("(declare");
        this.increaseIndent();
        this.newLine(sb);
        sb.append("(salience ").append(object.getSalience().format(this)).append(") ");
        this.newLine(sb);
        sb.append("(rule-version ").append(object.getVersion().format(this)).append(") ");
        this.newLine(sb);
        sb.append("(auto-focus ").append(object.getAutoFocus().format(this)).append(") ");
        this.decreaseIndent();
        this.newLine(sb);
        sb.append(')');
        return sb.toString();
    }

    public String visit(NotExistsCondition object) {
        StringBuilder sb = new StringBuilder();
        sb.append("(not");
        this.increaseIndent();
        List<Condition> conditions = object.getNestedConditions();
        for (Condition condition : conditions) {
            this.newLine(sb);
            sb.append(condition.format(this));
        }
        this.decreaseIndent();
        this.newLine(sb);
        sb.append(")");
        this.newLine(sb);
        return sb.toString();
    }

    public String visit(AndCondition object) {
        StringBuilder sb = new StringBuilder();
        sb.append("(and");
        this.increaseIndent();
        List<Condition> conditions = object.getNestedConditions();
        for (Condition condition : conditions) {
            this.newLine(sb);
            sb.append(condition.format(this));
        }
        this.decreaseIndent();
        this.newLine(sb);
        sb.append(")");
        this.newLine(sb);
        return sb.toString();
    }

    public String visit(OrCondition object) {
        StringBuilder sb = new StringBuilder();
        sb.append("(or");
        this.increaseIndent();
        List<Condition> conditions = object.getNestedConditions();
        for (Condition condition : conditions) {
            this.newLine(sb);
            sb.append(condition.format(this));
        }
        this.decreaseIndent();
        this.newLine(sb);
        sb.append(")");
        this.newLine(sb);
        return sb.toString();
    }

    public String visit(Fact object) {
        StringBuilder sb = new StringBuilder();
        sb.append('(').append(object.getTemplate().getName());
        TemplateSlot[] slots = object.getTemplate().getAllSlots();
        this.increaseIndent();
        for (int i = 0; i < slots.length; ++i) {
            this.newLine(sb);
            sb.append('(').append(slots[i].getName()).append(' ');
            try {
                sb.append(object.getSlotValue(i).format(this));
            }
            catch (EvaluationException e) {
                e.printStackTrace();
            }
            sb.append(")");
        }
        this.decreaseIndent();
        this.newLine(sb);
        sb.append(")");
        return sb.toString();
    }

    public String visit(Deftemplate object) {
        StringBuilder sb = new StringBuilder();
        sb.append('(').append(object.getName()).append(' ');
        TemplateSlot[] slots = object.getAllSlots();
        this.increaseIndent();
        for (int idx = 0; idx < slots.length; ++idx) {
            this.newLine(sb);
            sb.append(((Slot)slots[idx]).format(this));
        }
        this.decreaseIndent();
        this.newLine(sb);
        sb.append(")");
        return sb.toString();
    }

    public String visit(MultiSlot object) {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        sb.append(object.getName());
        this.increaseIndent();
        this.newLine(sb);
        sb.append(object.getValue().format(this));
        this.newLine(sb);
        this.decreaseIndent();
        this.newLine(sb);
        sb.append(')');
        return sb.toString();
    }

    public String visit(Slot object) {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        sb.append(object.getName());
        this.increaseIndent();
        this.newLine(sb);
        sb.append(object.getValue().format(this));
        this.newLine(sb);
        this.decreaseIndent();
        this.newLine(sb);
        sb.append(')');
        return sb.toString();
    }

    public String visit(TemplateSlot object) {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        if (object.isSilent()) {
            sb.append("silent ");
        }
        if (object.isMultiSlot()) {
            sb.append("multislot ");
        } else {
            sb.append("slot ");
        }
        sb.append(object.getName());
        this.increaseIndent();
        this.newLine(sb);
        sb.append("(type ").append((Object)object.getValueType()).append(')');
        this.newLine(sb);
        sb.append("(default ");
        if (object.isRequired()) {
            sb.append("?NONE");
        } else if (object.getDefaultExpression() != null) {
            sb.append(object.getDefaultExpression().format(this));
        } else {
            sb.append("NIL");
        }
        sb.append(')');
        this.decreaseIndent();
        this.newLine(sb);
        sb.append(')');
        return sb.toString();
    }

    public String visit(OrderedFactConstraint object) {
        Constraint[] constrList;
        StringBuilder sb = new StringBuilder();
        for (Constraint c : constrList = object.getConstraints()) {
            sb.append(c.getValue().format(this));
            sb.append(" ");
        }
        return sb.toString();
    }
}

