/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.workingmemory.elements;

import org.jamocha.engine.Engine;
import org.jamocha.engine.workingmemory.elements.MultiSlot;
import org.jamocha.engine.workingmemory.elements.Slot;
import org.jamocha.formatter.Formatter;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.Expression;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class TemplateSlot
extends Slot {
    private static final long serialVersionUID = 1L;
    private int nodeCount = 1;
    private boolean multiSlot = false;
    private boolean staticDefault;
    private boolean silent = false;
    private boolean required = false;
    private Expression defaultExpression;

    public TemplateSlot() {
    }

    public TemplateSlot(String name) {
        super(name);
    }

    public boolean isMultiSlot() {
        return this.multiSlot;
    }

    public void setMultiSlot(boolean multiSlot) {
        this.multiSlot = multiSlot;
    }

    public Expression getDefaultExpression() {
        return this.defaultExpression;
    }

    public void setDefaultExpression(Expression defaultExpression) {
        this.defaultExpression = defaultExpression;
    }

    public Slot createSlot(Engine engine) throws EvaluationException {
        JamochaValue value;
        Slot result;
        if (this.isMultiSlot()) {
            result = new MultiSlot(this.silent, this.getName());
        } else {
            result = new Slot(this.silent, this.getName());
            result.setValueType(this.getValueType());
        }
        if (this.defaultExpression != null && !this.defaultExpression.equals("?None") && (value = this.defaultExpression.getValue(engine)) != null) {
            if (value.getType().equals((Object)JamochaType.LIST) && !this.isMultiSlot()) {
                value = value.getListCount() > 0 ? value.getListValue(0) : JamochaValue.NIL;
            }
            if (value != null) {
                result.setValue(value);
            }
        }
        result.setId(this.getId());
        return result;
    }

    public int getNodeCount() {
        return this.nodeCount;
    }

    public void incrementNodeCount() {
        ++this.nodeCount;
    }

    public void decrementNodeCount() {
        --this.nodeCount;
    }

    public boolean isStaticDefault() {
        return this.staticDefault;
    }

    public void setStaticDefaultExpression(Expression expression) {
        this.staticDefault = true;
        this.defaultExpression = expression;
    }

    public void setDynamicDefaultExpression(Expression expression) {
        this.staticDefault = false;
        this.defaultExpression = expression;
    }

    public void setDefaultDerive() {
        this.staticDefault = true;
        this.defaultExpression = JamochaType.getDefaultValue(this.getValueType());
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    public String format(Formatter visitor) {
        return visitor.visit(this);
    }
}

