/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.workingmemory.elements;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jamocha.Constants;
import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.modules.Module;
import org.jamocha.engine.workingmemory.elements.Deffact;
import org.jamocha.engine.workingmemory.elements.Fact;
import org.jamocha.engine.workingmemory.elements.Slot;
import org.jamocha.engine.workingmemory.elements.Template;
import org.jamocha.engine.workingmemory.elements.TemplateSlot;
import org.jamocha.engine.workingmemory.elements.tags.Tag;
import org.jamocha.engine.workingmemory.elements.tags.TagIterator;
import org.jamocha.formatter.Formatter;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderedTemplate
implements Template {
    private static final long serialVersionUID = 1L;
    private final TemplateSlot data;
    private String templateName = null;
    private boolean watch = false;
    protected List<Tag> tags;

    public OrderedTemplate(String name) {
        this.templateName = name;
        this.data = new TemplateSlot("__data");
        this.data.setMultiSlot(true);
        this.tags = new ArrayList<Tag>();
    }

    public Fact createFact(Parameter[] params, Engine engine) throws EvaluationException {
        Slot slot = new Slot(this.data.getName());
        slot.setId(0);
        boolean hasbinding = false;
        JamochaValue[] list = new JamochaValue[params.length];
        for (int i = 0; i < params.length; ++i) {
            list[i] = params[i].getValue(engine);
            if (list[i].getType() != JamochaType.BINDING) continue;
            hasbinding = true;
        }
        JamochaValue val = JamochaValue.newList(list);
        slot.setValue(val);
        Deffact newfact = new Deffact(this, new Slot[]{slot});
        if (hasbinding) {
            Slot bslot = (Slot)slot.clone();
            bslot.setValue(val);
            newfact.boundSlots = new Slot[]{bslot};
            newfact.hasBinding = true;
        }
        newfact.equalityIndex();
        return newfact;
    }

    @Override
    public TemplateSlot[] getAllSlots() {
        TemplateSlot[] res = new TemplateSlot[]{this.data};
        return res;
    }

    public String getClassName() {
        return null;
    }

    @Override
    public String getName() {
        return this.templateName;
    }

    @Override
    public int getNumberOfSlots() {
        return 1;
    }

    public Template getParent() {
        return null;
    }

    @Override
    public TemplateSlot getSlot(String name) {
        if (name.equals(this.data.getName())) {
            return this.data;
        }
        return null;
    }

    @Override
    public TemplateSlot getSlot(int column) {
        if (column == 0) {
            return this.data;
        }
        return null;
    }

    public boolean getWatch() {
        return this.watch;
    }

    @Override
    public boolean inUse() {
        return this.data.getNodeCount() > 0;
    }

    public void setParent(Template parent) {
    }

    public void setWatch(boolean watch) {
        this.watch = watch;
    }

    @Override
    public String toPPString() {
        StringBuffer buf = new StringBuffer();
        buf.append("(" + this.templateName + Constants.LINEBREAK);
        buf.append("  (" + this.data.getName() + " (type " + (Object)((Object)this.data.getValueType()) + ") )" + Constants.LINEBREAK);
        buf.append(")");
        return buf.toString();
    }

    public String getDump(String modName) {
        return this.toPPString();
    }

    @Override
    public String format(Formatter visitor) {
        return visitor.visit(this);
    }

    public String getDescription() {
        return "(implied)";
    }

    @Override
    public Iterator<Tag> getTags() {
        return this.getTags(Tag.class);
    }

    @Override
    public void addTag(Tag t) {
        this.tags.add(t);
    }

    @Override
    public Iterator<Tag> getTags(Class<? extends Tag> tagClass) {
        return new TagIterator(tagClass, this.tags);
    }

    @Override
    public String getDump() {
        return this.toString();
    }

    @Override
    public Module checkUserDefinedModuleName(Engine engine) {
        return null;
    }

    @Override
    public void evaluateStaticDefaults(Engine engine) throws EvaluationException {
    }
}

