/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.workingmemory.elements;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jamocha.communication.logging.Logging;
import org.jamocha.engine.Engine;
import org.jamocha.engine.modules.Module;
import org.jamocha.engine.workingmemory.elements.Template;
import org.jamocha.engine.workingmemory.elements.TemplateSlot;
import org.jamocha.engine.workingmemory.elements.tags.Tag;
import org.jamocha.engine.workingmemory.elements.tags.TagIterator;
import org.jamocha.formatter.Formatter;
import org.jamocha.parser.EvaluationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaTemplate
implements Template {
    private String name;
    private TemplateSlot[] slots;
    private Map<String, TemplateSlot> name2ts;
    private List<Tag> tags;
    private Class<? extends Object> javaClass;

    public Class<? extends Object> getJavaClass() {
        return this.javaClass;
    }

    protected static String lowerCaseFirstLetter(String s) {
        if (s.length() == 0) {
            return s;
        }
        return s.substring(0, 1).toLowerCase() + s.substring(1);
    }

    public static List<String> getFieldsFromBean(Class<? extends Object> c) {
        ArrayList<String> fields = new ArrayList<String>();
        for (Method getter : c.getMethods()) {
            Method setter;
            if (!getter.getName().startsWith("get") && !getter.getName().startsWith("is")) continue;
            String potetialAttrName = getter.getName().startsWith("get") ? getter.getName().substring(3) : getter.getName().substring(2);
            if (getter.getParameterTypes().length > 0) continue;
            Class<?> attrType = getter.getReturnType();
            try {
                setter = c.getMethod("set" + potetialAttrName, attrType);
            }
            catch (SecurityException e) {
                continue;
            }
            catch (NoSuchMethodException e) {
                continue;
            }
            assert (setter != null);
            fields.add(JavaTemplate.lowerCaseFirstLetter(potetialAttrName));
        }
        return fields;
    }

    public static TemplateSlot[] getTemplateSlotsFromClass(Class<? extends Object> c) {
        ArrayList<TemplateSlot> slots = new ArrayList<TemplateSlot>();
        int id = 0;
        for (String slotName : JavaTemplate.getFieldsFromBean(c)) {
            TemplateSlot tslot = new TemplateSlot(slotName);
            tslot.setId(id++);
            Logging.logger(JavaTemplate.class).debug("in class '" + c.getCanonicalName() + "' found attribute '" + slotName + "'");
            slots.add(tslot);
        }
        TemplateSlot[] slotsArray = new TemplateSlot[slots.size()];
        return slots.toArray(slotsArray);
    }

    public JavaTemplate(Class<? extends Object> c) {
        this.slots = JavaTemplate.getTemplateSlotsFromClass(c);
        this.name = c.getCanonicalName();
        this.javaClass = c;
        this.tags = new ArrayList<Tag>();
        this.name2ts = new HashMap<String, TemplateSlot>();
        for (TemplateSlot ts : this.slots) {
            this.name2ts.put(ts.getName(), ts);
        }
    }

    @Override
    public void addTag(Tag t) {
        this.tags.add(t);
    }

    @Override
    public Module checkUserDefinedModuleName(Engine engine) {
        return null;
    }

    @Override
    public void evaluateStaticDefaults(Engine engine) throws EvaluationException {
    }

    @Override
    public TemplateSlot[] getAllSlots() {
        return this.slots;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getNumberOfSlots() {
        return this.slots.length;
    }

    @Override
    public TemplateSlot getSlot(String name) {
        return this.name2ts.get(name);
    }

    @Override
    public TemplateSlot getSlot(int column) {
        return this.slots[column];
    }

    @Override
    public Iterator<Tag> getTags() {
        return this.tags.iterator();
    }

    @Override
    public Iterator<Tag> getTags(Class<? extends Tag> tagClass) {
        return new TagIterator(tagClass, this.tags);
    }

    @Override
    public boolean inUse() {
        return true;
    }

    @Override
    public String toPPString() {
        return "[Template from java class '" + this.name + "']";
    }

    @Override
    public String getDump() {
        return "";
    }

    @Override
    public String format(Formatter visitor) {
        return visitor.visit(this);
    }
}

