/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.workingmemory.elements;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jamocha.communication.logging.Logging;
import org.jamocha.engine.Engine;
import org.jamocha.engine.EqualityIndex;
import org.jamocha.engine.TemporalValidity;
import org.jamocha.engine.configurations.SlotConfiguration;
import org.jamocha.engine.nodes.FactTuple;
import org.jamocha.engine.nodes.FactTupleImpl;
import org.jamocha.engine.workingmemory.elements.Fact;
import org.jamocha.engine.workingmemory.elements.JavaTemplate;
import org.jamocha.engine.workingmemory.elements.Template;
import org.jamocha.engine.workingmemory.elements.TemplateSlot;
import org.jamocha.engine.workingmemory.elements.tags.Tag;
import org.jamocha.engine.workingmemory.elements.tags.TagIterator;
import org.jamocha.formatter.Formatter;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.JamochaValue;
import org.jamocha.parser.ParserFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaFact
implements Fact {
    private Object o;
    private EqualityIndex eqIndex;
    private List<Tag> tags;
    private long timestamp;
    private long id;
    private Engine e;
    private Template t;

    public static String upperCaseFirstLetter(String s) {
        if (s.length() == 0) {
            return s;
        }
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    public JavaFact(Object o, Engine e) {
        this.o = o;
        this.e = e;
        this.tags = new ArrayList<Tag>();
        this.timestamp = System.nanoTime();
        this.id = -1L;
        this.t = null;
        this.getTemplate();
    }

    @Override
    public void addTag(Tag t) {
        this.tags.add(t);
    }

    @Override
    public void clear() {
        this.o = null;
        this.tags.clear();
        this.tags = null;
    }

    @Override
    public EqualityIndex equalityIndex() {
        if (this.eqIndex == null) {
            this.eqIndex = new EqualityIndex(this);
        }
        return this.eqIndex;
    }

    @Override
    public long getCreationTimeStamp() {
        return this.timestamp;
    }

    @Override
    public long getFactId() {
        return this.id;
    }

    @Override
    public int getSlotId(String name) {
        int i = 0;
        for (TemplateSlot ts : this.t.getAllSlots()) {
            if (ts.getName().equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public JamochaValue getSlotValue(int id) throws EvaluationException {
        Template tmpl = this.getTemplate();
        String name = tmpl.getSlot(id).getName();
        return this.getSlotValue(name);
    }

    @Override
    public JamochaValue getSlotValue(String name) throws EvaluationException {
        Object res = null;
        try {
            res = this.getSlotValue2(name, "get");
        }
        catch (NoSuchMethodException e) {
            try {
                res = this.getSlotValue2(name, "is");
            }
            catch (NoSuchMethodException e1) {
                Logging.logger(this.getClass()).warn(e1);
            }
        }
        return JamochaValue.newValueAutoType(res);
    }

    protected Object getSlotValue2(String name, String prefix) throws EvaluationException, NoSuchMethodException {
        String fname = JavaFact.upperCaseFirstLetter(name);
        try {
            Method m = this.o.getClass().getMethod(prefix + fname, new Class[0]);
            return m.invoke(this.o, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            Logging.logger(this.getClass()).warn(e);
        }
        catch (IllegalAccessException e) {
            Logging.logger(this.getClass()).warn(e);
        }
        catch (InvocationTargetException e) {
            Logging.logger(this.getClass()).warn(e);
        }
        return null;
    }

    @Override
    public Iterator<Tag> getTags() {
        return this.tags.iterator();
    }

    @Override
    public Iterator<Tag> getTags(Class<Tag> tagClass) {
        return new TagIterator(tagClass, this.tags);
    }

    @Override
    public Template getTemplate() {
        if (this.t != null) {
            return this.t;
        }
        this.t = this.e.findTemplate(this.o.getClass().getCanonicalName());
        if (this.t == null) {
            this.t = new JavaTemplate(this.o.getClass());
            try {
                this.e.addTemplate(this.t);
            }
            catch (EvaluationException e1) {
                Logging.logger(this.getClass()).warn(e1);
                Logging.logger(this.getClass()).warn("error while adding new template for '" + this.o.getClass().getCanonicalName() + "'");
            }
        }
        return this.t;
    }

    @Override
    public TemporalValidity getTemporalValidity() {
        return null;
    }

    @Override
    public boolean isSlotSilent(int idx) {
        return false;
    }

    @Override
    public boolean isSlotSilent(String slotName) {
        return false;
    }

    @Override
    public void setFactId(long id) {
        this.id = id;
    }

    @Override
    public void setTemporalValidity(TemporalValidity val) {
    }

    protected void setSlotValue(String slotName, Object value) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method getter = this.o.getClass().getMethod("get" + JavaFact.upperCaseFirstLetter(slotName), new Class[0]);
        Class<Number> returnType = getter.getReturnType();
        Method setter = this.o.getClass().getMethod("set" + JavaFact.upperCaseFirstLetter(slotName), returnType);
        Logging.logger(this.getClass()).debug("Trying to set a " + value.getClass().getCanonicalName() + " with a setter, which receives " + returnType.getCanonicalName());
        if (returnType.isAssignableFrom(Integer.TYPE) || returnType.isAssignableFrom(Integer.class)) {
            Logging.logger(this.getClass()).warn("Internally Jamocha uses LONG for integer numbers. Now we have to put a LONG value into a INT attribute! It is recommended to use LONG for the attribute '" + slotName + "'");
            value = (int)((Long)value).longValue();
        }
        if (returnType.isAssignableFrom(Float.TYPE) || returnType.isAssignableFrom(Float.class)) {
            Logging.logger(this.getClass()).warn("Internally Jamocha uses DOUBLE for floating point numbers. Now we have to put a DOUBLE value into a FLOAT attribute! It is recommended to use DOUBLE for the attribute '" + slotName + "'");
            value = Float.valueOf((float)((Double)value).doubleValue());
        }
        setter.invoke(this.o, value);
    }

    @Override
    public void updateSlots(Engine engine, SlotConfiguration[] slots) throws EvaluationException {
        for (SlotConfiguration slot : slots) {
            try {
                this.setSlotValue(slot.getSlotName(), slot.getSlotValues()[0].getValue(engine).getObjectValue());
            }
            catch (Exception e) {
                throw new EvaluationException(e);
            }
        }
    }

    @Override
    public FactTuple getFactTuple() {
        return new FactTupleImpl(this);
    }

    @Override
    public Fact getFirstFact() {
        return this;
    }

    @Override
    public Fact getLastFact() {
        return this;
    }

    @Override
    public boolean isStandaloneFact() {
        return true;
    }

    @Override
    public String format(Formatter visitor) {
        return visitor.visit(this);
    }

    @Override
    public String getDump() {
        return "";
    }

    public Object getObject() {
        return this.o;
    }

    @Override
    public String toString() {
        return this.format(ParserFactory.getFormatter(true));
    }
}

