/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.workingmemory.elements;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jamocha.communication.logging.Logging;
import org.jamocha.engine.BoundParam;
import org.jamocha.engine.ConstraintViolationException;
import org.jamocha.engine.Engine;
import org.jamocha.engine.EqualityIndex;
import org.jamocha.engine.TemporalValidity;
import org.jamocha.engine.configurations.SlotConfiguration;
import org.jamocha.engine.nodes.FactTuple;
import org.jamocha.engine.nodes.FactTupleImpl;
import org.jamocha.engine.workingmemory.elements.Deftemplate;
import org.jamocha.engine.workingmemory.elements.Fact;
import org.jamocha.engine.workingmemory.elements.Slot;
import org.jamocha.engine.workingmemory.elements.Template;
import org.jamocha.engine.workingmemory.elements.TemplateSlot;
import org.jamocha.engine.workingmemory.elements.tags.Tag;
import org.jamocha.engine.workingmemory.elements.tags.TagIterator;
import org.jamocha.formatter.Formatter;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;
import org.jamocha.parser.ParserFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Deffact
implements Fact {
    protected List<Tag> tags;
    private static final long serialVersionUID = 1L;
    protected Template template = null;
    protected Slot[] slots = null;
    protected Slot[] boundSlots = null;
    protected long id = -1L;
    private long timeStamp;
    protected boolean hasBinding = false;
    private EqualityIndex Eindex = null;
    private TemporalValidity temporalValidity;

    @Override
    public TemporalValidity getTemporalValidity() {
        return this.temporalValidity;
    }

    @Override
    public void setTemporalValidity(TemporalValidity temporalValidity) {
        this.temporalValidity = temporalValidity;
    }

    public Deffact(Template template, Slot[] values) {
        this.template = template;
        this.slots = values;
        this.timeStamp = System.nanoTime();
        this.tags = new ArrayList<Tag>();
    }

    public Deffact(String factdef, Engine e) {
        String[] split = factdef.split(";");
        String templateName = split[0];
        HashMap<String, String> slots = new HashMap<String, String>();
        for (int i = 1; i < split.length; ++i) {
            String field = split[i];
            String[] foo = field.split("=");
            String name = foo[0];
            String value = foo[1];
            slots.put(name, value);
        }
        TemplateSlot[] tslotArr = new TemplateSlot[slots.keySet().size()];
        Slot[] slotArr = new Slot[slots.keySet().size()];
        int i = 0;
        for (String key : slots.keySet()) {
            tslotArr[i++] = new TemplateSlot(key);
        }
        Deftemplate t = new Deftemplate(templateName, templateName, tslotArr);
        try {
            e.addTemplate(t);
        }
        catch (EvaluationException e1) {
            Logging.logger(this.getClass()).fatal(e1);
        }
        try {
            i = 0;
            for (String key : slots.keySet()) {
                slotArr[i] = tslotArr[i].createSlot(e);
                slotArr[i].setValue(JamochaValue.newString((String)slots.get(key)));
                ++i;
            }
        }
        catch (ConstraintViolationException e1) {
            Logging.logger(this.getClass()).fatal(e1);
        }
        catch (EvaluationException e2) {
            Logging.logger(this.getClass()).fatal(e2);
        }
        this.template = t;
        this.slots = slotArr;
        this.timeStamp = System.nanoTime();
        this.tags = new ArrayList<Tag>();
    }

    public boolean hasBinding() {
        return this.hasBinding;
    }

    public void resolveValues(Engine engine, Fact[] triggerFacts) {
        for (int idx = 0; idx < this.boundSlots.length; ++idx) {
            if (this.boundSlots[idx].getValue().getType() == JamochaType.LIST) {
                JamochaValue mvals = this.boundSlots[idx].getValue();
                for (int mdx = 0; mdx < mvals.getListCount(); ++mdx) {
                    JamochaValue jv = mvals.getListValue(mdx);
                    BoundParam bp = (BoundParam)jv.getObjectValue();
                    bp.setResolvedValue(engine.getBinding(bp.getVariableName()));
                }
                continue;
            }
            if (!this.boundSlots[idx].value.getType().equals((Object)JamochaType.BINDING)) continue;
            BoundParam bp = (BoundParam)this.boundSlots[idx].value.getObjectValue();
            if (bp.getColumn() > -1) {
                bp.setFact(triggerFacts);
                continue;
            }
            bp.setResolvedValue(engine.getBinding(bp.getVariableName()));
        }
    }

    @Override
    public JamochaValue getSlotValue(int id) throws EvaluationException {
        try {
            return this.slots[id].value;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            String templName = null;
            if (this.template != null) {
                templName = this.template.getName();
            }
            throw new EvaluationException("Error in getSlotValue, Template: " + templName + " Index does not exist: " + id, e);
        }
    }

    @Override
    public JamochaValue getSlotValue(String name) throws EvaluationException {
        int col = this.getSlotId(name);
        if (col != -1) {
            return this.getSlotValue(col);
        }
        return null;
    }

    @Override
    public int getSlotId(String name) {
        int col = -1;
        for (int idx = 0; idx < this.slots.length; ++idx) {
            if (!this.slots[idx].getName().equals(name)) continue;
            col = idx;
            break;
        }
        return col;
    }

    @Override
    public String toString() {
        return this.format(ParserFactory.getFormatter(true));
    }

    @Override
    public EqualityIndex equalityIndex() {
        if (this.Eindex == null) {
            this.Eindex = new EqualityIndex(this);
        }
        return this.Eindex;
    }

    public int hashCode() {
        int hash = 0;
        for (int idx = 0; idx < this.slots.length; ++idx) {
            hash += this.slots[idx].getName().hashCode() + this.slots[idx].value.hashCode();
        }
        return hash;
    }

    @Override
    public long getFactId() {
        return this.id;
    }

    @Override
    public void setFactId(long id) {
        this.id = id;
    }

    protected void resetID(Fact fact) {
        this.id = fact.getFactId();
    }

    @Override
    public void updateSlots(Engine engine, SlotConfiguration[] slotConfigs) throws EvaluationException {
        SlotConfiguration slotConfig = null;
        JamochaValue newValue = null;
        for (int idx = 0; idx < slotConfigs.length; ++idx) {
            slotConfig = slotConfigs[idx];
            this.slots[this.getSlotId((String)slotConfig.getSlotName())].value = newValue = slotConfig.getValue(engine);
        }
    }

    @Override
    public Template getTemplate() {
        return this.template;
    }

    @Override
    public final long getCreationTimeStamp() {
        return this.timeStamp;
    }

    public boolean equals(Object object) {
        if (object instanceof Fact) {
            Fact fact = (Fact)object;
            if (!fact.getTemplate().equals(this.getTemplate())) {
                return false;
            }
            boolean eq = true;
            try {
                for (int idx = 0; idx < this.slots.length; ++idx) {
                    if (this.slots[idx].value.equals(fact.getSlotValue(idx))) continue;
                    eq = false;
                    break;
                }
            }
            catch (EvaluationException e) {
                e.printStackTrace();
            }
            return eq;
        }
        return false;
    }

    public Deffact cloneFact(Engine engine) {
        Deffact newfact = new Deffact(this.template, this.cloneAllSlots());
        Slot[] slts = newfact.slots;
        for (int idx = 0; idx < slts.length; ++idx) {
            if (this.slots[idx].getValue().getType() == JamochaType.LIST) {
                JamochaValue mval = this.slots[idx].getValue();
                JamochaValue[] rvals = new JamochaValue[mval.getListCount()];
                for (int mdx = 0; mdx < mval.getListCount(); ++mdx) {
                    JamochaValue v2 = mval.getListValue(mdx);
                    if (v2.getType().equals((Object)JamochaType.BINDING)) {
                        try {
                            rvals[mdx] = JamochaValue.newObject(((BoundParam)v2.getObjectValue()).getValue(engine));
                        }
                        catch (EvaluationException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    rvals[mdx] = v2;
                }
                slts[idx].value = JamochaValue.newList(rvals);
                continue;
            }
            if (this.slots[idx].value.getType().equals((Object)JamochaType.BINDING)) {
                try {
                    slts[idx].value = ((BoundParam)this.slots[idx].value.getObjectValue()).getValue(engine);
                }
                catch (EvaluationException e) {
                    e.printStackTrace();
                }
                continue;
            }
            slts[idx].value = this.slots[idx].value;
        }
        return newfact;
    }

    private Slot[] cloneAllSlots() {
        Slot[] cloned = new Slot[this.slots.length];
        for (int idx = 0; idx < cloned.length; ++idx) {
            cloned[idx] = (Slot)this.slots[idx].clone();
        }
        return cloned;
    }

    @Override
    public void clear() {
        this.template = null;
        this.slots = null;
        this.id = 0L;
        this.timeStamp = 0L;
    }

    @Override
    public boolean isSlotSilent(int idx) {
        return this.slots[idx].silent;
    }

    @Override
    public boolean isSlotSilent(String slotName) {
        return this.slots[this.getSlotId((String)slotName)].silent;
    }

    @Override
    public String format(Formatter visitor) {
        return visitor.visit(this);
    }

    @Override
    public FactTuple getFactTuple() {
        FactTupleImpl tuple = new FactTupleImpl(this);
        return tuple;
    }

    @Override
    public Fact getFirstFact() {
        return this;
    }

    @Override
    public Fact getLastFact() {
        return this;
    }

    @Override
    public boolean isStandaloneFact() {
        return true;
    }

    @Override
    public Iterator<Tag> getTags() {
        return this.getTags(Tag.class);
    }

    @Override
    public void addTag(Tag t) {
        this.tags.add(t);
    }

    @Override
    public Iterator<Tag> getTags(Class<Tag> tagClass) {
        return new TagIterator(tagClass, this.tags);
    }

    @Override
    public String getDump() {
        return this.toString();
    }
}

