/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.workingmemory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jamocha.engine.nodes.Node;
import org.jamocha.engine.workingmemory.WorkingMemory;
import org.jamocha.engine.workingmemory.WorkingMemoryElement;
import org.jamocha.engine.workingmemory.WorkingMemoryListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkingMemoryImpl
implements WorkingMemory {
    private static WorkingMemoryImpl instance;
    private final Map<Node, Set<WorkingMemoryElement>> mem;
    protected List<WorkingMemoryListener> listeners = new ArrayList<WorkingMemoryListener>();

    private Set<WorkingMemoryElement> getList(Map<Node, Set<WorkingMemoryElement>> map, Node node) {
        Set<WorkingMemoryElement> l = map.get(node);
        if (l == null) {
            l = new HashSet<WorkingMemoryElement>();
            map.put(node, l);
        }
        return l;
    }

    private boolean addTo(Map<Node, Set<WorkingMemoryElement>> map, Node node, WorkingMemoryElement element) {
        Set<WorkingMemoryElement> l = this.getList(map, node);
        return l.add(element);
    }

    private boolean removeFrom(Map<Node, Set<WorkingMemoryElement>> map, Node node, WorkingMemoryElement element) {
        Set<WorkingMemoryElement> l = this.getList(map, node);
        return l.remove(element);
    }

    public static WorkingMemoryImpl getWorkingMemory() {
        if (instance == null) {
            instance = new WorkingMemoryImpl();
        }
        return instance;
    }

    private WorkingMemoryImpl() {
        this.mem = new HashMap<Node, Set<WorkingMemoryElement>>();
    }

    @Override
    public void addWorkingMemoryListener(WorkingMemoryListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public boolean add(Node owner, WorkingMemoryElement element) {
        boolean result = this.addTo(this.mem, owner, element);
        for (WorkingMemoryListener l : this.listeners) {
            l.added(element);
        }
        return result;
    }

    @Override
    public boolean remove(Node owner, WorkingMemoryElement element) {
        boolean result = this.removeFrom(this.mem, owner, element);
        for (WorkingMemoryListener l : this.listeners) {
            l.removed(element);
        }
        return result;
    }

    @Override
    public void clear() {
        this.mem.clear();
    }

    @Override
    public Iterable<WorkingMemoryElement> getMemory(Node owner) {
        return this.getList(this.mem, owner);
    }

    @Override
    public int size(Node owner) {
        return this.getList(this.mem, owner).size();
    }
}

