/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.scope;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jamocha.engine.scope.AbstractScope;
import org.jamocha.parser.JamochaValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultScope
extends AbstractScope {
    @Override
    public JamochaValue getBindingValue(String name) {
        if (this.values.containsKey(name)) {
            return (JamochaValue)this.values.get(name);
        }
        if (this.outerScope != null) {
            return this.outerScope.getBindingValue(name);
        }
        return null;
    }

    @Override
    public void setBindingValue(String name, JamochaValue value) {
        if (this.values.containsKey(name) || !this.hasBindingInTotalRange(name)) {
            this.values.put(name, value);
        } else {
            this.outerScope.setBindingValue(name, value);
        }
    }

    @Override
    public boolean hasBindingInTotalRange(String name) {
        if (this.values.containsKey(name)) {
            return true;
        }
        if (this.outerScope != null) {
            return this.outerScope.hasBindingInTotalRange(name);
        }
        return false;
    }

    @Override
    public Map<String, JamochaValue> getBindings() {
        HashMap<String, JamochaValue> result = new HashMap<String, JamochaValue>();
        if (this.outerScope != null) {
            Map<String, JamochaValue> outerBindings = this.outerScope.getBindings();
            Set<String> keys = outerBindings.keySet();
            for (String key : keys) {
                result.put(key, outerBindings.get(key));
            }
        }
        Set keys = this.values.keySet();
        for (String key : keys) {
            result.put(key, (JamochaValue)this.values.get(key));
        }
        return result;
    }
}

