/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.rules.rulecompiler.beffy;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.jamocha.communication.logging.Logging;
import org.jamocha.engine.BoundParam;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.configurations.Signature;
import org.jamocha.rules.AndCondition;
import org.jamocha.rules.AndConnectedConstraint;
import org.jamocha.rules.BoundConstraint;
import org.jamocha.rules.Condition;
import org.jamocha.rules.ConditionWithNested;
import org.jamocha.rules.Constraint;
import org.jamocha.rules.LiteralConstraint;
import org.jamocha.rules.ObjectCondition;
import org.jamocha.rules.OrCondition;
import org.jamocha.rules.OrConnectedConstraint;
import org.jamocha.rules.PredicateConstraint;
import org.jamocha.rules.TestCondition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeffyRuleOptimizerPassZero {
    public Condition optimize(List<Condition> cons) {
        ObjectCondition oc;
        ConditionWithNested cwn;
        Condition act;
        AndCondition bigMasterAnd = new AndCondition();
        for (Condition c : cons) {
            bigMasterAnd.addNestedCondition(c);
        }
        Stack<Condition> conditionStack = new Stack<Condition>();
        conditionStack.addAll(cons);
        block1: while (!conditionStack.isEmpty()) {
            act = (Condition)conditionStack.pop();
            if (act instanceof ConditionWithNested) {
                cwn = (ConditionWithNested)act;
                for (Condition child : cwn.getNestedConditions()) {
                    conditionStack.push(child);
                }
                continue;
            }
            if (!(act instanceof ObjectCondition)) continue;
            oc = (ObjectCondition)act;
            for (Constraint constr : oc.getConstraints()) {
                if (!(constr instanceof OrConnectedConstraint)) continue;
                List<Constraint> insides = this.flatOr((OrConnectedConstraint)constr);
                OrCondition newOrCond = new OrCondition();
                for (Constraint i : insides) {
                    ObjectCondition noc = oc.clone();
                    boolean s = noc.replaceConstraint(constr, i);
                    if (!s) {
                        Logging.logger(this.getClass()).fatal("Internal error in RuleOptimizer: cannot replace a constraint " + constr.getClass().getSimpleName());
                    }
                    newOrCond.addNestedCondition(noc);
                }
                conditionStack.add(newOrCond);
                ConditionWithNested parent = oc.getParentCondition();
                parent.replaceNestedCondition(oc, newOrCond);
                continue block1;
            }
        }
        conditionStack = new Stack();
        conditionStack.add(bigMasterAnd);
        block5: while (!conditionStack.isEmpty()) {
            act = (Condition)conditionStack.pop();
            if (act instanceof ConditionWithNested) {
                cwn = (ConditionWithNested)act;
                for (Condition child : cwn.getNestedConditions()) {
                    conditionStack.push(child);
                }
                continue;
            }
            if (!(act instanceof ObjectCondition)) continue;
            oc = (ObjectCondition)act;
            ConditionWithNested parent = oc.getParentCondition();
            for (Constraint constr : oc.getConstraints()) {
                if (!(constr instanceof AndConnectedConstraint)) continue;
                List<Constraint> insides = this.flatAnd((AndConnectedConstraint)constr);
                AndCondition newAndCond = new AndCondition();
                BoundConstraint vari = null;
                for (Constraint c : insides) {
                    if (!(c instanceof BoundConstraint)) continue;
                    vari = (BoundConstraint)c;
                    break;
                }
                assert (vari != null);
                newAndCond.addNestedCondition(oc);
                oc.replaceConstraint(constr, vari);
                for (Constraint ot : insides) {
                    if (ot == vari) continue;
                    if (ot instanceof LiteralConstraint) {
                        ArrayList<Parameter> params = new ArrayList<Parameter>();
                        params.add(ot.getValue());
                        BoundParam variParam = new BoundParam(vari.getConstraintName());
                        params.add(variParam);
                        Signature sign = new Signature();
                        sign.setSignatureName("eq");
                        sign.setParameters(params);
                        TestCondition tc = new TestCondition(sign);
                        newAndCond.addNestedCondition(tc);
                        continue;
                    }
                    if (ot instanceof PredicateConstraint) {
                        PredicateConstraint pred = (PredicateConstraint)ot;
                        Signature sign = new Signature(pred.getFunctionName());
                        sign.setParameters(pred.getParameters());
                        TestCondition tc = new TestCondition(sign);
                        newAndCond.addNestedCondition(tc);
                        continue;
                    }
                    Logging.logger(this.getClass()).fatal("unable to handle " + ot.getClass().getSimpleName() + " inside a connective-constraint!");
                }
                conditionStack.add(newAndCond);
                parent.replaceNestedCondition(oc, newAndCond);
                continue block5;
            }
        }
        return bigMasterAnd;
    }

    private List<Constraint> flatOr(OrConnectedConstraint constr) {
        ArrayList<Constraint> result = new ArrayList<Constraint>();
        Stack<Constraint> stack = new Stack<Constraint>();
        stack.add(constr);
        while (!stack.isEmpty()) {
            Constraint c = (Constraint)stack.pop();
            if (c instanceof OrConnectedConstraint) {
                OrConnectedConstraint andcc = (OrConnectedConstraint)c;
                stack.add(andcc.getLeft());
                stack.add(andcc.getRight());
                continue;
            }
            result.add(c.clone());
        }
        return result;
    }

    private List<Constraint> flatAnd(AndConnectedConstraint constr) {
        ArrayList<Constraint> result = new ArrayList<Constraint>();
        Stack<Constraint> stack = new Stack<Constraint>();
        stack.add(constr);
        while (!stack.isEmpty()) {
            Constraint c = (Constraint)stack.pop();
            if (c instanceof AndConnectedConstraint) {
                AndConnectedConstraint andcc = (AndConnectedConstraint)c;
                stack.add(andcc.getLeft());
                stack.add(andcc.getRight());
                continue;
            }
            result.add(c.clone());
        }
        return result;
    }
}

