/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.rules.rulecompiler.beffy;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jamocha.engine.rules.rulecompiler.beffy.BeffyRuleOptimizerDataPassThree;
import org.jamocha.engine.rules.rulecompiler.beffy.OptimizeRuleException;
import org.jamocha.rules.AndCondition;
import org.jamocha.rules.AndConnectedConstraint;
import org.jamocha.rules.BoundConstraint;
import org.jamocha.rules.Condition;
import org.jamocha.rules.ConditionVisitor;
import org.jamocha.rules.Constraint;
import org.jamocha.rules.ConstraintVisitor;
import org.jamocha.rules.ExistsCondition;
import org.jamocha.rules.LiteralConstraint;
import org.jamocha.rules.NotExistsCondition;
import org.jamocha.rules.ObjectCondition;
import org.jamocha.rules.OrCondition;
import org.jamocha.rules.OrConnectedConstraint;
import org.jamocha.rules.OrderedFactConstraint;
import org.jamocha.rules.PredicateConstraint;
import org.jamocha.rules.ReturnValueConstraint;
import org.jamocha.rules.TestCondition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeffyRuleOptimizerPassThree
implements ConditionVisitor<Object, BeffyRuleOptimizerDataPassThree>,
ConstraintVisitor<Object, BeffyRuleOptimizerDataPassThree> {
    public Condition optimize(Condition cond) throws OptimizeRuleException {
        if (!(cond instanceof OrCondition)) {
            throw new OptimizeRuleException("Invalid root in condition tree. Tried to use PassThree without PassOne and PassTwo?");
        }
        OrCondition orCondition = (OrCondition)cond;
        OrCondition newCondition = new OrCondition();
        for (Condition condition : orCondition.getNestedConditions()) {
            if (condition instanceof AndCondition) {
                condition = this.optimizeAnd((AndCondition)condition);
            } else if (!(condition instanceof ObjectCondition)) {
                throw new OptimizeRuleException("Invalid condition directly below root in condition tree. Tried to use PassThree without PassOne and PassTwo?");
            }
            if (condition == null) continue;
            newCondition.addNestedCondition(condition);
        }
        return newCondition;
    }

    private boolean combine(Set<BeffyRuleOptimizerDataPassThree> set, int i, ArrayList<BeffyRuleOptimizerDataPassThree> newBindings, int newBindingsPos, List<BeffyRuleOptimizerDataPassThree> oldBindings, List<BeffyRuleOptimizerDataPassThree> veryNewBindings) {
        if (i == 0) {
            BeffyRuleOptimizerDataPassThree res = BeffyRuleOptimizerDataPassThree.combine(set);
            if (res.isBound()) {
                oldBindings.removeAll(set);
                AndCondition and = new AndCondition();
                for (BeffyRuleOptimizerDataPassThree d : set) {
                    and.addNestedCondition(d.getCondition());
                }
                res.setCondition(and);
                veryNewBindings.add(res);
                return true;
            }
            return false;
        }
        for (BeffyRuleOptimizerDataPassThree d : oldBindings) {
            set.add(d);
            if (this.combine(set, i - 1, newBindings, newBindingsPos, oldBindings, veryNewBindings)) {
                return true;
            }
            set.remove(d);
        }
        for (int j = newBindingsPos; j < newBindings.size(); ++j) {
            BeffyRuleOptimizerDataPassThree d;
            d = newBindings.get(j);
            set.add(d);
            if (this.combine(set, i - 1, newBindings, j + 1, oldBindings, veryNewBindings)) {
                newBindings.remove(j);
                return true;
            }
            set.remove(d);
        }
        return false;
    }

    private Condition optimizeAnd(AndCondition cond) throws OptimizeRuleException {
        ArrayList<BeffyRuleOptimizerDataPassThree> newBindings = new ArrayList<BeffyRuleOptimizerDataPassThree>();
        for (Condition condition : cond.getNestedConditions()) {
            BeffyRuleOptimizerDataPassThree d = condition.acceptVisitor(this, null);
            if (d == null) {
                throw new OptimizeRuleException("Invalid element in AndCondition. Tried to use PassThree without PassOne and PassTwo?");
            }
            d.setCondition(condition);
            newBindings.add(d);
        }
        LinkedList<BeffyRuleOptimizerDataPassThree> oldBindings = new LinkedList<BeffyRuleOptimizerDataPassThree>();
        ArrayList<BeffyRuleOptimizerDataPassThree> veryNewBindings = new ArrayList<BeffyRuleOptimizerDataPassThree>();
        int i = 2;
        while (oldBindings.size() > 1 || !newBindings.isEmpty()) {
            int j = 0;
            while (j < newBindings.size()) {
                BeffyRuleOptimizerDataPassThree numberOne = (BeffyRuleOptimizerDataPassThree)newBindings.get(j);
                HashSet<BeffyRuleOptimizerDataPassThree> set = new HashSet<BeffyRuleOptimizerDataPassThree>();
                set.add(numberOne);
                if (this.combine(set, i - 1, newBindings, j + 1, oldBindings, veryNewBindings)) {
                    newBindings.remove(j);
                    continue;
                }
                ++j;
            }
            oldBindings.addAll(newBindings);
            newBindings = veryNewBindings;
            if (newBindings.isEmpty()) {
                ++i;
            }
            veryNewBindings = new ArrayList();
        }
        if (oldBindings.isEmpty()) {
            return null;
        }
        return ((BeffyRuleOptimizerDataPassThree)oldBindings.get(0)).getCondition();
    }

    @Override
    public BeffyRuleOptimizerDataPassThree visit(AndCondition c, Object data) {
        return null;
    }

    @Override
    public BeffyRuleOptimizerDataPassThree visit(ExistsCondition c, Object data) {
        if (c.getNestedConditions().size() != 1) {
            return null;
        }
        return c.getNestedConditions().get(0).acceptVisitor(this, null);
    }

    @Override
    public BeffyRuleOptimizerDataPassThree visit(NotExistsCondition c, Object data) {
        if (c.getNestedConditions().size() != 1) {
            return null;
        }
        BeffyRuleOptimizerDataPassThree d = c.getNestedConditions().get(0).acceptVisitor(this, null);
        d.markUnbound();
        return d;
    }

    @Override
    public BeffyRuleOptimizerDataPassThree visit(ObjectCondition c, Object data) {
        BeffyRuleOptimizerDataPassThree d = new BeffyRuleOptimizerDataPassThree();
        for (Constraint constraint : c.getConstraints()) {
            d.combine(constraint.acceptVisitor(this, null));
        }
        return d;
    }

    @Override
    public BeffyRuleOptimizerDataPassThree visit(OrCondition c, Object data) {
        return null;
    }

    @Override
    public BeffyRuleOptimizerDataPassThree visit(TestCondition c, Object data) {
        BeffyRuleOptimizerDataPassThree d = new BeffyRuleOptimizerDataPassThree();
        for (Constraint constraint : c.getConstraints()) {
            d.combine(constraint.acceptVisitor(this, null));
        }
        d.markUnbound();
        return d;
    }

    @Override
    public BeffyRuleOptimizerDataPassThree visit(AndConnectedConstraint c, Object data) {
        BeffyRuleOptimizerDataPassThree d = c.getLeft().acceptVisitor(this, null);
        d.combine(c.getRight().acceptVisitor(this, null));
        return d;
    }

    @Override
    public BeffyRuleOptimizerDataPassThree visit(BoundConstraint c, Object data) {
        BeffyRuleOptimizerDataPassThree d = new BeffyRuleOptimizerDataPassThree();
        d.add(c.getConstraintName(), c.isNegated());
        return d;
    }

    @Override
    public BeffyRuleOptimizerDataPassThree visit(LiteralConstraint c, Object data) {
        return new BeffyRuleOptimizerDataPassThree();
    }

    @Override
    public BeffyRuleOptimizerDataPassThree visit(OrConnectedConstraint c, Object data) {
        return null;
    }

    @Override
    public BeffyRuleOptimizerDataPassThree visit(OrderedFactConstraint c, Object data) {
        BeffyRuleOptimizerDataPassThree d = new BeffyRuleOptimizerDataPassThree();
        for (Constraint constraint : c.getConstraints()) {
            d.combine(constraint.acceptVisitor(this, null));
        }
        return d;
    }

    @Override
    public BeffyRuleOptimizerDataPassThree visit(PredicateConstraint c, Object data) {
        return new BeffyRuleOptimizerDataPassThree();
    }

    @Override
    public BeffyRuleOptimizerDataPassThree visit(ReturnValueConstraint c, Object data) {
        return new BeffyRuleOptimizerDataPassThree();
    }
}

