/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.rules.rulecompiler.beffy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jamocha.communication.events.CompileEvent;
import org.jamocha.communication.events.CompilerListener;
import org.jamocha.communication.logging.Logging;
import org.jamocha.engine.AssertException;
import org.jamocha.engine.Binding;
import org.jamocha.engine.BoundParam;
import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.ReteNet;
import org.jamocha.engine.RuleCompiler;
import org.jamocha.engine.configurations.Signature;
import org.jamocha.engine.functions.Function;
import org.jamocha.engine.nodes.AbstractBetaFilterNode;
import org.jamocha.engine.nodes.AlphaQuantorDistinctionNode;
import org.jamocha.engine.nodes.AlphaSlotComparatorNode;
import org.jamocha.engine.nodes.LeftInputAdaptorNode;
import org.jamocha.engine.nodes.MultiBetaJoinNode;
import org.jamocha.engine.nodes.Node;
import org.jamocha.engine.nodes.NodeException;
import org.jamocha.engine.nodes.ObjectTypeNode;
import org.jamocha.engine.nodes.OneInputNode;
import org.jamocha.engine.nodes.RootNode;
import org.jamocha.engine.nodes.SimpleBetaFilterNode;
import org.jamocha.engine.nodes.SlotFilterNode;
import org.jamocha.engine.nodes.TerminalNode;
import org.jamocha.engine.nodes.joinfilter.GeneralizedFieldComparator;
import org.jamocha.engine.nodes.joinfilter.GeneralizedFunctionEvaluator;
import org.jamocha.engine.nodes.joinfilter.LeftFieldAddress;
import org.jamocha.engine.rules.rulecompiler.CompileRuleException;
import org.jamocha.engine.rules.rulecompiler.beffy.BeffyRuleOptimizer;
import org.jamocha.engine.rules.rulecompiler.beffy.OptimizeRuleException;
import org.jamocha.engine.util.MutableInteger;
import org.jamocha.engine.workingmemory.elements.Slot;
import org.jamocha.engine.workingmemory.elements.Template;
import org.jamocha.engine.workingmemory.elements.TemplateSlot;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;
import org.jamocha.parser.ParserFactory;
import org.jamocha.parser.RuleException;
import org.jamocha.rules.AndCondition;
import org.jamocha.rules.BoundConstraint;
import org.jamocha.rules.Condition;
import org.jamocha.rules.ConditionVisitor;
import org.jamocha.rules.Constraint;
import org.jamocha.rules.Defrule;
import org.jamocha.rules.ExistsCondition;
import org.jamocha.rules.LiteralConstraint;
import org.jamocha.rules.NotExistsCondition;
import org.jamocha.rules.ObjectCondition;
import org.jamocha.rules.OrCondition;
import org.jamocha.rules.Rule;
import org.jamocha.rules.TestCondition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeffyRuleCompiler
implements RuleCompiler {
    private Map<Rule, TerminalNode> terminalNodes;
    private ObjectTypeNodeManager objectTypeNodes;
    private BindingManager bindings;
    private List<CompilerListener> listeners;
    private Engine engine;
    private int pad = 1;
    private RootNode rootNode;
    private ReteNet reteNet;
    private BeffyRuleOptimizer ruleOptimizer;

    private List<Parameter> substituteBoundParamsForFunctionCall(Parameter[] original, CompileTableau tableau) {
        ArrayList<Parameter> result = new ArrayList<Parameter>();
        for (Parameter p : original) {
            if (p instanceof BoundParam) {
                BoundParam bp = (BoundParam)p;
                Binding bnd = this.bindings.getBinding(tableau.getRule(), bp.getVariableName(), tableau.getCurrentFocus());
                LeftFieldAddress fa = bnd.isWholeFactBinding() ? new LeftFieldAddress(bnd.getTupleIndex()) : new LeftFieldAddress(bnd.getTupleIndex(), bnd.getSlotIndex());
                result.add(fa);
                continue;
            }
            if (p instanceof JamochaValue) {
                result.add(p);
                continue;
            }
            if (p instanceof Signature) {
                Signature orig = (Signature)p;
                Signature newSig = new Signature(orig.getSignatureName());
                newSig.setParameters(this.substituteBoundParamsForFunctionCall(orig.getParameters(), tableau));
                result.add(newSig);
                continue;
            }
            this.logAndFail(new CompileRuleException("parameter substitution for this type is not implemented: " + p.getClass().getCanonicalName()), null);
        }
        return result;
    }

    public BeffyRuleCompiler(Engine engine, RootNode root, ReteNet net) {
        this.engine = engine;
        this.rootNode = root;
        this.reteNet = net;
        this.listeners = new LinkedList<CompilerListener>();
        this.objectTypeNodes = new ObjectTypeNodeManager();
        this.bindings = new BindingManager();
        this.ruleOptimizer = new BeffyRuleOptimizer();
        this.terminalNodes = new HashMap<Rule, TerminalNode>();
    }

    private void logAndFail(Exception e, CompileTableau data) {
        data.setSuccess(false);
        Logging.logger(this.getClass()).warn(e);
    }

    private void log(String text, Object ... args) {
        String output = String.format(text, args);
        Logging.logger(this.getClass().getCanonicalName()).debug(output);
    }

    private int getNumber() {
        return this.pad++;
    }

    @Override
    public void addListener(CompilerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void addObjectTypeNode(Template template) {
    }

    @Override
    public boolean addRule(Rule rule) throws AssertException, RuleException, EvaluationException, CompileRuleException {
        Condition optimizedCondition;
        try {
            optimizedCondition = this.ruleOptimizer.optimize(rule.getConditions());
        }
        catch (OptimizeRuleException e1) {
            throw new CompileRuleException(e1);
        }
        rule.getConditions().clear();
        rule.getConditions().add(optimizedCondition);
        CompileTableau ruleCompileTableau = new CompileTableau(rule);
        BeffyRuleConditionVisitor visitor = new BeffyRuleConditionVisitor();
        OrCondition rootCondition = (OrCondition)rule.getConditions().get(0);
        rootCondition.acceptVisitor(visitor, ruleCompileTableau);
        if (ruleCompileTableau.hadSuccess()) {
            this.log("we had success compiling '%s', so we will activate all rules", rule.getName());
            try {
                this.rootNode.activate();
            }
            catch (NodeException e) {
                this.reteNet.cleanup();
                throw new CompileRuleException(e);
            }
            this.notifyListenersAdd(rule);
            rule.parentModule().addRule(rule);
            return true;
        }
        this.log("there were erros compiling '%s'! We will cleanup the rete network", rule.getName());
        this.reteNet.cleanup();
        return false;
    }

    @Override
    public Binding getBinding(String varName, TerminalNode focus, Rule r) {
        return this.bindings.getBinding(r, varName, focus);
    }

    @Override
    public void removeListener(CompilerListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyListenersAdd(Rule newRule) {
        CompileEvent event = new CompileEvent(this, CompileEvent.CompileEventType.RULE_ADDED);
        event.setRule(newRule);
        this.notifyListeners(event);
    }

    private void notifyListenersRemove(Rule newRule) {
        CompileEvent event = new CompileEvent(this, CompileEvent.CompileEventType.RULE_REMOVED);
        event.setRule(newRule);
        this.notifyListeners(event);
    }

    private void notifyListeners(CompileEvent ev) {
        for (CompilerListener li : this.listeners) {
            li.compileEventOccured(ev);
        }
    }

    private void slow(CompileTableau t) {
        Defrule r;
        if (t.getRule() instanceof Defrule && (r = (Defrule)t.getRule()).getSlowCompile()) {
            try {
                Thread.currentThread();
                Thread.sleep(2500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public void removeRule(Rule rule) {
        TerminalNode tnode = this.terminalNodes.get(rule);
        this.terminalNodes.remove(rule);
        for (Node parent : tnode.getParentNodes()) {
            parent.removeChild(tnode);
        }
        this.reteNet.cleanup();
        this.notifyListenersRemove(rule);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BeffyRuleConditionVisitor
    implements ConditionVisitor<CompileTableau, CompileTableau> {
        private BeffyRuleConditionVisitor() {
        }

        private boolean isAlpha(Condition c) {
            return c instanceof ObjectCondition || c instanceof ExistsCondition || c instanceof TestCondition;
        }

        @Override
        public CompileTableau visit(AndCondition c, CompileTableau data) {
            AbstractBetaFilterNode joinNode;
            int p = BeffyRuleCompiler.this.getNumber();
            BeffyRuleCompiler.this.log("(%d) i enter and-condition %d now. at first, i will handle the sub conditions...", new Object[]{p, c.hashCode()});
            for (Condition subCondition : c.getNestedConditions()) {
                subCondition.acceptVisitor(this, data);
            }
            BeffyRuleCompiler.this.log("(%d) sub conditions handled.", new Object[]{p});
            AbstractBetaFilterNode join = null;
            if (c.getNestedConditions().size() == 1) {
                BeffyRuleCompiler.this.logAndFail(new NodeException("only one subcondition in AND", null), data);
            } else if (c.getNestedConditions().size() == 2 && (this.isAlpha(c.getNestedConditions().get(0)) || this.isAlpha(c.getNestedConditions().get(1)))) {
                joinNode = new SimpleBetaFilterNode(BeffyRuleCompiler.this.engine);
                BeffyRuleCompiler.this.log("(%d) i will build a classic alpha/beta-join %d", new Object[]{p, joinNode.getId()});
                join = joinNode;
                try {
                    Condition betaCond;
                    Condition c1 = c.getNestedConditions().get(0);
                    Condition c2 = c.getNestedConditions().get(1);
                    Condition alphaCond = this.isAlpha(c1) ? c1 : c2;
                    Condition condition = betaCond = this.isAlpha(c1) ? c2 : c1;
                    if (this.isAlpha(c1) && this.isAlpha(c2)) {
                        BeffyRuleCompiler.this.log("(%d) building left-input-adaptor for condition %d, because both inputs are alpha", new Object[]{p, betaCond.hashCode()});
                        LeftInputAdaptorNode lia = new LeftInputAdaptorNode(BeffyRuleCompiler.this.engine);
                        Node n = data.getLastNode(betaCond);
                        n.addChild(lia);
                        BeffyRuleCompiler.this.slow(data);
                        data.setLastNode(betaCond, lia);
                    }
                    BeffyRuleCompiler.this.log("(%d) add new join to both subcondition's last nodes and fix the tuple indices", new Object[]{p});
                    data.getLastNode(c1).addChild(joinNode);
                    BeffyRuleCompiler.this.slow(data);
                    data.getLastNode(c2).addChild(joinNode);
                    BeffyRuleCompiler.this.slow(data);
                    MutableInteger oldIdxC1 = data.getTupleIndexFromCondition(betaCond);
                    MutableInteger oldIdxC2 = data.getTupleIndexFromCondition(alphaCond);
                    BeffyRuleCompiler.this.log("(%d) before fixing: tuple index from condition %d is %d and from %d is %d.", new Object[]{p, betaCond.hashCode(), oldIdxC1.get(), alphaCond.hashCode(), oldIdxC2.get()});
                    int res = (Integer)oldIdxC1.get() + 1;
                    oldIdxC2.set(res);
                    BeffyRuleCompiler.this.log("(%d) fixing tuple index from condition %d to %d", new Object[]{p, alphaCond.hashCode(), res});
                    BeffyRuleCompiler.this.log("(%d) set %d as corresponding join for the condition %d", new Object[]{p, joinNode.getId(), alphaCond.hashCode()});
                    data.setCorrespondingJoin(alphaCond, joinNode);
                }
                catch (NodeException e) {
                    BeffyRuleCompiler.this.logAndFail(e, data);
                }
                data.setLastNode(c, joinNode);
            } else {
                joinNode = new MultiBetaJoinNode(BeffyRuleCompiler.this.engine);
                BeffyRuleCompiler.this.log("(%d) i will build a fat join %d", new Object[]{p, joinNode.getId()});
                join = joinNode;
                for (Condition sub : c.getNestedConditions()) {
                    Node n = data.getLastNode(sub);
                    try {
                        n.addChild(joinNode);
                        BeffyRuleCompiler.this.slow(data);
                    }
                    catch (NodeException e) {
                        BeffyRuleCompiler.this.logAndFail(e, data);
                    }
                    if (!this.isAlpha(sub)) continue;
                    data.setCorrespondingJoin(sub, joinNode);
                }
                data.setLastNode(c, joinNode);
            }
            for (Condition nest : c.getNestedConditions()) {
                if (!(nest instanceof TestCondition)) continue;
                try {
                    TestCondition test = (TestCondition)nest;
                    BeffyRuleCompiler.this.log("(%d) found test condition '%s'...", new Object[]{p, test.toString()});
                    Function function = test.getFunction().lookUpFunction(BeffyRuleCompiler.this.engine);
                    List parameters = BeffyRuleCompiler.this.substituteBoundParamsForFunctionCall(test.getFunction().getParameters(), data);
                    GeneralizedFunctionEvaluator filter = new GeneralizedFunctionEvaluator(BeffyRuleCompiler.this.engine, function, parameters);
                    BeffyRuleCompiler.this.log("(%d) ...and will add it to node %d.", new Object[]{p, join.getId()});
                    join.addFilter(filter);
                }
                catch (Exception e) {
                    BeffyRuleCompiler.this.logAndFail(e, data);
                }
            }
            for (Condition nest : c.getNestedConditions()) {
                if (!(nest instanceof ObjectCondition)) continue;
                ObjectCondition oc = (ObjectCondition)nest;
                for (Constraint constr : oc.getConstraints()) {
                    if (!(constr instanceof BoundConstraint)) continue;
                    BoundConstraint bc = (BoundConstraint)constr;
                    MutableInteger tupleIdx = data.getTupleIndexFromCondition(oc);
                    Template templ = BeffyRuleCompiler.this.engine.findTemplate(oc.getTemplateName());
                    int slotIdx = bc.isFactBinding() ? -1 : templ.getSlot(bc.getSlotName()).getId();
                    Binding pivot = BeffyRuleCompiler.this.bindings.getBinding(data.getRule(), bc.getConstraintName(), data.getCurrentFocus());
                    BeffyRuleCompiler.this.log("(%d) processing bound-constraint '%s' in tuple=%d and slot=%d (pivot is tuple=%d and slot=%d)...", new Object[]{p, bc.getConstraintName(), tupleIdx.get(), slotIdx, pivot.getTupleIndex().get(), pivot.getSlotIndex()});
                    if (pivot.getSlotIndex() == slotIdx && pivot.getTupleIndex().equals(tupleIdx)) {
                        BeffyRuleCompiler.this.log("(%d) ...its the pivot element here, so do nothing.", new Object[]{p});
                        continue;
                    }
                    if (pivot.getTupleIndex().equals(tupleIdx)) {
                        BeffyRuleCompiler.this.log("(%d) ...its not the pivot, but in the same condition. construct an alpha slot comparator node for it", new Object[]{p});
                        int op = bc.isNegated() ? 10 : 9;
                        Template t1 = BeffyRuleCompiler.this.engine.findTemplate(oc.getTemplateName());
                        ObjectCondition c2 = (ObjectCondition)data.getConditionFromTupleIdx(pivot.getTupleIndex());
                        Template t2 = BeffyRuleCompiler.this.engine.findTemplate(c2.getTemplateName());
                        TemplateSlot s1 = t1.getSlot(slotIdx);
                        TemplateSlot s2 = t2.getSlot(pivot.getSlotIndex());
                        AlphaSlotComparatorNode comp = new AlphaSlotComparatorNode(BeffyRuleCompiler.this.engine, op, s1, s2);
                        Node lastNode = data.getLastNode(nest);
                        lastNode.removeChild(join);
                        BeffyRuleCompiler.this.slow(data);
                        try {
                            lastNode.addChild(comp);
                            BeffyRuleCompiler.this.slow(data);
                            data.setLastNode(nest, comp);
                            comp.addChild(join);
                            BeffyRuleCompiler.this.slow(data);
                        }
                        catch (NodeException e) {
                            BeffyRuleCompiler.this.logAndFail(e, data);
                        }
                        continue;
                    }
                    BeffyRuleCompiler.this.log("(%d) ...its not the pivot and in another condition. write a filter in the join %d", new Object[]{p, join.getId()});
                    LeftFieldAddress f1 = new LeftFieldAddress(tupleIdx, slotIdx);
                    LeftFieldAddress f2 = new LeftFieldAddress(pivot.getTupleIndex(), pivot.getSlotIndex());
                    int op = bc.isNegated() ? 10 : 9;
                    GeneralizedFieldComparator filter = new GeneralizedFieldComparator(bc.getConstraintName(), f1, op, f2);
                    join.addFilter(filter);
                }
            }
            return data;
        }

        @Override
        public CompileTableau visit(ExistsCondition c, CompileTableau data) {
            int p = BeffyRuleCompiler.this.getNumber();
            BeffyRuleCompiler.this.log("(%d) i enter exists-condition %d now. i will visit the (hopefully only) sub-condition now.", new Object[]{p, c.hashCode()});
            assert (c.getNestedConditions().size() == 1);
            Condition nested = c.getNestedConditions().get(0);
            nested.acceptVisitor(this, data);
            Node lastNode = data.getLastNode(nested);
            BeffyRuleCompiler.this.log("(%d) do some other magic and wrong stuff here...", new Object[]{p});
            ArrayList<Integer> distinctionSlots = new ArrayList<Integer>();
            AlphaQuantorDistinctionNode quantorNode = new AlphaQuantorDistinctionNode(BeffyRuleCompiler.this.engine, distinctionSlots);
            try {
                lastNode.addChild(quantorNode);
                BeffyRuleCompiler.this.slow(data);
            }
            catch (NodeException e) {
                BeffyRuleCompiler.this.logAndFail(e, data);
            }
            data.setLastNode(c, quantorNode);
            return data;
        }

        @Override
        public CompileTableau visit(NotExistsCondition c, CompileTableau data) {
            BeffyRuleCompiler.this.log("(%d) i enter not-exists-condition %d now. but this is not yet implemented :(", new Object[]{BeffyRuleCompiler.this.getNumber(), c.hashCode()});
            return data;
        }

        @Override
        public CompileTableau visit(ObjectCondition c, CompileTableau data) {
            int p = BeffyRuleCompiler.this.getNumber();
            OneInputNode lastNode = null;
            Template template = BeffyRuleCompiler.this.engine.findTemplate(c.getTemplateName());
            BeffyRuleCompiler.this.log("(%d) i enter object-condition %d for template '%s' now.", new Object[]{p, c.hashCode(), template.getName()});
            try {
                lastNode = BeffyRuleCompiler.this.objectTypeNodes.getObjectTypeNode(template);
                for (Constraint constr : c.getFlatConstraints()) {
                    if (constr instanceof LiteralConstraint) {
                        LiteralConstraint lc = (LiteralConstraint)constr;
                        int operator = lc.isNegated() ? 10 : 9;
                        Slot slot = template.getSlot(lc.getSlotName()).createSlot(BeffyRuleCompiler.this.engine);
                        slot.setValue(lc.getValue());
                        BeffyRuleCompiler.this.log("(%d) found literal constraint (%s %s %s). i'll generate a SlotFilterNode for it.", new Object[]{p, slot.getName(), lc.isNegated() ? "!=" : "==", slot.getValue().implicitCast(JamochaType.STRING).getStringValue()});
                        SlotFilterNode filterNode = new SlotFilterNode(BeffyRuleCompiler.this.engine, operator, slot);
                        lastNode.addChild(filterNode);
                        BeffyRuleCompiler.this.slow(data);
                        lastNode = filterNode;
                    } else if (constr instanceof BoundConstraint) {
                        BoundConstraint bc = (BoundConstraint)constr;
                        BeffyRuleCompiler.this.log("(%d) found bound-constraint '%s' . i will only notify the binding manager for it here. it will be handled in the and-condition.", new Object[]{p, bc.getConstraintName()});
                        BeffyRuleCompiler.this.bindings.boundConstraintOccurs(bc, data.getCurrentFocus(), data);
                    } else {
                        BeffyRuleCompiler.this.log("(%d) found %s. is not implemented yet :(", new Object[]{p, constr.getClass().getSimpleName()});
                    }
                    data.markAsHandled(constr);
                }
            }
            catch (NodeException e) {
                BeffyRuleCompiler.this.logAndFail(e, data);
            }
            catch (EvaluationException e) {
                BeffyRuleCompiler.this.logAndFail(e, data);
            }
            data.setLastNode(c, lastNode);
            return data;
        }

        @Override
        public CompileTableau visit(OrCondition c, CompileTableau data) {
            List<Condition> cons = c.getNestedConditions();
            for (int i = 0; i < cons.size(); ++i) {
                Condition co = cons.get(i);
                if (co instanceof AndCondition) continue;
                AndCondition n = new AndCondition();
                n.addNestedCondition(co);
                ObjectCondition ifact = new ObjectCondition(Collections.EMPTY_LIST, "_initialFact");
                n.addNestedCondition(ifact);
                cons.remove(co);
                cons.add(i, n);
            }
            String struct = c.format(ParserFactory.getFormatter());
            BeffyRuleCompiler.this.log("we will begin to compile the rule '%s' with the following structure:\n%s", new Object[]{data.getRule().getName(), struct});
            int p = BeffyRuleCompiler.this.getNumber();
            BeffyRuleCompiler.this.log("(%d) i enter or-condition %d now. at first, i will handle the sub conditions...", new Object[]{p, c.hashCode()});
            for (Condition subCondition : c.getNestedConditions()) {
                TerminalNode terminal = new TerminalNode(BeffyRuleCompiler.this.engine, data.getRule());
                data.setCurrentFocus(terminal);
                subCondition.acceptVisitor(this, data);
                if (data.getRule().getAutoFocus()) {
                    BeffyRuleCompiler.this.log("(%d) set '%s' as auto-focus", new Object[]{p, data.getRule().getName()});
                    terminal.autoFocus();
                }
                Node last = data.getLastNode(subCondition);
                try {
                    BeffyRuleCompiler.this.log("(%d) add terminal node for '%s'", new Object[]{p, data.getRule().getName()});
                    last.addChild(terminal);
                    BeffyRuleCompiler.this.slow(data);
                    BeffyRuleCompiler.this.terminalNodes.put(data.getRule(), terminal);
                    BeffyRuleCompiler.this.log("(%d) activate nodes for '%s'", new Object[]{p, data.getRule().getName()});
                    BeffyRuleCompiler.this.rootNode.activate();
                }
                catch (NodeException e) {
                    BeffyRuleCompiler.this.logAndFail(e, data);
                }
            }
            BeffyRuleCompiler.this.log("(%d) or-condition handled...", new Object[]{p});
            return data;
        }

        @Override
        public CompileTableau visit(TestCondition c, CompileTableau data) {
            int p = BeffyRuleCompiler.this.getNumber();
            BeffyRuleCompiler.this.log("(%d) i enter test-condition %d now. tests are handled later in the and-condition. we will just add the initial-fact-node as condition's last node here.", new Object[]{p, c.hashCode()});
            try {
                data.setLastNode(c, BeffyRuleCompiler.this.objectTypeNodes.getObjectTypeNode(BeffyRuleCompiler.this.engine.getInitialTemplate()));
            }
            catch (Exception e) {
                BeffyRuleCompiler.this.logAndFail(e, data);
            }
            return data;
        }
    }

    private class CompileTableau {
        private Rule rule;
        private boolean success;
        private Map<Condition, Node> lastNodes;
        private Set<Constraint> handled;
        private Map<Condition, MutableInteger> condition2TupleIdx;
        private Map<Condition, Node> correspondingJoins;
        private TerminalNode currentFocus;

        public TerminalNode getCurrentFocus() {
            return this.currentFocus;
        }

        public void setCurrentFocus(TerminalNode currentFocus) {
            this.currentFocus = currentFocus;
        }

        public CompileTableau(Rule r) {
            this.rule = r;
            this.success = true;
            this.lastNodes = new HashMap<Condition, Node>();
            this.handled = new HashSet<Constraint>();
            this.correspondingJoins = new HashMap<Condition, Node>();
            this.condition2TupleIdx = new HashMap<Condition, MutableInteger>();
        }

        public void setCorrespondingJoin(Condition c, Node join) {
            this.correspondingJoins.put(c, join);
        }

        public Node getCorrespondingJoin(Condition c) {
            return this.correspondingJoins.get(c);
        }

        public MutableInteger getTupleIndexFromCondition(Condition condition) {
            MutableInteger val = this.condition2TupleIdx.get(condition);
            if (val == null) {
                val = new MutableInteger(0);
                this.condition2TupleIdx.put(condition, val);
            }
            return val;
        }

        public void markAsHandled(Constraint c) {
            this.handled.add(c);
        }

        public boolean isMarkedAsHandled(Constraint c) {
            return this.handled.contains(c);
        }

        public boolean hadSuccess() {
            return this.success;
        }

        public void setSuccess(boolean v) {
            this.success = v;
        }

        public Rule getRule() {
            return this.rule;
        }

        public Node getLastNode(Condition c) {
            return this.lastNodes.get(c);
        }

        public void setLastNode(Condition c, Node node) {
            this.lastNodes.put(c, node);
        }

        public Condition getConditionFromTupleIdx(MutableInteger tupleIndex) {
            int idx = (Integer)tupleIndex.get();
            for (Condition c : this.condition2TupleIdx.keySet()) {
                if (!((Integer)this.condition2TupleIdx.get(c).get()).equals(idx)) continue;
                return c;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BindingManager {
        private Map<Rule, Map<BindingKey, BindingInformation>> rule2bindings = new HashMap<Rule, Map<BindingKey, BindingInformation>>();

        private Map<BindingKey, BindingInformation> getBindings(Rule r) {
            Map<BindingKey, BindingInformation> bindings = this.rule2bindings.get(r);
            if (bindings == null) {
                bindings = new HashMap<BindingKey, BindingInformation>();
                this.rule2bindings.put(r, bindings);
            }
            return bindings;
        }

        private BindingInformation getBindingInformation(Rule r, String varName, TerminalNode focus) {
            return this.getBindings(r).get(new BindingKey(varName, focus));
        }

        public Binding getBinding(Rule r, String varName, TerminalNode focus) {
            BindingInformation bi = this.getBindingInformation(r, varName, focus);
            if (bi != null) {
                return this.getBindingInformation((Rule)r, (String)varName, (TerminalNode)focus).b;
            }
            return null;
        }

        private void putBinding(Rule r, TerminalNode focus, String varName, BindingInformation binding) {
            this.getBindings(r).put(new BindingKey(varName, focus), binding);
        }

        private void boundConstraintOccurs(BoundConstraint bc, TerminalNode focus, CompileTableau data) {
            if (bc.isNegated()) {
                return;
            }
            if (!(bc.getParentCondition() instanceof ObjectCondition)) {
                return;
            }
            Rule r = data.rule;
            ObjectCondition ocond = (ObjectCondition)bc.getParentCondition();
            String varName = bc.getConstraintName();
            int level = 0;
            for (Condition ccond = bc.getParentCondition(); ccond != null; ccond = ccond.getParentCondition()) {
                ++level;
            }
            BindingInformation bin = BeffyRuleCompiler.this.bindings.getBindingInformation(r, varName, focus);
            if (bin != null && bin.level <= level) {
                return;
            }
            MutableInteger tupleIdx = data.getTupleIndexFromCondition(bc.getParentCondition());
            int slotIdx = -1;
            if (!bc.isFactBinding()) {
                Template t = BeffyRuleCompiler.this.engine.findTemplate(ocond.getTemplateName());
                TemplateSlot s = t.getSlot(bc.getSlotName());
                slotIdx = s.getId();
            }
            BeffyRuleCompiler.this.log("Potential pivot element for %s found at tuple=%d,slot=%d (tuple-index may vary later on!)", new Object[]{varName, tupleIdx.get(), slotIdx});
            Binding b = new Binding(tupleIdx, slotIdx);
            BindingInformation binf = new BindingInformation(b, level);
            this.putBinding(r, focus, varName, binf);
        }

        private class BindingKey {
            private String name;
            private TerminalNode tnode;

            public String getName() {
                return this.name;
            }

            public TerminalNode getTnode() {
                return this.tnode;
            }

            public BindingKey(String name, TerminalNode tnode) {
                this.name = name;
                this.tnode = tnode;
            }

            public boolean equals(Object other) {
                if (other == null) {
                    return false;
                }
                if (other instanceof BindingKey) {
                    BindingKey bo = (BindingKey)other;
                    if (!bo.name.equals(this.name)) {
                        return false;
                    }
                    if (this.tnode == bo.tnode) {
                        return true;
                    }
                }
                return false;
            }

            public int hashCode() {
                return this.name.hashCode() * this.tnode.getId();
            }
        }

        private class BindingInformation {
            Binding b;
            int level;

            public BindingInformation(Binding b, int level) {
                this.b = b;
                this.level = level;
            }
        }
    }

    private class ObjectTypeNodeManager {
        Map<Template, ObjectTypeNode> typeNodes = new HashMap<Template, ObjectTypeNode>();

        public ObjectTypeNode getObjectTypeNode(Template template) throws NodeException {
            ObjectTypeNode otn = this.typeNodes.get(template);
            if (otn == null) {
                otn = new ObjectTypeNode(BeffyRuleCompiler.this.engine, template);
                BeffyRuleCompiler.this.rootNode.addChild(otn);
                this.typeNodes.put(template, otn);
            }
            return otn;
        }
    }
}

