/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.nodes.joinfilter;

import org.jamocha.engine.nodes.joinfilter.FieldAddress;
import org.jamocha.engine.util.MutableInteger;
import org.jamocha.engine.workingmemory.WorkingMemoryElement;
import org.jamocha.formatter.Formatter;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.JamochaValue;

public class LeftFieldAddress
extends FieldAddress {
    protected int slotIndex;
    protected MutableInteger rowIndex;

    public Object clone() {
        return this;
    }

    public LeftFieldAddress(int rowIndex) {
        this(rowIndex, -1);
    }

    public LeftFieldAddress(int rowIndex, int slotIndex) {
        this.slotIndex = slotIndex;
        this.rowIndex = new MutableInteger(rowIndex);
    }

    public LeftFieldAddress(MutableInteger row, int slot) {
        this.rowIndex = row;
        this.slotIndex = slot;
    }

    public LeftFieldAddress(MutableInteger row) {
        this(row, -1);
    }

    public String toPPString() {
        return this.getExpressionString();
    }

    public String getExpressionString() {
        StringBuffer result = new StringBuffer();
        result.append("left(row=");
        result.append(this.rowIndex.get());
        if (this.slotIndex == -1) {
            result.append(";whole fact)");
        } else {
            result.append(";slot=").append(this.slotIndex).append(")");
        }
        return result.toString();
    }

    public String format(Formatter visitor) {
        return visitor.visit(this);
    }

    public JamochaValue getIndexedValue(WorkingMemoryElement wme) throws EvaluationException {
        if (this.slotIndex == -1) {
            return JamochaValue.newFact(wme.getFactTuple().getFact((Integer)this.rowIndex.get()));
        }
        return wme.getFactTuple().getFact((Integer)this.rowIndex.get()).getSlotValue(this.slotIndex);
    }

    public MutableInteger getTupleIndex() {
        return this.rowIndex;
    }

    public int getSlotIndex() {
        return this.slotIndex;
    }
}

