/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.nodes.joinfilter;

import java.util.List;
import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.configurations.Signature;
import org.jamocha.engine.functions.Function;
import org.jamocha.engine.nodes.FactTuple;
import org.jamocha.engine.nodes.joinfilter.FieldAddress;
import org.jamocha.engine.nodes.joinfilter.FieldAddressingException;
import org.jamocha.engine.nodes.joinfilter.GeneralizedJoinFilter;
import org.jamocha.engine.nodes.joinfilter.JoinFilterException;
import org.jamocha.engine.nodes.joinfilter.LeftFieldAddress;
import org.jamocha.engine.workingmemory.elements.Fact;
import org.jamocha.parser.EvaluationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneralizedFunctionEvaluator
implements GeneralizedJoinFilter {
    protected Parameter[] parameters;
    protected Function function;
    protected Engine engine;

    private GeneralizedFunctionEvaluator(Engine engine, Function function) {
        this.function = function;
        this.engine = engine;
    }

    public GeneralizedFunctionEvaluator(Engine engine, Function function, List<Parameter> parameters) throws JoinFilterException {
        this(engine, function);
        Parameter[] params = new Parameter[]{};
        this.parameters = parameters.toArray(params);
    }

    public GeneralizedFunctionEvaluator(Engine engine, Function function, Parameter[] parameters) throws JoinFilterException {
        this(engine, function);
        this.parameters = parameters;
    }

    private void substitute(Parameter[] params, FactTuple t) throws FieldAddressingException, EvaluationException {
        for (int i = 0; i < params.length; ++i) {
            Parameter p = params[i];
            if (p instanceof LeftFieldAddress) {
                params[i] = ((FieldAddress)p).getIndexedValue(t);
                continue;
            }
            if (!(p instanceof Signature)) continue;
            Signature sig = (Signature)p;
            this.substitute(sig.getParameters(), t);
        }
    }

    private Parameter[] semicloneParameters(Parameter[] orig) {
        Parameter[] clone = (Parameter[])orig.clone();
        for (int i = 0; i < clone.length; ++i) {
            if (!(clone[i] instanceof Signature)) continue;
            Signature s = (Signature)clone[i];
            Signature sigClone = (Signature)s.clone();
            sigClone.setParameters(this.semicloneParameters(sigClone.getParameters()));
            clone[i] = sigClone;
        }
        return clone;
    }

    @Override
    public boolean evaluate(FactTuple t, Engine engine) throws JoinFilterException, EvaluationException {
        Parameter[] callParams = this.semicloneParameters(this.parameters);
        this.substitute(callParams, t);
        try {
            return this.function.executeFunction(engine, callParams).getBooleanValue();
        }
        catch (EvaluationException e) {
            return false;
        }
    }

    @Override
    public String toPPString() {
        StringBuffer result = new StringBuffer();
        result.append("test: ");
        result.append(this.function.getName());
        result.append("(");
        for (int i = 0; i < this.parameters.length; ++i) {
            Parameter param = this.parameters[i];
            if (i > 0) {
                result.append(", ");
            }
            result.append(param.getExpressionString());
        }
        result.append(")");
        return result.toString();
    }

    @Override
    public boolean evaluate(Fact right, FactTuple left, Engine engine) throws JoinFilterException, EvaluationException {
        return this.evaluate(left.appendFact(right), engine);
    }
}

