/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.nodes;

import org.jamocha.engine.ReteNet;
import org.jamocha.engine.nodes.InvalidOperationException;
import org.jamocha.engine.nodes.LeftInputAdaptorNode;
import org.jamocha.engine.nodes.Node;
import org.jamocha.engine.nodes.NodeException;
import org.jamocha.engine.nodes.OneInputNode;
import org.jamocha.engine.workingmemory.WorkingMemory;
import org.jamocha.engine.workingmemory.WorkingMemoryElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TwoInputNode
extends OneInputNode {
    protected Node betaInput = null;

    public TwoInputNode(int id, WorkingMemory memory, ReteNet net) {
        super(id, memory, net);
    }

    @Override
    public Node[] getParentNodes() {
        if (this.alphaInput == null && this.betaInput == null) {
            Node[] result = new Node[]{};
            return result;
        }
        if (this.alphaInput == null) {
            Node[] result = new Node[]{this.betaInput};
            return result;
        }
        if (this.betaInput == null) {
            Node[] result = new Node[]{this.alphaInput};
            return result;
        }
        Node[] result = new Node[]{this.alphaInput, this.betaInput};
        return result;
    }

    public Node getBetaInput() {
        return this.betaInput;
    }

    protected void plugBetaParent(Node node) throws InvalidOperationException, NodeException {
        if (this.betaInput != null) {
            throw new InvalidOperationException("there already is a beta input");
        }
        this.betaInput = node;
        node.addChild(this);
    }

    @Override
    protected Node registerParent(Node n) throws NodeException {
        if (n.outputsBeta()) {
            this.betaInput = n;
            return this;
        }
        if (this.alphaInput == null) {
            this.alphaInput = n;
            return this;
        }
        LeftInputAdaptorNode lia = new LeftInputAdaptorNode(this.net.getEngine());
        lia.addChild(this);
        lia.registerParent(n);
        this.betaInput = lia;
        return lia;
    }

    protected Iterable<WorkingMemoryElement> beta() {
        if (this.getBetaInput() != null) {
            return this.getBetaInput().memory();
        }
        return null;
    }

    @Override
    protected void unbindFromParents() {
        super.unbindFromParents();
        this.betaInput = null;
    }
}

