/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.nodes;

import org.jamocha.application.gui.retevisualisation.NodeDrawer;
import org.jamocha.application.gui.retevisualisation.nodedrawers.SlotFilterNodeDrawer;
import org.jamocha.engine.Engine;
import org.jamocha.engine.Evaluate;
import org.jamocha.engine.ReteNet;
import org.jamocha.engine.nodes.Node;
import org.jamocha.engine.nodes.NodeException;
import org.jamocha.engine.nodes.OneInputNode;
import org.jamocha.engine.workingmemory.WorkingMemory;
import org.jamocha.engine.workingmemory.WorkingMemoryElement;
import org.jamocha.engine.workingmemory.elements.Slot;
import org.jamocha.parser.EvaluationException;

public class SlotFilterNode
extends OneInputNode {
    private final int operator;
    private final Slot slot;

    @Deprecated
    public SlotFilterNode(int id, WorkingMemory memory, int operator, Slot slot, ReteNet net) {
        super(id, memory, net);
        this.operator = operator;
        this.slot = slot;
    }

    public SlotFilterNode(Engine e, int operator, Slot slot) {
        this(e.getNet().nextNodeId(), e.getWorkingMemory(), operator, slot, e.getNet());
    }

    protected boolean evaluate(WorkingMemoryElement elem) throws NodeException {
        try {
            return Evaluate.evaluate(this.operator, elem.getFirstFact().getSlotValue(this.slot.getId()), this.slot.getValue());
        }
        catch (EvaluationException e) {
            throw new NodeException(e, (Node)this);
        }
    }

    public void addWME(Node sender, WorkingMemoryElement newElem) throws NodeException {
        if (!this.isActivated()) {
            return;
        }
        if (this.evaluate(newElem)) {
            this.addAndPropagate(newElem);
        }
    }

    public void removeWME(Node sender, WorkingMemoryElement oldElem) throws NodeException {
        if (this.evaluate(oldElem)) {
            this.removeAndPropagate(oldElem);
        }
    }

    public boolean outputsBeta() {
        return false;
    }

    public void getDescriptionString(StringBuilder sb) {
        super.getDescriptionString(sb);
        sb.append("|").append(this.slot.getId()).append(this.operator == 9 ? "==" : "!=").append(this.slot.getValue());
    }

    protected NodeDrawer newNodeDrawer() {
        return new SlotFilterNodeDrawer(this);
    }
}

