/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.nodes;

import java.util.Iterator;
import org.jamocha.application.gui.retevisualisation.NodeDrawer;
import org.jamocha.application.gui.retevisualisation.nodedrawers.SimpleBetaFilterNodeDrawer;
import org.jamocha.engine.Engine;
import org.jamocha.engine.ReteNet;
import org.jamocha.engine.nodes.AbstractBetaFilterNode;
import org.jamocha.engine.nodes.FactTuple;
import org.jamocha.engine.nodes.Node;
import org.jamocha.engine.nodes.NodeException;
import org.jamocha.engine.nodes.joinfilter.GeneralizedJoinFilter;
import org.jamocha.engine.nodes.joinfilter.JoinFilterException;
import org.jamocha.engine.workingmemory.WorkingMemory;
import org.jamocha.engine.workingmemory.WorkingMemoryElement;
import org.jamocha.parser.EvaluationException;

public class SimpleBetaFilterNode
extends AbstractBetaFilterNode {
    @Deprecated
    public SimpleBetaFilterNode(int id, WorkingMemory memory, ReteNet net) {
        super(id, memory, net);
    }

    @Deprecated
    public SimpleBetaFilterNode(int id, WorkingMemory memory, ReteNet net, GeneralizedJoinFilter[] filters) {
        super(id, memory, net, filters);
    }

    public SimpleBetaFilterNode(Engine e) {
        this(e.getNet().nextNodeId(), e.getWorkingMemory(), e.getNet());
    }

    public SimpleBetaFilterNode(Engine e, GeneralizedJoinFilter[] filters) {
        this(e.getNet().nextNodeId(), e.getWorkingMemory(), e.getNet(), filters);
    }

    protected void addAlpha(WorkingMemoryElement newElem) throws JoinFilterException, EvaluationException, NodeException {
        if (this.betaInput != null && this.betaInput.workingMemory != null) {
            for (WorkingMemoryElement beta : this.betaInput.workingMemory.getMemory(this.betaInput)) {
                if (!this.applyFilters(newElem, beta)) continue;
                FactTuple newTuple = beta.getFactTuple().appendFact(newElem.getFirstFact());
                this.addAndPropagate(newTuple);
            }
        }
    }

    protected void addBeta(WorkingMemoryElement newElem) throws JoinFilterException, EvaluationException, NodeException {
        if (this.alphaInput != null && this.alphaInput.workingMemory != null) {
            for (WorkingMemoryElement alpha : this.alphaInput.workingMemory.getMemory(this.alphaInput)) {
                if (!this.applyFilters(alpha, newElem)) continue;
                FactTuple newTuple = newElem.getFactTuple().appendFact(alpha.getFirstFact());
                this.addAndPropagate(newTuple);
            }
        }
    }

    public void removeWME(Node sender, WorkingMemoryElement oldElem) throws NodeException {
        try {
            if (oldElem.isStandaloneFact()) {
                this.removeAlpha(oldElem);
            } else {
                this.removeBeta(oldElem);
            }
        }
        catch (Exception e) {
            throw new NodeException("error while removing working memory element. ", e, this);
        }
    }

    protected void removeAlpha(WorkingMemoryElement oldElem) throws JoinFilterException, EvaluationException, NodeException {
        Iterator<WorkingMemoryElement> i = this.memory().iterator();
        while (i.hasNext()) {
            WorkingMemoryElement wme = i.next();
            if (wme.getLastFact().getFactId() != oldElem.getFirstFact().getFactId()) continue;
            i.remove();
            this.propagateRemoval(wme);
        }
    }

    protected void removeBeta(WorkingMemoryElement oldElem) throws JoinFilterException, EvaluationException, NodeException {
        Iterator<WorkingMemoryElement> i = this.memory().iterator();
        while (i.hasNext()) {
            WorkingMemoryElement wme = i.next();
            if (!wme.getFactTuple().isMySubTuple(oldElem.getFactTuple())) continue;
            i.remove();
            this.propagateRemoval(wme);
        }
    }

    protected NodeDrawer newNodeDrawer() {
        return new SimpleBetaFilterNodeDrawer(this);
    }

    public void getDescriptionString(StringBuilder sb) {
        super.getDescriptionString(sb);
        sb.append("|filters:");
        for (GeneralizedJoinFilter f : this.getFilters()) {
            sb.append(f.toPPString() + " & ");
        }
    }

    public void addWME(Node sender, WorkingMemoryElement newElem) throws NodeException {
        if (!this.isActivated()) {
            return;
        }
        try {
            if (newElem.isStandaloneFact()) {
                this.addAlpha(newElem);
            } else {
                this.addBeta(newElem);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NodeException("error while adding working memory element. ", e, this);
        }
    }
}

