/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.nodes;

import java.util.HashMap;
import java.util.Map;
import org.jamocha.application.gui.retevisualisation.NodeDrawer;
import org.jamocha.application.gui.retevisualisation.nodedrawers.QuantorBetaFilterNodeDrawer;
import org.jamocha.engine.ReteNet;
import org.jamocha.engine.nodes.NodeException;
import org.jamocha.engine.nodes.SimpleBetaFilterNode;
import org.jamocha.engine.nodes.joinfilter.GeneralizedJoinFilter;
import org.jamocha.engine.nodes.joinfilter.JoinFilterException;
import org.jamocha.engine.workingmemory.WorkingMemory;
import org.jamocha.engine.workingmemory.WorkingMemoryElement;
import org.jamocha.parser.EvaluationException;

public class QuantorBetaFilterNode
extends SimpleBetaFilterNode {
    protected boolean negated;
    private final Counter<WorkingMemoryElement> counter;

    public QuantorBetaFilterNode(int id, WorkingMemory memory, ReteNet net, boolean negated) {
        this(id, memory, net, null, negated);
    }

    @Deprecated
    public QuantorBetaFilterNode(int id, WorkingMemory memory, ReteNet net, GeneralizedJoinFilter[] filter, boolean negated) {
        super(id, memory, net, filter);
        this.negated = negated;
        this.counter = new Counter();
    }

    protected void itExists(WorkingMemoryElement w) throws NodeException {
        if (this.negated) {
            this.removeAndPropagate(w);
        } else {
            this.addAndPropagate(w);
        }
    }

    protected void itDoesntExist(WorkingMemoryElement w) throws NodeException {
        if (this.negated) {
            this.addAndPropagate(w);
        } else {
            this.removeAndPropagate(w);
        }
    }

    protected void evAlpha(WorkingMemoryElement elem, int direction) throws JoinFilterException, EvaluationException, NodeException {
        assert (direction == -1 || direction == 1);
        Iterable<WorkingMemoryElement> wmes = this.beta();
        if (wmes != null) {
            for (WorkingMemoryElement wme : wmes) {
                boolean match = this.applyFilters(elem, wme);
                if (!match) continue;
                int now = this.counter.add(wme, direction);
                assert (now >= 0);
                if (direction > 0 && now == 1) {
                    this.itExists(wme.getFactTuple().appendFact(this.net.getEngine().getInitialFact()));
                    continue;
                }
                if (direction >= 0 || now != 0) continue;
                this.itDoesntExist(wme.getFactTuple().appendFact(this.net.getEngine().getInitialFact()));
            }
        }
    }

    protected void addAlpha(WorkingMemoryElement newElem) throws JoinFilterException, EvaluationException, NodeException {
        this.evAlpha(newElem, 1);
    }

    protected void addBeta(WorkingMemoryElement newElem) throws JoinFilterException, EvaluationException, NodeException {
        int cn = 0;
        for (WorkingMemoryElement wme : this.alpha()) {
            if (!this.applyFilters(wme, newElem)) continue;
            ++cn;
        }
        if (cn > 0) {
            this.counter.set(newElem, cn);
            this.itExists(newElem.getFactTuple().appendFact(this.net.getEngine().getInitialFact()));
        } else {
            this.itDoesntExist(newElem.getFactTuple().appendFact(this.net.getEngine().getInitialFact()));
        }
    }

    protected void removeAlpha(WorkingMemoryElement oldElem) throws JoinFilterException, EvaluationException, NodeException {
        this.evAlpha(oldElem, -1);
    }

    protected void removeBeta(WorkingMemoryElement oldElem) throws JoinFilterException, EvaluationException, NodeException {
        this.removeAndPropagate(oldElem.getFactTuple().appendFact(this.net.getEngine().getInitialFact()));
        this.counter.set(oldElem, 0);
    }

    protected NodeDrawer newNodeDrawer() {
        return new QuantorBetaFilterNodeDrawer(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Counter<K> {
        private final Map<K, Int> cnt = new HashMap<K, Int>();

        public int getCount(K k) {
            Int i = this.cnt.get(k);
            return i != null ? i.i : 0;
        }

        private Int get(K k) {
            Int i = this.cnt.get(k);
            if (i != null) {
                return i;
            }
            i = new Int();
            this.cnt.put(k, i);
            return i;
        }

        public int dec(K k) {
            return --this.get(k).i;
        }

        public int inc(K k) {
            return ++this.get(k).i;
        }

        public int add(K k, int val) {
            Int i = this.get(k);
            i.i += val;
            return i.i;
        }

        public void set(K k, int val) {
            Int i = this.get(k);
            i.i = val;
        }

        private class Int {
            int i;

            private Int() {
            }
        }
    }
}

