/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.nodes;

import java.util.Arrays;
import java.util.Iterator;
import org.jamocha.engine.nodes.FactTuple;
import org.jamocha.engine.workingmemory.WorkingMemoryElement;
import org.jamocha.engine.workingmemory.elements.Fact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactTupleImpl
implements FactTuple {
    private static final long serialVersionUID = 1L;
    protected Fact[] facts = null;

    public FactTupleImpl(Fact[] facts) {
        this.facts = facts;
    }

    @Override
    public int length() {
        return this.facts.length;
    }

    public FactTupleImpl(Fact fact) {
        this(new Fact[]{fact});
    }

    @Override
    public Fact[] getFacts() {
        return this.facts;
    }

    @Override
    public FactTuple appendFact(Fact fact) {
        Fact[] facts = new Fact[this.facts.length + 1];
        System.arraycopy(this.facts, 0, facts, 0, this.facts.length);
        facts[this.facts.length] = fact;
        return new FactTupleImpl(facts);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[ ");
        for (Fact fact : this.facts) {
            sb.append(fact.toString());
            sb.append(" | ");
        }
        sb.append("] ");
        return sb.toString();
    }

    @Override
    public boolean isMySubTuple(FactTuple smallerOne) {
        int count = smallerOne.length();
        for (int i = 0; i < count; ++i) {
            if (smallerOne.getFact(i) == this.facts[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isMyLastFact(Fact input) {
        return this.facts[this.facts.length - 1] == input;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkingMemoryElement)) {
            return false;
        }
        WorkingMemoryElement other = (WorkingMemoryElement)obj;
        return Arrays.equals(this.facts, other.getFactTuple().getFacts());
    }

    @Override
    public FactTuple getFactTuple() {
        return this;
    }

    @Override
    public Fact getFact(int index) {
        return this.facts[index];
    }

    @Override
    public Iterator<Fact> iterator() {
        return new FactTupleIterator(this.facts);
    }

    @Override
    public boolean isStandaloneFact() {
        return false;
    }

    @Override
    public Fact getFirstFact() {
        return this.facts[0];
    }

    @Override
    public Fact getLastFact() {
        return this.facts[this.facts.length - 1];
    }

    public int hashCode() {
        int hash = 0;
        for (Fact f : this.facts) {
            hash += f.hashCode();
        }
        return hash;
    }

    @Override
    public long getAggregateCreationTimestamp() {
        long result = 0L;
        for (Fact fact : this.facts) {
            result = Math.max(result, fact.getCreationTimeStamp());
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class FactTupleIterator
    implements Iterator<Fact> {
        private final Fact[] arr;
        int ind = 0;

        public FactTupleIterator(Fact[] arr) {
            this.arr = arr;
        }

        @Override
        public boolean hasNext() {
            return this.ind < this.arr.length;
        }

        @Override
        public Fact next() {
            Fact result = this.arr[this.ind];
            ++this.ind;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

