/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.nodes;

import org.jamocha.application.gui.retevisualisation.NodeDrawer;
import org.jamocha.application.gui.retevisualisation.nodedrawers.SlotFilterNodeDrawer;
import org.jamocha.engine.Engine;
import org.jamocha.engine.ReteNet;
import org.jamocha.engine.nodes.Node;
import org.jamocha.engine.nodes.NodeException;
import org.jamocha.engine.nodes.OneInputNode;
import org.jamocha.engine.workingmemory.WorkingMemory;
import org.jamocha.engine.workingmemory.WorkingMemoryElement;
import org.jamocha.engine.workingmemory.elements.TemplateSlot;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.JamochaValue;

public class AlphaSlotComparatorNode
extends OneInputNode {
    private final int operator;
    private final TemplateSlot slot1;
    private final TemplateSlot slot2;
    private int id1;
    private int id2;

    @Deprecated
    public AlphaSlotComparatorNode(int id, WorkingMemory memory, int operator, TemplateSlot slot1, TemplateSlot slot2, ReteNet net) {
        super(id, memory, net);
        this.operator = operator;
        this.slot1 = slot1;
        this.slot2 = slot2;
        this.id1 = slot1.getId();
        this.id2 = slot2.getId();
    }

    public AlphaSlotComparatorNode(Engine e, int operator, TemplateSlot slot1, TemplateSlot slot2) {
        this(e.getNet().nextNodeId(), e.getWorkingMemory(), operator, slot1, slot2, e.getNet());
    }

    protected boolean evaluate(WorkingMemoryElement elem) throws NodeException {
        try {
            JamochaValue val1 = elem.getFirstFact().getSlotValue(this.id1);
            JamochaValue val2 = elem.getFirstFact().getSlotValue(this.id2);
            boolean eq = val1.equals(val2);
            if (this.operator == 10) {
                eq = !eq;
            }
            return eq;
        }
        catch (EvaluationException e) {
            throw new NodeException("error evaluating. must be a bug.", (Node)this);
        }
    }

    public void addWME(Node sender, WorkingMemoryElement newElem) throws NodeException {
        if (!this.isActivated()) {
            return;
        }
        if (this.evaluate(newElem)) {
            this.addAndPropagate(newElem);
        }
    }

    public void removeWME(Node sender, WorkingMemoryElement oldElem) throws NodeException {
        if (this.evaluate(oldElem)) {
            this.removeAndPropagate(oldElem);
        }
    }

    public boolean outputsBeta() {
        return false;
    }

    public void getDescriptionString(StringBuilder sb) {
        super.getDescriptionString(sb);
        sb.append("|").append(this.slot1.getId()).append(this.operator == 9 ? "==" : "!=").append(this.slot2.getId());
    }

    protected NodeDrawer newNodeDrawer() {
        return new SlotFilterNodeDrawer(this);
    }
}

