/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.nodes;

import java.util.List;
import org.jamocha.engine.ReteNet;
import org.jamocha.engine.nodes.TwoInputNode;
import org.jamocha.engine.nodes.joinfilter.GeneralizedJoinFilter;
import org.jamocha.engine.nodes.joinfilter.JoinFilterException;
import org.jamocha.engine.workingmemory.WorkingMemory;
import org.jamocha.engine.workingmemory.WorkingMemoryElement;
import org.jamocha.parser.EvaluationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBetaFilterNode
extends TwoInputNode {
    protected GeneralizedJoinFilter[] filters;

    public AbstractBetaFilterNode(int id, WorkingMemory memory, ReteNet net) {
        this(id, memory, net, new GeneralizedJoinFilter[0]);
    }

    public AbstractBetaFilterNode(int id, WorkingMemory memory, ReteNet net, GeneralizedJoinFilter[] filters) {
        super(id, memory, net);
        this.filters = filters;
    }

    protected boolean applyFilters(WorkingMemoryElement alpha, WorkingMemoryElement beta) throws JoinFilterException, EvaluationException {
        for (GeneralizedJoinFilter f : this.getFilters()) {
            if (f.evaluate(alpha.getFirstFact(), beta.getFactTuple(), this.net.getEngine())) continue;
            return false;
        }
        return true;
    }

    protected GeneralizedJoinFilter[] getFilters() {
        if (this.filters != null) {
            return this.filters;
        }
        GeneralizedJoinFilter[] empty = new GeneralizedJoinFilter[]{};
        return empty;
    }

    public void setFilter(GeneralizedJoinFilter[] filter) {
        this.filters = filter;
    }

    public void setFilter(List<GeneralizedJoinFilter> filter) {
        GeneralizedJoinFilter[] arr = new GeneralizedJoinFilter[filter.size()];
        arr = filter.toArray(arr);
        this.setFilter(arr);
    }

    public void addFilter(GeneralizedJoinFilter filter) {
        GeneralizedJoinFilter[] tmpFilters = this.getFilters();
        GeneralizedJoinFilter[] arr = new GeneralizedJoinFilter[tmpFilters.length + 1];
        if (tmpFilters.length > 0) {
            System.arraycopy(tmpFilters, 0, arr, 0, tmpFilters.length);
        }
        arr[tmpFilters.length] = filter;
        this.setFilter(arr);
    }

    @Override
    public boolean outputsBeta() {
        return true;
    }
}

