/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.modules;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jamocha.Constants;
import org.jamocha.communication.events.ModulesChangedEvent;
import org.jamocha.communication.events.ModulesChangedEventListener;
import org.jamocha.engine.Engine;
import org.jamocha.engine.configurations.AssertConfiguration;
import org.jamocha.engine.configurations.TemporalValidityConfiguration;
import org.jamocha.engine.modules.Defmodule;
import org.jamocha.engine.modules.FactDataContainer;
import org.jamocha.engine.modules.Module;
import org.jamocha.engine.modules.RuleDataContainer;
import org.jamocha.engine.modules.TemplateDataContainer;
import org.jamocha.engine.workingmemory.elements.Deftemplate;
import org.jamocha.engine.workingmemory.elements.Fact;
import org.jamocha.engine.workingmemory.elements.OrderedTemplate;
import org.jamocha.engine.workingmemory.elements.Template;
import org.jamocha.parser.EvaluationException;
import org.jamocha.rules.Rule;
import org.jamocha.settings.JamochaSettings;
import org.jamocha.settings.SettingsChangedListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Modules
implements SettingsChangedListener,
Serializable {
    private static final long serialVersionUID = 1L;
    private boolean watchFact = false;
    private boolean watchRules = false;
    private final String[] interestedProperties = new String[]{"engine.general_settings.watch_facts", "engine.general_settings.watch_rules"};
    private Module currentModule = null;
    private final List<ModulesChangedEventListener> listeners;
    private Module main = null;
    private final FactDataContainer facts = new FactDataContainer();
    private final RuleDataContainer rules = new RuleDataContainer();
    private final TemplateDataContainer templates = new TemplateDataContainer();
    protected Engine engine;
    protected Map<String, Module> modules = new HashMap<String, Module>();

    public Collection<Module> getModuleList() {
        return this.modules.values();
    }

    public Modules(Engine engine) {
        this.initMain();
        this.engine = engine;
        this.listeners = new ArrayList<ModulesChangedEventListener>();
        JamochaSettings.getInstance().addListener(this, this.interestedProperties);
    }

    public void addModulesChangeListener(ModulesChangedEventListener l) {
        this.listeners.add(l);
    }

    public void removeModulesChangeListener(ModulesChangedEventListener l) {
        this.listeners.remove(l);
    }

    protected void initMain() {
        this.main = new Defmodule("MAIN", this);
        this.modules.put(this.main.getName(), this.main);
        this.currentModule = this.main;
    }

    public Module getCurrentModule() {
        return this.currentModule;
    }

    public boolean setCurrentModule(String name) {
        Module mod = this.findModule(name);
        if (mod == null) {
            return false;
        }
        this.setCurrentModule(mod);
        return true;
    }

    public boolean setCurrentModule(Module mod) {
        if (mod != null) {
            this.currentModule = mod;
            return true;
        }
        return false;
    }

    public Module getMainModule() {
        return this.main;
    }

    public Module addModule(String name) {
        if (this.findModule(name) == null) {
            Defmodule mod = new Defmodule(name, this);
            this.modules.put(name, mod);
            ModulesChangedEvent event = new ModulesChangedEvent(this, mod, ModulesChangedEvent.ModulesChangedEventType.MODULE_ADDED);
            for (ModulesChangedEventListener l : this.listeners) {
                l.modulesChanged(event);
            }
            return mod;
        }
        return null;
    }

    public Module getModule(String name) {
        Module result = this.findModule(name);
        if (result == null) {
            return this.addModule(name);
        }
        return result;
    }

    public Module removeModule(Module module) {
        ModulesChangedEvent event = new ModulesChangedEvent(this, module, ModulesChangedEvent.ModulesChangedEventType.MODULE_REMOVED);
        for (ModulesChangedEventListener l : this.listeners) {
            l.modulesChanged(event);
        }
        this.clearModule(module);
        return this.modules.remove(module.getName());
    }

    public Module findModule(String name) {
        return this.modules.get(name);
    }

    private Fact createFact(AssertConfiguration ac, Deftemplate tmpl) throws EvaluationException {
        Fact ft = null;
        ft = tmpl.createFact(ac.getSlotConfigurations(), this.engine);
        return ft;
    }

    private Fact createFact(AssertConfiguration ac, OrderedTemplate tmpl) throws EvaluationException {
        Fact ft = null;
        ft = tmpl.createFact(ac.getData(), this.engine);
        return ft;
    }

    public Fact createFact(AssertConfiguration ac) throws EvaluationException {
        Template tmpl = this.getTemplate(this.currentModule, ac.getTemplateName());
        Fact result = tmpl == null ? this.createFact(ac, new OrderedTemplate(ac.getTemplateName())) : (tmpl instanceof Deftemplate ? this.createFact(ac, (Deftemplate)tmpl) : this.createFact(ac, (OrderedTemplate)tmpl));
        if (ac.getTemporalValidityConfiguration() != null) {
            TemporalValidityConfiguration tvc = ac.getTemporalValidityConfiguration();
            result.setTemporalValidity(tvc.getTemporalValidity(this.engine));
        } else if (ac.getTemporalValidity() != null) {
            result.setTemporalValidity(ac.getTemporalValidity());
        }
        return result;
    }

    public Rule findRule(Module module, String ruleName) {
        return this.rules.get(ruleName, module);
    }

    protected void removeTemplate(Module module, Template temp) {
        this.templates.remove(temp.getName(), module);
    }

    protected boolean addTemplate(Module defmodule, Template temp) {
        return this.templates.add(temp, defmodule);
    }

    public Template getTemplate(Module defmodule, String template) {
        return this.templates.get(template, defmodule);
    }

    public boolean containsTemplate(Module defmodule, Template template) {
        return this.templates.containsTemplate(defmodule, template);
    }

    public List<Rule> getRules(Module module) {
        return this.rules.getRules(module);
    }

    public List<Rule> getAllRules() {
        return this.rules.getRules();
    }

    public boolean containsRule(Module defmodule, Rule rl) {
        return this.rules.containsRule(rl, defmodule);
    }

    public void removeRule(Module defmodule, Rule rl) {
        if (this.watchRules) {
            this.engine.writeMessage("<== Rule: " + rl.getName() + Constants.LINEBREAK, "t");
        }
        this.rules.remove(rl.getName(), defmodule);
    }

    public void addRule(Module defmodule, Rule rl) {
        if (this.watchRules) {
            this.engine.writeMessage("==> Rule: " + rl.getName() + Constants.LINEBREAK, "t");
        }
        this.rules.add(rl, defmodule);
    }

    public List<Template> getTemplates(Module defmodule) {
        return this.templates.getTemplates(defmodule);
    }

    public List<Fact> getAllFacts() {
        return this.facts.getFacts();
    }

    public Fact getFactById(long id) {
        return this.facts.getFactById(id);
    }

    public Fact getFactByFact(Fact fact) {
        return this.facts.getFactByFact(fact);
    }

    public long addFact(Fact fact) {
        if (this.watchFact) {
            this.engine.writeMessage("==> " + fact.toString() + Constants.LINEBREAK, "t");
        }
        return this.facts.add(fact);
    }

    public void removeFact(Fact fact) {
        if (this.watchFact) {
            this.engine.writeMessage("<== " + fact.toString() + Constants.LINEBREAK, "t");
        }
        this.facts.remove(fact.getFactId());
    }

    public String toString() {
        return "Modules Current Module:" + this.getCurrentModule().getName();
    }

    public void clearAll() {
        this.clearAllRules();
        this.clearAllFacts();
        this.clearAllTemplates();
        this.modules.clear();
        this.initMain();
    }

    public void clearModule(Module module) {
        this.clearFacts(module);
        this.clearRules(module);
        this.clearTemplates(module);
    }

    private void clearTemplates(Module module) {
    }

    public void clearRules(Module module) {
    }

    public void clearFacts(Module module) {
    }

    public void clearAllRules() {
        this.rules.clear();
    }

    public void clearAllFacts() {
        this.facts.clear();
    }

    public void clearAllTemplates() {
        this.templates.clear();
    }

    public void setWatchFact(boolean watchFact) {
        this.watchFact = watchFact;
    }

    public void setWatchRules(boolean watchRules) {
        this.watchRules = watchRules;
    }

    @Override
    public void settingsChanged(String propertyName) {
        JamochaSettings settings = JamochaSettings.getInstance();
        if (propertyName.equals("engine.general_settings.watch_facts")) {
            this.setWatchFact(settings.getBoolean(propertyName));
        } else if (propertyName.equals("engine.general_settings.watch_rules")) {
            this.setWatchRules(settings.getBoolean(propertyName));
        }
    }
}

