/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.modules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jamocha.engine.EqualityIndex;
import org.jamocha.engine.modules.ModulesDataContainer;
import org.jamocha.engine.workingmemory.elements.Fact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactDataContainer
extends ModulesDataContainer {
    private long lastFactId = 1L;
    protected Map<EqualityIndex, Fact> deffactMap = new HashMap<EqualityIndex, Fact>();

    public FactDataContainer() {
        this.idToCLIPSElement = new HashMap();
    }

    @Override
    protected void handleClear() {
        this.deffactMap.clear();
        this.lastFactId = 1L;
    }

    public synchronized long add(Fact fact) {
        long result = -1L;
        if (!this.deffactMap.containsKey(fact.equalityIndex())) {
            this.deffactMap.put(fact.equalityIndex(), fact);
            if (fact.getFactId() == -1L) {
                result = this.lastFactId++;
                fact.setFactId(result);
            }
            this.idToCLIPSElement.put(fact.getFactId(), fact);
        } else {
            Fact existingFact = this.deffactMap.get(fact.equalityIndex());
            fact.setFactId(existingFact.getFactId());
        }
        result = fact.getFactId();
        return result;
    }

    public synchronized Fact remove(long factId) {
        Fact result = null;
        if (this.idToCLIPSElement.containsKey(factId)) {
            result = (Fact)this.idToCLIPSElement.remove(factId);
            this.deffactMap.remove(result.equalityIndex());
        }
        return result;
    }

    protected Fact getFactById(long id) {
        return (Fact)this.idToCLIPSElement.get(id);
    }

    public synchronized List<Fact> getFacts() {
        ArrayList<Fact> facts = new ArrayList<Fact>();
        for (Object key : this.idToCLIPSElement.keySet()) {
            Fact fact = (Fact)this.idToCLIPSElement.get(key);
            facts.add(fact);
        }
        return facts;
    }

    protected Fact getFactByFact(Fact fact) {
        return this.deffactMap.get(fact.equalityIndex());
    }
}

