/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.modules;

import java.util.ArrayList;
import java.util.List;
import org.jamocha.communication.events.ModuleChangedEvent;
import org.jamocha.communication.events.ModuleChangedListener;
import org.jamocha.engine.modules.Module;
import org.jamocha.engine.modules.Modules;
import org.jamocha.engine.workingmemory.elements.Template;
import org.jamocha.rules.Rule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Defmodule
implements Module {
    Modules modules;
    List<ModuleChangedListener> listeners;
    private static final long serialVersionUID = 3735928495L;
    protected int id;
    protected String name = null;

    protected void callListenersAddRule(Rule rule) {
        ModuleChangedEvent ev = new ModuleChangedEvent((Object)this, (Module)this, rule);
        for (ModuleChangedListener listener : this.listeners) {
            listener.ruleAdded(ev);
        }
    }

    protected void callListenersRemoveRule(Rule rule) {
        ModuleChangedEvent ev = new ModuleChangedEvent((Object)this, (Module)this, rule);
        for (ModuleChangedListener listener : this.listeners) {
            listener.ruleRemoved(ev);
        }
    }

    protected void callListenersAddTemplate(Template tmpl) {
        ModuleChangedEvent ev = new ModuleChangedEvent((Object)this, (Module)this, tmpl);
        for (ModuleChangedListener listener : this.listeners) {
            listener.templateAdded(ev);
        }
    }

    protected void callListenersRemoveTemplate(Template tmpl) {
        ModuleChangedEvent ev = new ModuleChangedEvent((Object)this, (Module)this, tmpl);
        for (ModuleChangedListener listener : this.listeners) {
            listener.templateRemoved(ev);
        }
    }

    public Defmodule(String name, Modules modules) {
        this.name = name;
        this.modules = modules;
        this.listeners = new ArrayList<ModuleChangedListener>();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void clear() {
        this.modules.clearModule(this);
    }

    @Override
    public void clearRules() {
        this.modules.clearRules(this);
    }

    public void clearFacts() {
        this.modules.clearFacts(this);
    }

    @Override
    public void addRule(Rule rl) {
        this.modules.addRule(this, rl);
        this.callListenersAddRule(rl);
    }

    @Override
    public void removeRule(Rule rl) {
        this.callListenersRemoveRule(rl);
        this.modules.removeRule(this, rl);
    }

    @Override
    public boolean containsRule(Rule rl) {
        return this.modules.containsRule(this, rl);
    }

    @Override
    public List<Rule> getAllRules() {
        return this.modules.getRules(this);
    }

    @Override
    public int getRuleCount() {
        return this.getAllRules().size();
    }

    @Override
    public boolean containsTemplate(Template key) {
        return this.modules.containsTemplate(this, key);
    }

    @Override
    public Template getTemplate(String key) {
        return this.modules.getTemplate(this, key);
    }

    @Override
    public boolean addTemplate(Template temp) {
        boolean result = this.modules.addTemplate(this, temp);
        if (result) {
            this.modules.engine.getNet().addTemplate(temp);
            this.callListenersAddTemplate(temp);
        }
        return result;
    }

    @Override
    public void removeTemplate(Template temp) {
        this.callListenersRemoveTemplate(temp);
        this.modules.removeTemplate(this, temp);
    }

    @Override
    public List<Template> getTemplates() {
        return this.modules.getTemplates(this);
    }

    @Override
    public int getTemplateCount() {
        return this.getTemplates().size();
    }

    @Override
    public Rule findRule(String name) {
        return this.modules.findRule(this, name);
    }

    @Override
    public void addModuleChangedEventListener(ModuleChangedListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeModuleChangedEventListener(ModuleChangedListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public String getDump() {
        StringBuilder sb = new StringBuilder();
        sb.append("(def-module \"").append(this.getName()).append("\")");
        for (Rule r : this.getAllRules()) {
            sb.append(r.getDump());
        }
        return sb.toString();
    }
}

