/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.strings;

import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.IllegalParameterException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class StringReplace
extends AbstractFunction {
    public static final FunctionDescription DESCRIPTION = new Description();
    private static final long serialVersionUID = 1L;
    public static final String NAME = "str-replace";

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        String retstr = null;
        if (params == null || params.length != 3) {
            throw new IllegalParameterException(3);
        }
        String txt = params[0].getValue(engine).getStringValue();
        String regx = params[1].getValue(engine).getStringValue();
        String repl = params[2].getValue(engine).getStringValue();
        retstr = txt.replaceFirst(regx, repl);
        return JamochaValue.newString(retstr);
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "Replaces the first substring of the target string, given as first argument, that matches the regular expression given as second argument with the replacement from thethird argument.";
        }

        public int getParameterCount() {
            return 3;
        }

        public String getParameterDescription(int parameter) {
            switch (parameter) {
                case 0: {
                    return "String where the replacement takes place.";
                }
                case 1: {
                    return "Substring to search for (as regular expression).";
                }
                case 2: {
                    return "Replacement string.";
                }
            }
            return "";
        }

        public String getParameterName(int parameter) {
            switch (parameter) {
                case 0: {
                    return "targetString";
                }
                case 1: {
                    return "searchString";
                }
                case 2: {
                    return "replString";
                }
            }
            return "";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            return JamochaType.STRINGS;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.STRINGS;
        }

        public boolean isParameterCountFixed() {
            return true;
        }

        public boolean isParameterOptional(int parameter) {
            return false;
        }

        public String getExample() {
            return "(str-replace \"Jamocha\" \"m[io]ch\" \"maic\")";
        }

        public boolean isResultAutoGeneratable() {
            return true;
        }

        public Object getExpectedResult() {
            return "Jamaica";
        }
    }
}

