/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.ruleengine;

import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class UnProfile
extends AbstractFunction {
    public static final FunctionDescription DESCRIPTION = new Description();
    private static final long serialVersionUID = 1L;
    public static final String NAME = "unprofile";

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        if (params != null && params.length > 0) {
            for (int idx = 0; idx < params.length; ++idx) {
                JamochaValue param = params[idx].getValue(engine);
                if (!param.getStringValue().equals("all") && !param.getStringValue().equals("assert-fact") && !param.getStringValue().equals("add-activation") && !param.getStringValue().equals("fire") && !param.getStringValue().equals("retract-fact") && !param.getStringValue().equals("remove-activation")) continue;
            }
        }
        return JamochaValue.NIL;
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "Turns off profiling. There is the choice to turn off profiling of assert, retract, add activation, remove activation, and fire. Returns NIL.";
        }

        public int getParameterCount() {
            return 1;
        }

        public String getParameterDescription(int parameter) {
            return "What to unprofile. One or several of: all, assert-fact, add-activation, fire, retract-fact or remove-activation.";
        }

        public String getParameterName(int parameter) {
            return UnProfile.NAME;
        }

        public JamochaType[] getParameterTypes(int parameter) {
            return JamochaType.IDENTIFIERS;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.NONE;
        }

        public boolean isParameterCountFixed() {
            return false;
        }

        public boolean isParameterOptional(int parameter) {
            return parameter > 0;
        }

        public String getExample() {
            return "(profile all)\n(deftemplate templ1 (slot name))\n(print-profile)\n(unprofile assert-fact)";
        }

        public boolean isResultAutoGeneratable() {
            return false;
        }

        public Object getExpectedResult() {
            return null;
        }
    }
}

