/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.ruleengine;

import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.engine.nodes.Node;
import org.jamocha.engine.nodes.RootNode;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class TextView
extends AbstractFunction {
    public static final FunctionDescription DESCRIPTION = new Description();
    private static final long serialVersionUID = 1L;
    public static final String NAME = "text-view";

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public void dump(Node n, StringBuilder s, int indent) {
        StringBuilder s2 = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            s2.append(" ");
        }
        s.append((CharSequence)s2);
        String ind = "\n" + s2;
        s.append(n.toString().replace("\n", ind).trim()).append("\n");
        for (Node child : n.getChildNodes()) {
            this.dump(child, s, indent + 3);
        }
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        RootNode root = engine.getNet().getRoot();
        StringBuilder s = new StringBuilder();
        this.dump(root, s, 0);
        engine.writeMessage(s.toString());
        return JamochaValue.NIL;
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "Prints the rete network in text view";
        }

        public int getParameterCount() {
            return 0;
        }

        public String getParameterDescription(int parameter) {
            return "";
        }

        public String getParameterName(int parameter) {
            return "";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            return JamochaType.NONE;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.NONE;
        }

        public boolean isParameterCountFixed() {
            return true;
        }

        public boolean isParameterOptional(int parameter) {
            return false;
        }

        public String getExample() {
            return "(text-view)";
        }

        public boolean isResultAutoGeneratable() {
            return false;
        }

        public Object getExpectedResult() {
            return null;
        }
    }
}

