/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.ruleengine;

import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class SetFocus
extends AbstractFunction {
    public static final FunctionDescription DESCRIPTION = new Description();
    private static final long serialVersionUID = 1L;
    public static final String NAME = "set-focus";

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        String focus = null;
        if (params != null && params.length == 1) {
            focus = params[0].getValue(engine).getIdentifierValue();
            engine.setFocus(focus);
            focus = engine.getCurrentFocus().getName();
        } else {
            focus = engine.getCurrentFocus().getName();
        }
        return JamochaValue.newIdentifier(focus);
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "Sets the focus to the given module. If no argument is given the focus doesn't change. In either case the identifier of the current focus is returned.";
        }

        public int getParameterCount() {
            return 1;
        }

        public String getParameterDescription(int parameter) {
            return "Focus to set in the engine.";
        }

        public String getParameterName(int parameter) {
            return "focus";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            return JamochaType.IDENTIFIERS;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.IDENTIFIERS;
        }

        public boolean isParameterCountFixed() {
            return false;
        }

        public boolean isParameterOptional(int parameter) {
            return true;
        }

        public String getExample() {
            return "(defmodule MOCHA)\n(modules)\n(get-current-module)\n(set-focus MAIN)\n(get-current-module)";
        }

        public boolean isResultAutoGeneratable() {
            return true;
        }

        public Object getExpectedResult() {
            return "MAIN";
        }
    }
}

