/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.ruleengine;

import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.engine.util.ProfileStats;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class Profile
extends AbstractFunction {
    public static final FunctionDescription DESCRIPTION = new Description();
    private static final long serialVersionUID = 1L;
    public static final String NAME = "profile";

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        if (params != null) {
            if (params.length > 0) {
                for (int idx = 0; idx < params.length; ++idx) {
                    JamochaValue param = params[idx].getValue(engine);
                    if (!param.getIdentifierValue().equals("all") && !param.getIdentifierValue().equals("assert-fact") && !param.getIdentifierValue().equals("add-activation") && !param.getIdentifierValue().equals("fire") && !param.getIdentifierValue().equals("retract-fact") && !param.getIdentifierValue().equals("remove-activation")) continue;
                }
            } else {
                engine.writeMessage(ProfileStats.printResults());
            }
        }
        return JamochaValue.NIL;
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "Turns on profiling. Provides basic profiling of assert, retract, add activation, remove activation, and fire. Returns NIL.";
        }

        public int getParameterCount() {
            return 1;
        }

        public String getParameterDescription(int parameter) {
            return "What to profile. One or several of: all, assert-fact, add-activation, fire, retract-fact or remove-activation.";
        }

        public String getParameterName(int parameter) {
            return Profile.NAME;
        }

        public JamochaType[] getParameterTypes(int parameter) {
            return JamochaType.IDENTIFIERS;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.NONE;
        }

        public boolean isParameterCountFixed() {
            return false;
        }

        public boolean isParameterOptional(int parameter) {
            return parameter > 0;
        }

        public String getExample() {
            return "(profile assert-fact fire)";
        }

        public boolean isResultAutoGeneratable() {
            return false;
        }

        public Object getExpectedResult() {
            return null;
        }
    }
}

