/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.ruleengine;

import java.util.HashMap;
import java.util.List;
import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.engine.workingmemory.elements.Template;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class PPrintTemplate
extends AbstractFunction {
    public static final FunctionDescription DESCRIPTION = new Description();
    private static final long serialVersionUID = 1L;
    public static final String NAME = "ppdeftemplate";

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        HashMap<String, String> filter = new HashMap<String, String>();
        if (params != null && params.length > 0) {
            for (int idx = 0; idx < params.length; ++idx) {
                String df = params[idx].getValue(engine).getIdentifierValue();
                filter.put(df, df);
            }
        }
        List<Template> templ = engine.getCurrentFocus().getTemplates();
        for (Template tp : templ) {
            if (filter.get(tp.getName()) == null) continue;
            engine.writeMessage(tp.toPPString() + "\r\n", "t");
        }
        return JamochaValue.NIL;
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "Prints out one or more templates of the module currently in focus in a pretty format. Note the format may not be identical to what the user wrote. It is a normalized and cleaned up format.";
        }

        public int getParameterCount() {
            return 1;
        }

        public String getParameterDescription(int parameter) {
            return "One or more templates to print out in a pretty format.";
        }

        public String getParameterName(int parameter) {
            return "templateName";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            return JamochaType.IDENTIFIERS;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.NONE;
        }

        public boolean isParameterCountFixed() {
            return false;
        }

        public boolean isParameterOptional(int parameter) {
            return parameter > 1;
        }

        public String getExample() {
            return "(deftemplate car (slot color)(slot speed))\n(ppdeftemplate car)";
        }

        public boolean isResultAutoGeneratable() {
            return true;
        }

        public Object getExpectedResult() {
            return null;
        }
    }
}

