/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.ruleengine;

import java.util.Iterator;
import java.util.Map;
import org.jamocha.Constants;
import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.Function;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.engine.functions.FunctionGroup;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class ListFunctions
extends AbstractFunction {
    public static final FunctionDescription DESCRIPTION = new Description();
    private static final long serialVersionUID = 1L;
    public static final String NAME = "list-functions";

    public ListFunctions() {
        this.aliases.add("list-deffunctions");
        this.aliases.add("functions");
    }

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        Map<String, FunctionGroup> fgroups = engine.getFunctionMemory().getFunctionGroups();
        Iterator<FunctionGroup> itr = fgroups.values().iterator();
        int counter = 0;
        while (itr.hasNext()) {
            FunctionGroup fg = itr.next();
            engine.writeMessage(fg.getName() + ":" + Constants.LINEBREAK, "t");
            for (Function f : fg.listFunctions()) {
                engine.writeMessage(" - " + f.getName() + Constants.LINEBREAK, "t");
                ++counter;
            }
        }
        engine.writeMessage(counter + " functions" + Constants.LINEBREAK, "t");
        return JamochaValue.NIL;
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "Prints out a list of all defined functions. The return value is NIL.";
        }

        public int getParameterCount() {
            return 0;
        }

        public String getParameterDescription(int parameter) {
            return "";
        }

        public String getParameterName(int parameter) {
            return "";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            return JamochaType.NONE;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.NONE;
        }

        public boolean isParameterCountFixed() {
            return true;
        }

        public boolean isParameterOptional(int parameter) {
            return false;
        }

        public String getExample() {
            return "(list-functions)";
        }

        public boolean isResultAutoGeneratable() {
            return true;
        }

        public Object getExpectedResult() {
            return null;
        }
    }
}

