/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.ruleengine;

import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.engine.workingmemory.elements.Fact;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.IllegalParameterException;
import org.jamocha.parser.IllegalTypeException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;

public class GetFactId
extends AbstractFunction {
    public static final FunctionDescription DESCRIPTION = new FindFactByFactDescription();
    private static final long serialVersionUID = 1L;
    public static final String NAME = "get-fact-id";

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        if (params != null && params.length == 1) {
            JamochaValue param = params[0].getValue(engine);
            if (param.is(JamochaType.FACT)) {
                Fact fact = param.getFactValue();
                if (fact == null) {
                    return JamochaValue.newFactId(0L);
                }
                return JamochaValue.newFactId(fact.getFactId());
            }
            throw new IllegalTypeException(DESCRIPTION.getParameterTypes(0), param.getType());
        }
        throw new IllegalParameterException(1);
    }

    private static final class FindFactByFactDescription
    implements FunctionDescription {
        private FindFactByFactDescription() {
        }

        public String getDescription() {
            return "Returns the fact-ID of the given fact.";
        }

        public int getParameterCount() {
            return 1;
        }

        public String getParameterDescription(int parameter) {
            return "Fact to return the ID of.";
        }

        public String getParameterName(int parameter) {
            return "fact";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            return JamochaType.FACTS;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.FACT_IDS;
        }

        public boolean isParameterCountFixed() {
            return true;
        }

        public boolean isParameterOptional(int parameter) {
            return false;
        }

        public String getExample() {
            return null;
        }

        public boolean isResultAutoGeneratable() {
            return false;
        }

        public Object getExpectedResult() {
            return null;
        }
    }
}

