/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.engine.functions.ruleengine;

import java.io.StringReader;
import org.jamocha.engine.Engine;
import org.jamocha.engine.Parameter;
import org.jamocha.engine.configurations.Signature;
import org.jamocha.engine.functions.AbstractFunction;
import org.jamocha.engine.functions.FunctionDescription;
import org.jamocha.engine.functions.FunctionNotFoundException;
import org.jamocha.parser.EvaluationException;
import org.jamocha.parser.Expression;
import org.jamocha.parser.IllegalParameterException;
import org.jamocha.parser.JamochaType;
import org.jamocha.parser.JamochaValue;
import org.jamocha.parser.ParseException;
import org.jamocha.parser.Parser;
import org.jamocha.parser.ParserFactory;

public class FunctionExists
extends AbstractFunction {
    public static final FunctionDescription DESCRIPTION = new Description();
    private static final long serialVersionUID = 1L;
    public static final String NAME = "function-exists";

    public FunctionDescription getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public JamochaValue executeFunction(Engine engine, Parameter[] params) throws EvaluationException {
        if (params == null || params.length != 1) {
            throw new IllegalParameterException(1);
        }
        String command = params[0].getValue(engine).getStringValue();
        JamochaValue result = this.checkFunctionCall(engine, command);
        return result;
    }

    public JamochaValue checkFunctionCall(Engine engine, String command) throws EvaluationException {
        JamochaValue result = JamochaValue.FALSE;
        try {
            Parser parser = ParserFactory.getParser(new StringReader(command));
            Expression expr = parser.nextExpression();
            if (expr instanceof Signature) {
                Signature sig = (Signature)expr;
                try {
                    engine.getFunctionMemory().findFunction(sig.getSignatureName());
                    result = JamochaValue.TRUE;
                }
                catch (FunctionNotFoundException e) {
                    // empty catch block
                }
            }
            while ((expr = parser.nextExpression()) != null) {
            }
        }
        catch (ParseException e) {
            throw new EvaluationException(e);
        }
        return result;
    }

    private static final class Description
    implements FunctionDescription {
        private Description() {
        }

        public String getDescription() {
            return "Takes a CLIPS string as argument and uses the default parser to parse it. If the first statement is a function call, the FunctionMemory is checked wether a function with this name exists. If it does it returns true otherwise (or if the first statement is no function call) it returns false.";
        }

        public int getParameterCount() {
            return 1;
        }

        public String getParameterDescription(int parameter) {
            return "One command as one single string.";
        }

        public String getParameterName(int parameter) {
            return "command";
        }

        public JamochaType[] getParameterTypes(int parameter) {
            return JamochaType.STRINGS;
        }

        public JamochaType[] getReturnType() {
            return JamochaType.ANY;
        }

        public boolean isParameterCountFixed() {
            return true;
        }

        public boolean isParameterOptional(int parameter) {
            return false;
        }

        public String getExample() {
            return "(function-exists \"(cos)\")\n(function-exists \"(i-dont-exist)\")";
        }

        public boolean isResultAutoGeneratable() {
            return true;
        }

        public Object getExpectedResult() {
            return JamochaValue.FALSE;
        }
    }
}

